(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9112,        312]
NotebookOptionsPosition[      7434,        257]
NotebookOutlinePosition[      8416,        285]
CellTagsIndexPosition[      8373,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gsharp2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gsharp2"], "A2" :> 
          Documentation`HelpLookup["paclet:Music/ref/A2"], "Asharp2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Asharp2"], "Aflat1" :> 
          Documentation`HelpLookup["paclet:Music/ref/Aflat1"], "Aflat3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Aflat3"], "C2" :> 
          Documentation`HelpLookup["paclet:Music/ref/C2"], "D2" :> 
          Documentation`HelpLookup["paclet:Music/ref/D2"], "E2" :> 
          Documentation`HelpLookup["paclet:Music/ref/E2"], "F2" :> 
          Documentation`HelpLookup["paclet:Music/ref/F2"], "G2" :> 
          Documentation`HelpLookup["paclet:Music/ref/G2"], "B2" :> 
          Documentation`HelpLookup["paclet:Music/ref/B2"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Gsharp2\"\>", 2->"\<\"A2\"\>", 
       3->"\<\"Asharp2\"\>", 4->"\<\"Aflat1\"\>", 5->"\<\"Aflat3\"\>", 
       6->"\<\"C2\"\>", 7->"\<\"D2\"\>", 8->"\<\"E2\"\>", 9->"\<\"F2\"\>", 
       10->"\<\"G2\"\>", 11->"\<\"B2\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Aflat2", "ObjectName",
 CellID->3725],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Aflat2"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note A-flat in octave 2."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14426]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Aflat2"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->24215],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6312]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4593],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gsharp2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gsharp2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Asharp2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Asharp2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Aflat1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Aflat1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Aflat3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Aflat3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B2"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12422]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23815],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->3424]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Aflat2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 59.9476218}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Aflat2 gives the frequency of the note A-flat in octave 2.",
     "synonyms" -> {}, "title" -> "Aflat2", "type" -> "Symbol", "uri" -> 
    "Music/ref/Aflat2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 43, 1, 70, "ObjectName",
 CellID->3725],
Cell[2710, 73, 347, 10, 70, "Usage",
 CellID->14426]
}, Open  ]],
Cell[CellGroupData[{
Cell[3094, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3572, 105, 152, 4, 70, "Notes",
 CellID->24215],
Cell[3727, 111, 201, 8, 70, "Notes",
 CellID->6312]
}, Closed]],
Cell[CellGroupData[{
Cell[3965, 124, 310, 9, 70, "SeeAlsoSection",
 CellID->4593],
Cell[4278, 135, 2626, 98, 70, "SeeAlso",
 CellID->12422]
}, Open  ]],
Cell[CellGroupData[{
Cell[6941, 238, 314, 9, 70, "TutorialsSection",
 CellID->23815],
Cell[7258, 249, 134, 3, 70, "Tutorials",
 CellID->3424]
}, Open  ]],
Cell[7407, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

