(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9110,        312]
NotebookOptionsPosition[      7433,        257]
NotebookOutlinePosition[      8415,        285]
CellTagsIndexPosition[      8372,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Asharp4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Asharp4"], "B4" :> 
          Documentation`HelpLookup["paclet:Music/ref/B4"], "Bsharp4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bsharp4"], "Bflat3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bflat3"], "Bflat5" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bflat5"], "C4" :> 
          Documentation`HelpLookup["paclet:Music/ref/C4"], "D4" :> 
          Documentation`HelpLookup["paclet:Music/ref/D4"], "E4" :> 
          Documentation`HelpLookup["paclet:Music/ref/E4"], "F4" :> 
          Documentation`HelpLookup["paclet:Music/ref/F4"], "G4" :> 
          Documentation`HelpLookup["paclet:Music/ref/G4"], "A4" :> 
          Documentation`HelpLookup["paclet:Music/ref/A4"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Asharp4\"\>", 2->"\<\"B4\"\>", 
       3->"\<\"Bsharp4\"\>", 4->"\<\"Bflat3\"\>", 5->"\<\"Bflat5\"\>", 
       6->"\<\"C4\"\>", 7->"\<\"D4\"\>", 8->"\<\"E4\"\>", 9->"\<\"F4\"\>", 
       10->"\<\"G4\"\>", 11->"\<\"A4\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bflat4", "ObjectName",
 CellID->24408],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bflat4"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note B-flat in octave 4."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Bflat4"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->1908],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17223]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4319],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Asharp4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Asharp4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bsharp4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bsharp4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bflat3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bflat3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bflat5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bflat5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A4"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11759],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->26434]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bflat4 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 1, 23.6357282}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Bflat4 gives the frequency of the note B-flat in octave 4.",
     "synonyms" -> {}, "title" -> "Bflat4", "type" -> "Symbol", "uri" -> 
    "Music/ref/Bflat4"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 44, 1, 70, "ObjectName",
 CellID->24408],
Cell[2711, 73, 346, 10, 70, "Usage",
 CellID->4415]
}, Open  ]],
Cell[CellGroupData[{
Cell[3094, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3572, 105, 151, 4, 70, "Notes",
 CellID->1908],
Cell[3726, 111, 202, 8, 70, "Notes",
 CellID->17223]
}, Closed]],
Cell[CellGroupData[{
Cell[3965, 124, 310, 9, 70, "SeeAlsoSection",
 CellID->4319],
Cell[4278, 135, 2624, 98, 70, "SeeAlso",
 CellID->958]
}, Open  ]],
Cell[CellGroupData[{
Cell[6939, 238, 314, 9, 70, "TutorialsSection",
 CellID->11759],
Cell[7256, 249, 135, 3, 70, "Tutorials",
 CellID->26434]
}, Open  ]],
Cell[7406, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

