(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9114,        312]
NotebookOptionsPosition[      7435,        257]
NotebookOutlinePosition[      8417,        285]
CellTagsIndexPosition[      8374,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Asharp5" :> 
          Documentation`HelpLookup["paclet:Music/ref/Asharp5"], "B5" :> 
          Documentation`HelpLookup["paclet:Music/ref/B5"], "Bsharp5" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bsharp5"], "Bflat4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bflat4"], "Bflat6" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bflat6"], "C5" :> 
          Documentation`HelpLookup["paclet:Music/ref/C5"], "D5" :> 
          Documentation`HelpLookup["paclet:Music/ref/D5"], "E5" :> 
          Documentation`HelpLookup["paclet:Music/ref/E5"], "F5" :> 
          Documentation`HelpLookup["paclet:Music/ref/F5"], "G5" :> 
          Documentation`HelpLookup["paclet:Music/ref/G5"], "A5" :> 
          Documentation`HelpLookup["paclet:Music/ref/A5"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Asharp5\"\>", 2->"\<\"B5\"\>", 
       3->"\<\"Bsharp5\"\>", 4->"\<\"Bflat4\"\>", 5->"\<\"Bflat6\"\>", 
       6->"\<\"C5\"\>", 7->"\<\"D5\"\>", 8->"\<\"E5\"\>", 9->"\<\"F5\"\>", 
       10->"\<\"G5\"\>", 11->"\<\"A5\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bflat5", "ObjectName",
 CellID->7727],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bflat5"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note B-flat in octave 5."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29426]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Bflat5"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->15871],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10697]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5545],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Asharp5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Asharp5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bsharp5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bsharp5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bflat4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bflat4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bflat6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bflat6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A5"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9508]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17612],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->18703]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bflat5 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 1, 23.8232330}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Bflat5 gives the frequency of the note B-flat in octave 5.",
     "synonyms" -> {}, "title" -> "Bflat5", "type" -> "Symbol", "uri" -> 
    "Music/ref/Bflat5"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 43, 1, 70, "ObjectName",
 CellID->7727],
Cell[2710, 73, 347, 10, 70, "Usage",
 CellID->29426]
}, Open  ]],
Cell[CellGroupData[{
Cell[3094, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3572, 105, 152, 4, 70, "Notes",
 CellID->15871],
Cell[3727, 111, 202, 8, 70, "Notes",
 CellID->10697]
}, Closed]],
Cell[CellGroupData[{
Cell[3966, 124, 310, 9, 70, "SeeAlsoSection",
 CellID->5545],
Cell[4279, 135, 2625, 98, 70, "SeeAlso",
 CellID->9508]
}, Open  ]],
Cell[CellGroupData[{
Cell[6941, 238, 314, 9, 70, "TutorialsSection",
 CellID->17612],
Cell[7258, 249, 135, 3, 70, "Tutorials",
 CellID->18703]
}, Open  ]],
Cell[7408, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

