(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9112,        312]
NotebookOptionsPosition[      7434,        257]
NotebookOutlinePosition[      8416,        285]
CellTagsIndexPosition[      8373,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dsharp5" :> 
          Documentation`HelpLookup["paclet:Music/ref/Dsharp5"], "E5" :> 
          Documentation`HelpLookup["paclet:Music/ref/E5"], "Esharp5" :> 
          Documentation`HelpLookup["paclet:Music/ref/Esharp5"], "Eflat4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat4"], "Eflat6" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat6"], "C5" :> 
          Documentation`HelpLookup["paclet:Music/ref/C5"], "D5" :> 
          Documentation`HelpLookup["paclet:Music/ref/D5"], "F5" :> 
          Documentation`HelpLookup["paclet:Music/ref/F5"], "G5" :> 
          Documentation`HelpLookup["paclet:Music/ref/G5"], "A5" :> 
          Documentation`HelpLookup["paclet:Music/ref/A5"], "B5" :> 
          Documentation`HelpLookup["paclet:Music/ref/B5"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dsharp5\"\>", 2->"\<\"E5\"\>", 
       3->"\<\"Esharp5\"\>", 4->"\<\"Eflat4\"\>", 5->"\<\"Eflat6\"\>", 
       6->"\<\"C5\"\>", 7->"\<\"D5\"\>", 8->"\<\"F5\"\>", 9->"\<\"G5\"\>", 
       10->"\<\"A5\"\>", 11->"\<\"B5\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eflat5", "ObjectName",
 CellID->19670],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Eflat5"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note E-flat in octave 5."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14536]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Eflat5"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->3281],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23370]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16835],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dsharp5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Dsharp5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Esharp5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Esharp5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B5"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3573]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6549],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->1348]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eflat5 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 2, 34.4031648}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Eflat5 gives the frequency of the note E-flat in octave 5.",
     "synonyms" -> {}, "title" -> "Eflat5", "type" -> "Symbol", "uri" -> 
    "Music/ref/Eflat5"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 44, 1, 70, "ObjectName",
 CellID->19670],
Cell[2711, 73, 347, 10, 70, "Usage",
 CellID->14536]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3573, 105, 151, 4, 70, "Notes",
 CellID->3281],
Cell[3727, 111, 202, 8, 70, "Notes",
 CellID->23370]
}, Closed]],
Cell[CellGroupData[{
Cell[3966, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->16835],
Cell[4280, 135, 2625, 98, 70, "SeeAlso",
 CellID->3573]
}, Open  ]],
Cell[CellGroupData[{
Cell[6942, 238, 313, 9, 70, "TutorialsSection",
 CellID->6549],
Cell[7258, 249, 134, 3, 70, "Tutorials",
 CellID->1348]
}, Open  ]],
Cell[7407, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

