(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8774,        302]
NotebookOptionsPosition[      7084,        246]
NotebookOutlinePosition[      8076,        275]
CellTagsIndexPosition[      8033,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"F1" :> Documentation`HelpLookup["paclet:Music/ref/F1"], "E1" :> 
          Documentation`HelpLookup["paclet:Music/ref/E1"], "Eflat1" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat1"], "Esharp0" :> 
          Documentation`HelpLookup["paclet:Music/ref/Esharp0"], "Esharp2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Esharp2"], "C1" :> 
          Documentation`HelpLookup["paclet:Music/ref/C1"], "D1" :> 
          Documentation`HelpLookup["paclet:Music/ref/D1"], "G1" :> 
          Documentation`HelpLookup["paclet:Music/ref/G1"], "A1" :> 
          Documentation`HelpLookup["paclet:Music/ref/A1"], "B1" :> 
          Documentation`HelpLookup["paclet:Music/ref/B1"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"F1\"\>", 2->"\<\"E1\"\>", 
       3->"\<\"Eflat1\"\>", 4->"\<\"Esharp0\"\>", 5->"\<\"Esharp2\"\>", 
       6->"\<\"C1\"\>", 7->"\<\"D1\"\>", 8->"\<\"G1\"\>", 9->"\<\"A1\"\>", 
       10->"\<\"B1\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Esharp1", "ObjectName",
 CellID->22166],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Esharp1"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note E-sharp in octave 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30121]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Esharp1"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->27782],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2782]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22195],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["F1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Esharp0",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Esharp0"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Esharp2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Esharp2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B1"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13143]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27006],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->6491]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Esharp1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 2, 35.1219332}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "Esharp1 gives the frequency of the note E-sharp in octave 1.", 
    "synonyms" -> {}, "title" -> "Esharp1", "type" -> "Symbol", "uri" -> 
    "Music/ref/Esharp1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1932, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2555, 68, 45, 1, 70, "ObjectName",
 CellID->22166],
Cell[2603, 71, 349, 10, 70, "Usage",
 CellID->30121]
}, Open  ]],
Cell[CellGroupData[{
Cell[2989, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3467, 103, 153, 4, 70, "Notes",
 CellID->27782],
Cell[3623, 109, 201, 8, 70, "Notes",
 CellID->2782]
}, Closed]],
Cell[CellGroupData[{
Cell[3861, 122, 311, 9, 70, "SeeAlsoSection",
 CellID->22195],
Cell[4175, 133, 2379, 89, 70, "SeeAlso",
 CellID->13143]
}, Open  ]],
Cell[CellGroupData[{
Cell[6591, 227, 314, 9, 70, "TutorialsSection",
 CellID->27006],
Cell[6908, 238, 134, 3, 70, "Tutorials",
 CellID->6491]
}, Open  ]],
Cell[7057, 244, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

