(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8759,        301]
NotebookOptionsPosition[      7077,        246]
NotebookOutlinePosition[      8059,        274]
CellTagsIndexPosition[      8016,        271]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"E2" :> Documentation`HelpLookup["paclet:Music/ref/E2"], "F2" :> 
          Documentation`HelpLookup["paclet:Music/ref/F2"], "Fsharp2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fsharp2"], "Fflat1" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fflat1"], "Fflat3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fflat3"], "C2" :> 
          Documentation`HelpLookup["paclet:Music/ref/C2"], "D2" :> 
          Documentation`HelpLookup["paclet:Music/ref/D2"], "G2" :> 
          Documentation`HelpLookup["paclet:Music/ref/G2"], "A2" :> 
          Documentation`HelpLookup["paclet:Music/ref/A2"], "B2" :> 
          Documentation`HelpLookup["paclet:Music/ref/B2"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"E2\"\>", 2->"\<\"F2\"\>", 
       3->"\<\"Fsharp2\"\>", 4->"\<\"Fflat1\"\>", 5->"\<\"Fflat3\"\>", 
       6->"\<\"C2\"\>", 7->"\<\"D2\"\>", 8->"\<\"G2\"\>", 9->"\<\"A2\"\>", 
       10->"\<\"B2\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fflat2", "ObjectName",
 CellID->19718],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Fflat2"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note F-flat in octave 2."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23412]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Fflat2"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->14377],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26623]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18720],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["E2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fsharp2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fsharp2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fflat1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fflat1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fflat3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fflat3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B2"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11472],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->11983]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fflat2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 2, 50.9504634}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Fflat2 gives the frequency of the note F-flat in octave 2.",
     "synonyms" -> {}, "title" -> "Fflat2", "type" -> "Symbol", "uri" -> 
    "Music/ref/Fflat2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1929, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2552, 68, 44, 1, 70, "ObjectName",
 CellID->19718],
Cell[2599, 71, 347, 10, 70, "Usage",
 CellID->23412]
}, Open  ]],
Cell[CellGroupData[{
Cell[2983, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3461, 103, 152, 4, 70, "Notes",
 CellID->14377],
Cell[3616, 109, 202, 8, 70, "Notes",
 CellID->26623]
}, Closed]],
Cell[CellGroupData[{
Cell[3855, 122, 311, 9, 70, "SeeAlsoSection",
 CellID->18720],
Cell[4169, 133, 2377, 89, 70, "SeeAlso",
 CellID->16257]
}, Open  ]],
Cell[CellGroupData[{
Cell[6583, 227, 314, 9, 70, "TutorialsSection",
 CellID->11472],
Cell[6900, 238, 135, 3, 70, "Tutorials",
 CellID->11983]
}, Open  ]],
Cell[7050, 244, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

