(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8408,        291]
NotebookOptionsPosition[      6729,        236]
NotebookOutlinePosition[      7711,        264]
CellTagsIndexPosition[      7668,        261]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"E7" :> Documentation`HelpLookup["paclet:Music/ref/E7"], "F7" :> 
          Documentation`HelpLookup["paclet:Music/ref/F7"], "Fsharp7" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fsharp7"], "Fflat6" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fflat6"], "C7" :> 
          Documentation`HelpLookup["paclet:Music/ref/C7"], "D7" :> 
          Documentation`HelpLookup["paclet:Music/ref/D7"], "G7" :> 
          Documentation`HelpLookup["paclet:Music/ref/G7"], "A7" :> 
          Documentation`HelpLookup["paclet:Music/ref/A7"], "B7" :> 
          Documentation`HelpLookup["paclet:Music/ref/B7"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"E7\"\>", 2->"\<\"F7\"\>", 
       3->"\<\"Fsharp7\"\>", 4->"\<\"Fflat6\"\>", 5->"\<\"C7\"\>", 
       6->"\<\"D7\"\>", 7->"\<\"G7\"\>", 8->"\<\"A7\"\>", 
       9->"\<\"B7\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fflat7", "ObjectName",
 CellID->22105],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Fflat7"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note F-flat in octave 7."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Fflat7"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->5937],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1366]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18182],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["E7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E7"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F7"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fsharp7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fsharp7"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fflat6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fflat6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C7"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D7"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G7"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A7"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B7"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19635]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3914],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->23155]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fflat7 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 2, 51.8723620}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Fflat7 gives the frequency of the note F-flat in octave 7.",
     "synonyms" -> {}, "title" -> "Fflat7", "type" -> "Symbol", "uri" -> 
    "Music/ref/Fflat7"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1831, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2454, 67, 44, 1, 70, "ObjectName",
 CellID->22105],
Cell[2501, 70, 347, 10, 70, "Usage",
 CellID->20526]
}, Open  ]],
Cell[CellGroupData[{
Cell[2885, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3363, 102, 151, 4, 70, "Notes",
 CellID->5937],
Cell[3517, 108, 201, 8, 70, "Notes",
 CellID->1366]
}, Closed]],
Cell[CellGroupData[{
Cell[3755, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->18182],
Cell[4069, 132, 2130, 80, 70, "SeeAlso",
 CellID->19635]
}, Open  ]],
Cell[CellGroupData[{
Cell[6236, 217, 313, 9, 70, "TutorialsSection",
 CellID->3914],
Cell[6552, 228, 135, 3, 70, "Tutorials",
 CellID->23155]
}, Open  ]],
Cell[6702, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

