(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9115,        312]
NotebookOptionsPosition[      7427,        256]
NotebookOutlinePosition[      8419,        285]
CellTagsIndexPosition[      8376,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gflat5" :> Documentation`HelpLookup["paclet:Music/ref/Gflat5"],
           "F5" :> Documentation`HelpLookup["paclet:Music/ref/F5"], "Fflat5" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fflat5"], "Fsharp4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fsharp4"], "Fsharp6" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fsharp6"], "C5" :> 
          Documentation`HelpLookup["paclet:Music/ref/C5"], "D5" :> 
          Documentation`HelpLookup["paclet:Music/ref/D5"], "E5" :> 
          Documentation`HelpLookup["paclet:Music/ref/E5"], "G5" :> 
          Documentation`HelpLookup["paclet:Music/ref/G5"], "A5" :> 
          Documentation`HelpLookup["paclet:Music/ref/A5"], "B5" :> 
          Documentation`HelpLookup["paclet:Music/ref/B5"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Gflat5\"\>", 2->"\<\"F5\"\>", 
       3->"\<\"Fflat5\"\>", 4->"\<\"Fsharp4\"\>", 5->"\<\"Fsharp6\"\>", 
       6->"\<\"C5\"\>", 7->"\<\"D5\"\>", 8->"\<\"E5\"\>", 9->"\<\"G5\"\>", 
       10->"\<\"A5\"\>", 11->"\<\"B5\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fsharp5", "ObjectName",
 CellID->27451],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Fsharp5"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note F-sharp in octave 5."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1814]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Fsharp5"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->31599],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->216]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20912],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gflat5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gflat5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fflat5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fflat5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fsharp4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fsharp4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fsharp6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fsharp6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B5"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10141]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23212],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->6834]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fsharp5 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 2, 59.3100524}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "Fsharp5 gives the frequency of the note F-sharp in octave 5.", 
    "synonyms" -> {}, "title" -> "Fsharp5", "type" -> "Symbol", "uri" -> 
    "Music/ref/Fsharp5"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2030, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2653, 69, 45, 1, 70, "ObjectName",
 CellID->27451],
Cell[2701, 72, 348, 10, 70, "Usage",
 CellID->1814]
}, Open  ]],
Cell[CellGroupData[{
Cell[3086, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3564, 104, 153, 4, 70, "Notes",
 CellID->31599],
Cell[3720, 110, 200, 8, 70, "Notes",
 CellID->216]
}, Closed]],
Cell[CellGroupData[{
Cell[3957, 123, 311, 9, 70, "SeeAlsoSection",
 CellID->20912],
Cell[4271, 134, 2626, 98, 70, "SeeAlso",
 CellID->10141]
}, Open  ]],
Cell[CellGroupData[{
Cell[6934, 237, 314, 9, 70, "TutorialsSection",
 CellID->23212],
Cell[7251, 248, 134, 3, 70, "Tutorials",
 CellID->6834]
}, Open  ]],
Cell[7400, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

