(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9112,        312]
NotebookOptionsPosition[      7434,        257]
NotebookOutlinePosition[      8416,        285]
CellTagsIndexPosition[      8373,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fsharp2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fsharp2"], "G2" :> 
          Documentation`HelpLookup["paclet:Music/ref/G2"], "Gsharp2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gsharp2"], "Gflat1" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gflat1"], "Gflat3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gflat3"], "C2" :> 
          Documentation`HelpLookup["paclet:Music/ref/C2"], "D2" :> 
          Documentation`HelpLookup["paclet:Music/ref/D2"], "E2" :> 
          Documentation`HelpLookup["paclet:Music/ref/E2"], "F2" :> 
          Documentation`HelpLookup["paclet:Music/ref/F2"], "A2" :> 
          Documentation`HelpLookup["paclet:Music/ref/A2"], "B2" :> 
          Documentation`HelpLookup["paclet:Music/ref/B2"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fsharp2\"\>", 2->"\<\"G2\"\>", 
       3->"\<\"Gsharp2\"\>", 4->"\<\"Gflat1\"\>", 5->"\<\"Gflat3\"\>", 
       6->"\<\"C2\"\>", 7->"\<\"D2\"\>", 8->"\<\"E2\"\>", 9->"\<\"F2\"\>", 
       10->"\<\"A2\"\>", 11->"\<\"B2\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Gflat2", "ObjectName",
 CellID->29700],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Gflat2"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note G-flat in octave 2."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24234]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Gflat2"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->25606],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10680]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->485],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fsharp2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fsharp2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gsharp2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gsharp2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gflat1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gflat1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gflat3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gflat3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B2"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19634]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9790],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->6923]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gflat2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 14.4198142}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Gflat2 gives the frequency of the note G-flat in octave 2.",
     "synonyms" -> {}, "title" -> "Gflat2", "type" -> "Symbol", "uri" -> 
    "Music/ref/Gflat2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 44, 1, 70, "ObjectName",
 CellID->29700],
Cell[2711, 73, 347, 10, 70, "Usage",
 CellID->24234]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3573, 105, 152, 4, 70, "Notes",
 CellID->25606],
Cell[3728, 111, 202, 8, 70, "Notes",
 CellID->10680]
}, Closed]],
Cell[CellGroupData[{
Cell[3967, 124, 309, 9, 70, "SeeAlsoSection",
 CellID->485],
Cell[4279, 135, 2626, 98, 70, "SeeAlso",
 CellID->19634]
}, Open  ]],
Cell[CellGroupData[{
Cell[6942, 238, 313, 9, 70, "TutorialsSection",
 CellID->9790],
Cell[7258, 249, 134, 3, 70, "Tutorials",
 CellID->6923]
}, Open  ]],
Cell[7407, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

