(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9110,        312]
NotebookOptionsPosition[      7433,        257]
NotebookOutlinePosition[      8415,        285]
CellTagsIndexPosition[      8372,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fsharp6" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fsharp6"], "G6" :> 
          Documentation`HelpLookup["paclet:Music/ref/G6"], "Gsharp6" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gsharp6"], "Gflat5" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gflat5"], "Gflat7" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gflat7"], "C6" :> 
          Documentation`HelpLookup["paclet:Music/ref/C6"], "D6" :> 
          Documentation`HelpLookup["paclet:Music/ref/D6"], "E6" :> 
          Documentation`HelpLookup["paclet:Music/ref/E6"], "F6" :> 
          Documentation`HelpLookup["paclet:Music/ref/F6"], "A6" :> 
          Documentation`HelpLookup["paclet:Music/ref/A6"], "B6" :> 
          Documentation`HelpLookup["paclet:Music/ref/B6"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fsharp6\"\>", 2->"\<\"G6\"\>", 
       3->"\<\"Gsharp6\"\>", 4->"\<\"Gflat5\"\>", 5->"\<\"Gflat7\"\>", 
       6->"\<\"C6\"\>", 7->"\<\"D6\"\>", 8->"\<\"E6\"\>", 9->"\<\"F6\"\>", 
       10->"\<\"A6\"\>", 11->"\<\"B6\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Gflat6", "ObjectName",
 CellID->16145],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Gflat6"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note G-flat in octave 6."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Gflat6"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->13659],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9324]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2094],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fsharp6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fsharp6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gsharp6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gsharp6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gflat5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gflat5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gflat7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gflat7"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B6"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10849]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->767],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->4966]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gflat6 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 15.2167096}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Gflat6 gives the frequency of the note G-flat in octave 6.",
     "synonyms" -> {}, "title" -> "Gflat6", "type" -> "Symbol", "uri" -> 
    "Music/ref/Gflat6"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 44, 1, 70, "ObjectName",
 CellID->16145],
Cell[2711, 73, 347, 10, 70, "Usage",
 CellID->15729]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3573, 105, 152, 4, 70, "Notes",
 CellID->13659],
Cell[3728, 111, 201, 8, 70, "Notes",
 CellID->9324]
}, Closed]],
Cell[CellGroupData[{
Cell[3966, 124, 310, 9, 70, "SeeAlsoSection",
 CellID->2094],
Cell[4279, 135, 2626, 98, 70, "SeeAlso",
 CellID->10849]
}, Open  ]],
Cell[CellGroupData[{
Cell[6942, 238, 312, 9, 70, "TutorialsSection",
 CellID->767],
Cell[7257, 249, 134, 3, 70, "Tutorials",
 CellID->4966]
}, Open  ]],
Cell[7406, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

