(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8202,        294]
NotebookOptionsPosition[      6305,        231]
NotebookOutlinePosition[      7293,        259]
CellTagsIndexPosition[      7250,        256]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JustMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/JustMinor"], 
          "PythagoreanMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/PythagoreanMajor"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"JustMinor\"\>", 
       2->"\<\"PythagoreanMajor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JustMajor", "ObjectName",
 CellID->31588],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["JustMajor"], "InlineFormula"],
     " \[LineSeparator]is an interval list for the Just Major scale."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Intervals are measured in cents.", "Notes",
 CellID->18334],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"JustMajor", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to the Just Major \
scale."
}], "Notes",
 CellID->26913],

Cell[TextData[{
 "In the Just Major scale the ratios of the 3",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "rd"], TraditionalForm]]],
 ", 6",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 ", and 7",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " intervals are simplified from the Pythagorean model."
}], "Notes",
 CellID->29023],

Cell[TextData[{
 "Whereas in the Pythagorean scale the ratios are 81/64 for a 3",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "rd"], TraditionalForm]]],
 ", 27/16 for a 6",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 ", and 243/128 for a 7",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 ", in Just Intonation the ratios are 5/4 for a 3",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "rd"], TraditionalForm]]],
 ", 5/3 for a 6",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 ", and 15/8 for a 7",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 "."
}], "Notes",
 CellID->1476],

Cell["The other intervals are the same as the Pythagorean scale.", "Notes",
 CellID->9963],

Cell[TextData[{
 Cell[BoxData["JustMajor"], "InlineFormula"],
 " was invented by the theorist Zarlino in the 16",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " century so that simultaneously sounding tones would have simple ratios."
}], "Notes",
 CellID->14177]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9266],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JustMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/JustMinor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PythagoreanMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/PythagoreanMajor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23627]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15726],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->2922]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JustMajor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 23.5606732}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "JustMajor is an interval list for the Just Major scale.", 
    "synonyms" -> {}, "title" -> "JustMajor", "type" -> "Symbol", "uri" -> 
    "Music/ref/JustMajor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1279, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1902, 60, 47, 1, 70, "ObjectName",
 CellID->31588],
Cell[1952, 63, 343, 10, 70, "Usage",
 CellID->7785]
}, Open  ]],
Cell[CellGroupData[{
Cell[2332, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2810, 95, 65, 1, 70, "Notes",
 CellID->18334],
Cell[2878, 98, 504, 17, 70, "Notes",
 CellID->26913],
Cell[3385, 117, 415, 15, 70, "Notes",
 CellID->29023],
Cell[3803, 134, 745, 27, 70, "Notes",
 CellID->1476],
Cell[4551, 163, 90, 1, 70, "Notes",
 CellID->9963],
Cell[4644, 166, 300, 8, 70, "Notes",
 CellID->14177]
}, Closed]],
Cell[CellGroupData[{
Cell[4981, 179, 310, 9, 70, "SeeAlsoSection",
 CellID->9266],
Cell[5294, 190, 481, 17, 70, "SeeAlso",
 CellID->23627]
}, Open  ]],
Cell[CellGroupData[{
Cell[5812, 212, 314, 9, 70, "TutorialsSection",
 CellID->15726],
Cell[6129, 223, 134, 3, 70, "Tutorials",
 CellID->2922]
}, Open  ]],
Cell[6278, 229, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

