(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6736,        240]
NotebookOptionsPosition[      4977,        182]
NotebookOutlinePosition[      5988,        211]
CellTagsIndexPosition[      5945,        208]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TemperedMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedMinor"], 
          "MeanMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanMinor"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TemperedMinor\"\>", 
       2->"\<\"MeanMinor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JustMinor", "ObjectName",
 CellID->10657],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["JustMinor"], "InlineFormula"],
     " \[LineSeparator]is an interval list for the minor version of the Just \
Major scale."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6708]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Intervals are measured in cents.", "Notes",
 CellID->23946],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"JustMinor", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to the Just Minor \
scale."
}], "Notes",
 CellID->29958],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JustMajor",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/JustMajor"]], "InlineFormula"],
 " gives the interval list of the Just Major scale."
}], "Notes",
 CellID->26632]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32679],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedMinor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanMinor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10637]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2263],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->1627]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JustMinor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 23.7169272}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "JustMinor is an interval list for the minor version of the Just Major \
scale.", "synonyms" -> {}, "title" -> "JustMinor", "type" -> "Symbol", "uri" -> 
    "Music/ref/JustMinor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1269, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1892, 60, 47, 1, 70, "ObjectName",
 CellID->10657],
Cell[1942, 63, 366, 11, 70, "Usage",
 CellID->6708]
}, Open  ]],
Cell[CellGroupData[{
Cell[2345, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2823, 96, 65, 1, 70, "Notes",
 CellID->23946],
Cell[2891, 99, 504, 17, 70, "Notes",
 CellID->29958],
Cell[3398, 118, 224, 7, 70, "Notes",
 CellID->26632]
}, Closed]],
Cell[CellGroupData[{
Cell[3659, 130, 311, 9, 70, "SeeAlsoSection",
 CellID->32679],
Cell[3973, 141, 475, 17, 70, "SeeAlso",
 CellID->10637]
}, Open  ]],
Cell[CellGroupData[{
Cell[4485, 163, 313, 9, 70, "TutorialsSection",
 CellID->2263],
Cell[4801, 174, 134, 3, 70, "Tutorials",
 CellID->1627]
}, Open  ]],
Cell[4950, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

