(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7519,        263]
NotebookOptionsPosition[      5764,        205]
NotebookOutlinePosition[      6770,        234]
CellTagsIndexPosition[      6727,        231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeanMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanMinor"], 
          "PythagoreanMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/PythagoreanMajor"], 
          "MeanMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanMajor"], 
          "TemperedMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedMajor"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MeanMinor\"\>", 
       2->"\<\"PythagoreanMajor\"\>", 3->"\<\"MeanMajor\"\>", 
       4->"\<\"TemperedMajor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeanMajor", "ObjectName",
 CellID->14855],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MeanMajor"], "InlineFormula"],
     " \[LineSeparator]is an interval list derived from the Mean Chromatic \
scale."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->305]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Intervals are measured in cents.", "Notes",
 CellID->9526],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"MeanMajor", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to the Mean Major \
scale."
}], "Notes",
 CellID->6287],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanChromatic",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/MeanChromatic"]], "InlineFormula"],
 " gives the interval list of the Mean Chromatic scale."
}], "Notes",
 CellID->31863]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24209],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanMinor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PythagoreanMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/PythagoreanMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedMajor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16979],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->22966]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanMajor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 30.4045984}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "MeanMajor is an interval list derived from the Mean Chromatic scale.", 
    "synonyms" -> {}, "title" -> "MeanMajor", "type" -> "Symbol", "uri" -> 
    "Music/ref/MeanMajor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1533, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2156, 65, 47, 1, 70, "ObjectName",
 CellID->14855],
Cell[2206, 68, 357, 11, 70, "Usage",
 CellID->305]
}, Open  ]],
Cell[CellGroupData[{
Cell[2600, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3078, 101, 64, 1, 70, "Notes",
 CellID->9526],
Cell[3145, 104, 503, 17, 70, "Notes",
 CellID->6287],
Cell[3651, 123, 236, 7, 70, "Notes",
 CellID->31863]
}, Closed]],
Cell[CellGroupData[{
Cell[3924, 135, 311, 9, 70, "SeeAlsoSection",
 CellID->24209],
Cell[4238, 146, 995, 35, 70, "SeeAlso",
 CellID->18886]
}, Open  ]],
Cell[CellGroupData[{
Cell[5270, 186, 314, 9, 70, "TutorialsSection",
 CellID->16979],
Cell[5587, 197, 135, 3, 70, "Tutorials",
 CellID->22966]
}, Open  ]],
Cell[5737, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

