(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7106,        251]
NotebookOptionsPosition[      5350,        193]
NotebookOutlinePosition[      6356,        222]
CellTagsIndexPosition[      6313,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeanMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanMajor"], "JustMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/JustMinor"], 
          "TemperedMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedMinor"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MeanMajor\"\>", 
       2->"\<\"JustMinor\"\>", 
       3->"\<\"TemperedMinor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeanMinor", "ObjectName",
 CellID->24263],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MeanMinor"], "InlineFormula"],
     " \[LineSeparator]is an interval list derived from the Mean Chromatic \
scale."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Intervals are measured in cents.", "Notes",
 CellID->9316],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"MeanMinor", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to the Mean Minor \
scale."
}], "Notes",
 CellID->32581],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanChromatic",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/MeanChromatic"]], "InlineFormula"],
 " gives the interval list of the Mean Chromatic scale."
}], "Notes",
 CellID->13777]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4444],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JustMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/JustMinor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedMinor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30476]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32533],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->21828]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanMinor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 30.6546048}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "MeanMinor is an interval list derived from the Mean Chromatic scale.", 
    "synonyms" -> {}, "title" -> "MeanMinor", "type" -> "Symbol", "uri" -> 
    "Music/ref/MeanMinor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1384, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2007, 62, 47, 1, 70, "ObjectName",
 CellID->24263],
Cell[2057, 65, 359, 11, 70, "Usage",
 CellID->22760]
}, Open  ]],
Cell[CellGroupData[{
Cell[2453, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2931, 98, 64, 1, 70, "Notes",
 CellID->9316],
Cell[2998, 101, 504, 17, 70, "Notes",
 CellID->32581],
Cell[3505, 120, 236, 7, 70, "Notes",
 CellID->13777]
}, Closed]],
Cell[CellGroupData[{
Cell[3778, 132, 310, 9, 70, "SeeAlsoSection",
 CellID->4444],
Cell[4091, 143, 728, 26, 70, "SeeAlso",
 CellID->30476]
}, Open  ]],
Cell[CellGroupData[{
Cell[4856, 174, 314, 9, 70, "TutorialsSection",
 CellID->32533],
Cell[5173, 185, 135, 3, 70, "Tutorials",
 CellID->21828]
}, Open  ]],
Cell[5323, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

