(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8512,        292]
NotebookOptionsPosition[      6509,        226]
NotebookOutlinePosition[      7548,        255]
CellTagsIndexPosition[      7505,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TemperedMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedMajor"], 
          "TemperedMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedMinor"], 
          "PythagoreanChromatic" :> 
          Documentation`HelpLookup["paclet:Music/ref/PythagoreanChromatic"], 
          "MeanChromatic" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanChromatic"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"TemperedMajor\"\>", 
       2->"\<\"TemperedMinor\"\>", 3->"\<\"PythagoreanChromatic\"\>", 
       4->"\<\"MeanChromatic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TemperedChromatic", "ObjectName",
 CellID->26102],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TemperedChromatic"], "InlineFormula"],
     " \[LineSeparator]is an interval list corresponding to an equal tempered \
scale. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5750]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Intervals are measured in cents.", "Notes",
 CellID->11788],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"TemperedChromatic", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to an equal-tempered \
scale."
}], "Notes",
 CellID->26747],

Cell[TextData[{
 Cell[BoxData["TemperedChromatic"], "InlineFormula"],
 " gives an intervals' list in which the octave is divided into 12 equal \
parts."
}], "Notes",
 CellID->72],

Cell["Each part is a tempered semitone (100 cents).", "Notes",
 CellID->17290],

Cell["\<\
This is equivalent to making 12 fifths equal to 7 octaves, so an \
equal\[Dash]tempered fifth is equal to 700 cents. (The Just Intonation and \
Pythagorean fifths are 702 cents, and the Mean Tone fifth is 696.6 cents.)\
\>", "Notes",
 CellID->31219],

Cell["\<\
This process guarantees equivalence between pitches, and allows intervals to \
be the same in all keys.\
\>", "Notes",
 CellID->13717],

Cell["\<\
However, except for the octave, none of the intervals is in tune with regard \
to mathematical ratios and the logic Pythagoras developed from proportional \
lengths of strings.\
\>", "Notes",
 CellID->1993]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31199],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedMinor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PythagoreanChromatic",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/PythagoreanChromatic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanChromatic",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanChromatic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23760],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->10756]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TemperedChromatic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 31.9515130}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "TemperedChromatic is an interval list corresponding to an equal tempered \
scale. ", "synonyms" -> {}, "title" -> "TemperedChromatic", "type" -> 
    "Symbol", "uri" -> "Music/ref/TemperedChromatic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1569, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2192, 65, 55, 1, 70, "ObjectName",
 CellID->26102],
Cell[2250, 68, 370, 11, 70, "Usage",
 CellID->5750]
}, Open  ]],
Cell[CellGroupData[{
Cell[2657, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3135, 101, 65, 1, 70, "Notes",
 CellID->11788],
Cell[3203, 104, 515, 17, 70, "Notes",
 CellID->26747],
Cell[3721, 123, 178, 5, 70, "Notes",
 CellID->72],
Cell[3902, 130, 78, 1, 70, "Notes",
 CellID->17290],
Cell[3983, 133, 259, 5, 70, "Notes",
 CellID->31219],
Cell[4245, 140, 144, 4, 70, "Notes",
 CellID->13717],
Cell[4392, 146, 216, 5, 70, "Notes",
 CellID->1993]
}, Closed]],
Cell[CellGroupData[{
Cell[4645, 156, 311, 9, 70, "SeeAlsoSection",
 CellID->31199],
Cell[4959, 167, 1019, 35, 70, "SeeAlso",
 CellID->17032]
}, Open  ]],
Cell[CellGroupData[{
Cell[6015, 207, 314, 9, 70, "TutorialsSection",
 CellID->23760],
Cell[6332, 218, 135, 3, 70, "Tutorials",
 CellID->10756]
}, Open  ]],
Cell[6482, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

