(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7150,        250]
NotebookOptionsPosition[      5375,        192]
NotebookOutlinePosition[      6398,        221]
CellTagsIndexPosition[      6355,        218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TemperedMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedMajor"], 
          "JustMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/JustMinor"], "MeanMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanMinor"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TemperedMajor\"\>", 
       2->"\<\"JustMinor\"\>", 3->"\<\"MeanMinor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TemperedMinor", "ObjectName",
 CellID->29116],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TemperedMinor"], "InlineFormula"],
     " \[LineSeparator]is an interval list derived from the Tempered \
Chromatic scale."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22978]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Intervals are measured in cents.", "Notes",
 CellID->12306],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"TemperedMinor", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to the Tempered Minor \
scale."
}], "Notes",
 CellID->32624],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TemperedChromatic",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/TemperedChromatic"]], "InlineFormula"],
 " gives the interval list of the Tempered Chromatic scale."
}], "Notes",
 CellID->25115]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24719],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JustMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/JustMinor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanMinor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24608]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12473],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->26160]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TemperedMinor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 38.4048032}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "TemperedMinor is an interval list derived from the Tempered Chromatic \
scale.", "synonyms" -> {}, "title" -> "TemperedMinor", "type" -> "Symbol", 
    "uri" -> "Music/ref/TemperedMinor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1375, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1998, 61, 51, 1, 70, "ObjectName",
 CellID->29116],
Cell[2052, 64, 367, 11, 70, "Usage",
 CellID->22978]
}, Open  ]],
Cell[CellGroupData[{
Cell[2456, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2934, 97, 65, 1, 70, "Notes",
 CellID->12306],
Cell[3002, 100, 512, 17, 70, "Notes",
 CellID->32624],
Cell[3517, 119, 248, 7, 70, "Notes",
 CellID->25115]
}, Closed]],
Cell[CellGroupData[{
Cell[3802, 131, 311, 9, 70, "SeeAlsoSection",
 CellID->24719],
Cell[4116, 142, 728, 26, 70, "SeeAlso",
 CellID->24608]
}, Open  ]],
Cell[CellGroupData[{
Cell[4881, 173, 314, 9, 70, "TutorialsSection",
 CellID->12473],
Cell[5198, 184, 135, 3, 70, "Tutorials",
 CellID->26160]
}, Open  ]],
Cell[5348, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

