(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6352,        222]
NotebookOptionsPosition[      3934,        150]
NotebookOutlinePosition[      5190,        183]
CellTagsIndexPosition[      5147,        180]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Nonlinear Regression Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["NonlinearRegress",
  BaseStyle->"Link",
  ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " perform a nonlinear regression"
}], "GuideText",
 CellID->110363851],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1410407681],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Report Values",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/guide/RegressionCommonPackage"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->557424193],

Cell[TextData[{
 Cell[TextData[ButtonBox["BestFit",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/BestFit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the fitted function"
}], "GuideText",
 CellID->1304743537],

Cell[TextData[{
 Cell[TextData[ButtonBox["PredictedResponse",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/PredictedResponse"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " fitted values"
}], "GuideText",
 CellID->869106842],

Cell[TextData[{
 Cell[TextData[ButtonBox["FitResiduals",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/FitResiduals"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParameterCITable",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/guide/RegressionCommonPackage"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->683134210]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Nonlinear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NonlinearRegression/tutorial/NonlinearRegression"]], "GuideTutorial",\

 CellID->50580473]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/guide/LinearRegressionPackage"]], "GuideMoreAbout",\

 CellID->1567025153],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/guide/HypothesisTestingPackage"]], \
"GuideMoreAbout",
 CellID->86224133],

Cell[TextData[ButtonBox["Curve Fitting and Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "GuideMoreAbout",
 CellID->1029892024],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "GuideMoreAbout",
 CellID->774336447],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "GuideMoreAbout",
 CellID->15039546]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nonlinear Regression Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 39.8423400}", "context" -> 
    "NonlinearRegression`", 
    "keywords" -> {
     "nonlinear fitting", "nonlinear least squares", "nonlinear regression"}, 
    "index" -> True, "label" -> "Nonlinear Regression Package Guide", 
    "language" -> "en", "paclet" -> "NonlinearRegression Package", "status" -> 
    "None", "summary" -> 
    "NonlinearRegress -- perform a nonlinear regression, BestFit -- the \
fitted function, PredictedResponse -- fitted values", "synonyms" -> {}, 
    "title" -> "Nonlinear Regression Package", "type" -> "Guide", "uri" -> 
    "NonlinearRegression/guide/NonlinearRegressionPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 70, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[692, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[751, 31, 293, 9, 70, "GuideText",
 CellID->110363851],
Cell[1047, 42, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->1410407681],
Cell[CellGroupData[{
Cell[1131, 47, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->557424193],
Cell[1357, 54, 259, 8, 70, "GuideText",
 CellID->1304743537],
Cell[1619, 64, 275, 9, 70, "GuideText",
 CellID->869106842],
Cell[1897, 75, 700, 20, 70, "InlineGuideFunctionListing",
 CellID->683134210]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2646, 101, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[2711, 104, 190, 5, 70, "GuideTutorial",
 CellID->50580473]
}, Open  ]],
Cell[CellGroupData[{
Cell[2938, 114, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3003, 117, 188, 5, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[3194, 124, 189, 5, 70, "GuideMoreAbout",
 CellID->86224133],
Cell[3386, 131, 195, 4, 70, "GuideMoreAbout",
 CellID->1029892024],
Cell[3584, 137, 165, 3, 70, "GuideMoreAbout",
 CellID->774336447],
Cell[3752, 142, 140, 3, 70, "GuideMoreAbout",
 CellID->15039546]
}, Open  ]],
Cell[3907, 148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

