(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56198,       1790]
NotebookOptionsPosition[     50524,       1599]
NotebookOutlinePosition[     52151,       1642]
CellTagsIndexPosition[     52065,       1637]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NONLINEAR REGRESSION PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Nonlinear Regression Package" :> 
          Documentation`HelpLookup[
           "paclet:NonlinearRegression/tutorial/NonlinearRegression"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Nonlinear Regression Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regress" :> 
          Documentation`HelpLookup["paclet:LinearRegression/ref/Regress"], 
          "FindFit" :> Documentation`HelpLookup["paclet:ref/FindFit"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Regress\"\>", 
       2->"\<\"FindFit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NonlinearRegress", "ObjectName",
 CellID->5987],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NonlinearRegress", "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["pars", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds numerical values of the parameters ",
     Cell[BoxData[
      StyleBox["pars", "TI"]], "InlineFormula"],
     " that make the model ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " give a best fit to ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     " and provides diagnostics for the fitting."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NonlinearRegress", "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["expr", "TI"], ",", 
          StyleBox["cons", "TI"]}], "}"}], ",", 
        StyleBox["pars", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a best fit and provides diagnostics subject to \
the constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28193]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The data can have the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", where the number of coordinates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " is equal to the number of variables in the list ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2421],

Cell[TextData[{
 "The data can also be of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", with a single coordinate assumed to take values ",
 Cell[BoxData[
  RowBox[{"1", ",", "2", ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6617],

Cell[TextData[{
 "The model ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " must yield a numerical value when ",
 Cell[BoxData[
  StyleBox["pars", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " are all numerical. "
}], "Notes",
 CellID->54840033],

Cell["\<\
The estimates of the model parameters give a least\[Hyphen]squares fit, \
minimizing the sum of squared residuals.\
\>", "Notes",
 CellID->2995],

Cell[TextData[{
 Cell[BoxData["NonlinearRegress"], "InlineFormula"],
 " returns a list of rules for results and diagnostics specified by the \
option ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->22704],

Cell[TextData[{
 "The model ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " must yield a numerical value when ",
 Cell[BoxData[
  StyleBox["pars", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " are all numerical."
}], "Notes",
 CellID->9514],

Cell[TextData[{
 "For constrained models, the constraints ",
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " can contain equations, inequalities, or logical combinations of equations \
and inequalities."
}], "Notes",
 CellID->14309],

Cell[TextData[{
 "Parameters are specified using the same syntax as in ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26500],

Cell[TextData[{
 "The results found by ",
 Cell[BoxData["NonlinearRegress"], "InlineFormula"],
 " may correspond only to a local optimum."
}], "Notes",
 CellID->491],

Cell["The following options can be given: ", "Notes",
 CellID->11942],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the accuracy sought", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Compiled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Compiled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to compile model", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["confidence level for confidence intervals", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Gradient", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "list of gradient functions", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], "100", Cell[
    "maximum number of iterations to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PrecisionGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrecisionGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the precision sought", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RegressionReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/RegressionReport"], 
    ButtonBox["SummaryReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/SummaryReport"], Cell[
    "fit diagnostics to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "numerical tolerance for matrix operations", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weights",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/Weights"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "list of weights for each point or pure function", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->17035],

Cell[TextData[{
 "The options ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Compiled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compiled"]], "InlineFormula"],
 ", ",
 Cell[BoxData["Gradient"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " are the same as for ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->77],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Weights",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Weights"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a list of numbers with the same length as ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ", or a pure function."
}], "Notes",
 CellID->5436],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weights",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Weights"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", each data point is given a weight of 1."
}], "Notes",
 CellID->292],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weights",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Weights"], "->", "g"}]], 
  "InlineFormula"],
 ", the weight associated with each point is ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]], ",", "\[Ellipsis]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12382],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RegressionReport",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/RegressionReport"], "->", 
   ButtonBox["SummaryReport",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/SummaryReport"]}]], 
  "InlineFormula"],
 " includes the elements ",
 Cell[BoxData[
  ButtonBox["BestFitParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/BestFitParameters"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ParameterCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EstimatedVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ANOVATable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AsymptoticCorrelationMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FitCurvatureTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/FitCurvatureTable"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->22190],

Cell[TextData[{
 "For constrained models, ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " values based on approximate normality assumptions may not be valid. When \
such values are included, the values will be generated along with a warning \
message."
}], "Notes",
 CellID->9741]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->592494912],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->312217945],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NonlinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->77853905],

Cell["Nonlinear regression with parameters a and b:", "ExampleText",
 CellID->585196825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "0.99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       RowBox[{"-", "0.7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0.58"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "0.41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", 
       RowBox[{"-", "0.66"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222455915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFitParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "0.7769440182335982`"}], ",", 
      RowBox[{"b", "\[Rule]", "1.0037506742613276`"}]}], "}"}]}], ",", 
   RowBox[{"ParameterCITable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"Asymptotic SE\"\>",
          HoldForm], 
         TagBox["\<\"CI\"\>",
          HoldForm]},
        {
         TagBox["a",
          HoldForm], "0.7769440182335982`", "0.013586926363713015`", 
         RowBox[{"{", 
          RowBox[{"0.7337043546272378`", ",", "0.8201836818399585`"}], 
          "}"}]},
        {
         TagBox["b",
          HoldForm], "1.0037506742613276`", "0.00006960557817434184`", 
         RowBox[{"{", 
          RowBox[{"1.0035291582462396`", ",", "1.0039721902764156`"}], "}"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{$CellContext`a, $CellContext`b}, {
         "Estimate", "Asymptotic SE", "CI"}}]]]}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.00012595804921310285`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>"},
       {"\<\"Model\"\>", "2", "2.40982212585236`", "1.20491106292618`"},
       {"\<\"Error\"\>", "3", "0.0003778741476393086`", 
        "0.00012595804921310285`"},
       {"\<\"Uncorrected Total\"\>", "5", "2.4101999999999997`", "\<\"\"\>"},
       {"\<\"Corrected Total\"\>", "4", "2.0402799999999996`", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{2, 2.40982212585236, 1.20491106292618}, {
       3, 0.000377874147639309, 0.000125958049213103}, {5, 2.4102}, {
       4, 2.04028}}, 
      TableHeadings -> {{
        "Model", "Error", "Uncorrected Total", "Corrected Total"}, {
        "DF", "SumOfSq", "MeanSq"}}]]}], ",", 
   RowBox[{"AsymptoticCorrelationMatrix", "\[Rule]", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1.0000000000000002`", 
         RowBox[{"-", "0.8564411093697882`"}]},
        {
         RowBox[{"-", "0.8564411093697882`"}], "0.9999999999999999`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"FitCurvatureTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Curvature\"\>",
          HoldForm]},
        {
         TagBox["\<\"Max Intrinsic\"\>",
          HoldForm], "0.02465927352107711`"},
        {
         TagBox["\<\"Max Parameter-Effects\"\>",
          HoldForm], "0.012663909541556207`"},
        {
         TagBox["\<\"95. % Confidence Region\"\>",
          HoldForm], "0.32355692170919437`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{
         "Max Intrinsic", "Max Parameter-Effects", 
          "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}]], "Output",\

 ImageSize->{469, 248},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76258809]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20934],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->502684921],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NonlinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->38452346],

Cell["Nonlinear regression with 99% confidence intervals:", "ExampleText",
 CellID->755057619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "0.99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       RowBox[{"-", "0.7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0.58"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "0.41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", 
       RowBox[{"-", "0.66"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "x", ",", 
   RowBox[{"ConfidenceLevel", " ", "\[Rule]", ".99"}], ",", " ", 
   RowBox[{"RegressionReport", "\[Rule]", "ParameterCITable"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41451835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ParameterCITable", "\[Rule]", 
   TagBox[
    TagBox[GridBox[{
       {
        StyleBox["\[Null]",
         ShowStringCharacters->False], 
        TagBox["\<\"Estimate\"\>",
         HoldForm], 
        TagBox["\<\"Asymptotic SE\"\>",
         HoldForm], 
        TagBox["\<\"CI\"\>",
         HoldForm]},
       {
        TagBox["a",
         HoldForm], "0.7769440182335982`", "0.013586926363713015`", 
        RowBox[{"{", 
         RowBox[{"0.6975840135451252`", ",", "0.8563040229220711`"}], "}"}]},
       {
        TagBox["b",
         HoldForm], "1.0037506742613276`", "0.00006960557817434184`", 
        RowBox[{"{", 
         RowBox[{"1.0033441143917596`", ",", "1.0041572341308955`"}], "}"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxDividers->{
       "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
        "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
    Function[BoxForm`e$, 
     MatrixForm[
     BoxForm`e$, TableDepth -> 2, 
      TableHeadings -> {{$CellContext`a, $CellContext`b}, {
        "Estimate", "Asymptotic SE", "CI"}}]]]}], "}"}]], "Output",
 ImageSize->{466, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->547965173]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RegressionReport",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->113227472],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NonlinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->408620888],

Cell["Nonlinear regression with a specific list of report values:", \
"ExampleText",
 CellID->92321839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "0.99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       RowBox[{"-", "0.7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0.58"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "0.41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", 
       RowBox[{"-", "0.66"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "x", ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"BestFit", ",", "PredictedResponse"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->602819206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFit", "\[Rule]", 
    RowBox[{"Sin", "[", 
     RowBox[{"0.7769440182335982`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.0037506742613276`", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}]}], ",", 
   RowBox[{"PredictedResponse", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.9968369522956293`"}], ",", 
      RowBox[{"-", "0.7083398792203757`"}], ",", "0.5818865900086265`", ",", 
      "0.39701385543712636`", ",", 
      RowBox[{"-", "0.6694539659967467`"}]}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{508, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->252214735]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Weights",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->84386033],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NonlinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->420520689],

Cell["\<\
Weighted regression with specific weights given for each data element:\
\>", "ExampleText",
 CellID->333288755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "0.99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       RowBox[{"-", "0.7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0.58"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "0.41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", 
       RowBox[{"-", "0.66"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "x", ",", 
   RowBox[{"Weights", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "4", ",", "2", ",", "3"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->627417423],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFitParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "0.7705991597766564`"}], ",", 
      RowBox[{"b", "\[Rule]", "1.0037847801110213`"}]}], "}"}]}], ",", 
   RowBox[{"ParameterCITable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"Asymptotic SE\"\>",
          HoldForm], 
         TagBox["\<\"CI\"\>",
          HoldForm]},
        {
         TagBox["a",
          HoldForm], "0.7705991597766564`", "0.012459762668300067`", 
         RowBox[{"{", 
          RowBox[{"0.7309466341082129`", ",", "0.8102516854450998`"}], 
          "}"}]},
        {
         TagBox["b",
          HoldForm], "1.0037847801110213`", "0.00006152555930167446`", 
         RowBox[{"{", 
          RowBox[{"1.0035889783221412`", ",", "1.0039805818999015`"}], "}"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{$CellContext`a, $CellContext`b}, {
         "Estimate", "Asymptotic SE", "CI"}}]]]}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.00023682239190217746`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>"},
       {"\<\"Model\"\>", "2", "5.438089532824294`", "2.719044766412147`"},
       {"\<\"Error\"\>", "3", "0.0007104671757065324`", 
        "0.00023682239190217746`"},
       {"\<\"Uncorrected Total\"\>", "5", "5.4388000000000005`", "\<\"\"\>"},
       {"\<\"Corrected Total\"\>", "4", "5.246266666666666`", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{2, 5.43808953282429, 2.71904476641215}, {
       3, 0.000710467175706532, 0.000236822391902177}, {5, 5.4388}, {
       4, 5.24626666666667}}, 
      TableHeadings -> {{
        "Model", "Error", "Uncorrected Total", "Corrected Total"}, {
        "DF", "SumOfSq", "MeanSq"}}]]}], ",", 
   RowBox[{"AsymptoticCorrelationMatrix", "\[Rule]", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0.9999999999999998`", 
         RowBox[{"-", "0.8751382372628582`"}]},
        {
         RowBox[{"-", "0.8751382372628582`"}], "1.`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"FitCurvatureTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Curvature\"\>",
          HoldForm]},
        {
         TagBox["\<\"Max Intrinsic\"\>",
          HoldForm], "0.03405862708706755`"},
        {
         TagBox["\<\"Max Parameter-Effects\"\>",
          HoldForm], "0.017205286946463876`"},
        {
         TagBox["\<\"95. % Confidence Region\"\>",
          HoldForm], "0.32355692170919437`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{
         "Max Intrinsic", "Max Parameter-Effects", 
          "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}]], "Output",\

 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{469, 248},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4089248]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->571455108],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NonlinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->553561731],

Cell["\<\
Weighted regression with weights equal to the squares of the measured \
responses:\
\>", "ExampleText",
 CellID->143211852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "0.99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       RowBox[{"-", "0.7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0.58"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "0.41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", 
       RowBox[{"-", "0.66"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "x", ",", 
   RowBox[{"Weights", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#", "^", "2"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302908791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFitParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "0.781401082309727`"}], ",", 
      RowBox[{"b", "\[Rule]", "1.003752034513484`"}]}], "}"}]}], ",", 
   RowBox[{"ParameterCITable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"Asymptotic SE\"\>",
          HoldForm], 
         TagBox["\<\"CI\"\>",
          HoldForm]},
        {
         TagBox["a",
          HoldForm], "0.781401082309727`", "0.012127310365874023`", 
         RowBox[{"{", 
          RowBox[{"0.7428065682428224`", ",", "0.8199955963766317`"}], 
          "}"}]},
        {
         TagBox["b",
          HoldForm], "1.003752034513484`", "0.00006145625905472072`", 
         RowBox[{"{", 
          RowBox[{"1.0035564532689187`", ",", "1.0039476157580494`"}], "}"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{$CellContext`a, $CellContext`b}, {
         "Estimate", "Asymptotic SE", "CI"}}]]]}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.000043275885061646376`"}], ",", 
   
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>"},
       {"\<\"Model\"\>", "2", "1.531736112344815`", "0.7658680561724075`"},
       {"\<\"Error\"\>", "3", "0.00012982765518493913`", 
        "0.000043275885061646376`"},
       {"\<\"Uncorrected Total\"\>", "5", "1.5318659399999999`", "\<\"\"\>"},
       {"\<\"Corrected Total\"\>", "4", "0.7904616396747157`", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{2, 1.53173611234482, 0.765868056172408}, {
       3, 0.000129827655184939, 0.0000432758850616464}, {5, 1.53186594}, {
       4, 0.790461639674716}}, 
      TableHeadings -> {{
        "Model", "Error", "Uncorrected Total", "Corrected Total"}, {
        "DF", "SumOfSq", "MeanSq"}}]]}], ",", 
   RowBox[{"AsymptoticCorrelationMatrix", "\[Rule]", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1.0000000000000002`", 
         RowBox[{"-", "0.8108249041205661`"}]},
        {
         RowBox[{"-", "0.8108249041205661`"}], "1.0000000000000002`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"FitCurvatureTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Curvature\"\>",
          HoldForm]},
        {
         TagBox["\<\"Max Intrinsic\"\>",
          HoldForm], "0.014349254625727404`"},
        {
         TagBox["\<\"Max Parameter-Effects\"\>",
          HoldForm], "0.007322984328303916`"},
        {
         TagBox["\<\"95. % Confidence Region\"\>",
          HoldForm], "0.32355692170919437`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{
         "Max Intrinsic", "Max Parameter-Effects", 
          "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}]], "Output",\

 ImageSize->{476, 248},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272649599]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->341192618],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NonlinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->37778317],

Cell[TextData[{
 "Nonlinear regression using precision ",
 Cell[BoxData["20"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31662345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{
        RowBox[{"-", "99"}], "/", "100"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       RowBox[{
        RowBox[{"-", "7"}], "/", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", 
       RowBox[{"58", "/", "100"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", 
       RowBox[{"41", "/", "100"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", 
       RowBox[{
        RowBox[{"-", "66"}], "/", "100"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "2"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "x", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->483955089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFitParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
      "a", "\[Rule]", "0.77694401823734464739388939074660857517`20."}], ",", 
      RowBox[{
      "b", "\[Rule]", "1.00375067426130910519056313449141436196`20."}]}], 
     "}"}]}], ",", 
   RowBox[{"ParameterCITable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"Asymptotic SE\"\>",
          HoldForm], 
         TagBox["\<\"CI\"\>",
          HoldForm]},
        {
         TagBox["a",
          HoldForm], "0.77694401823734464739388939074660857517`20.", 
         "0.01358692636370317135758140082`15.381984342605433", 
         RowBox[{"{", 
          RowBox[{"0.7337043546310157`", ",", "0.8201836818436735`"}], 
          "}"}]},
        {
         TagBox["b",
          HoldForm], "1.00375067426130910519056313449141436196`20.", 
         "0.00006960557817437341132731068441238297`15.381984342605431", 
         RowBox[{"{", 
          RowBox[{"1.003529158246221`", ",", "1.0039721902763974`"}], "}"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{$CellContext`a, $CellContext`b}, {
         "Estimate", "Asymptotic SE", "CI"}}]]]}], ",", 
   RowBox[{
   "EstimatedVariance", "\[Rule]", 
    "0.00012595804921324217072151316`15.099818526228367"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>"},
       {"\<\"Model\"\>", "2", 
        "2.40982212585236027348783546053`18.839800208183657", 
        "1.20491106292618013674391773026`18.839800208183657"},
       {"\<\"Error\"\>", "3", 
        "0.00037787414763972651216453946`15.099818526228367", 
        "0.00012595804921324217072151316`15.099818526228367"},
       {"\<\"Uncorrected Total\"\>", "5", 
        "2.41019999999999999999999999999999999999`19.69897000433602", "\<\"\"\
\>"},
       {"\<\"Corrected Total\"\>", "4", 
        "2.04028000000000000000000000001`19.55005576621546", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       2, 2.4098221258523602735`18.839800208183657, 
        1.2049110629261801367`18.839800208183657}, {
       3, 0.0003778741476397265`15.099818526228367, 
        0.0001259580492132422`15.099818526228367}, {
       5, 2.4102`19.69897000433602}, {4, 2.04028`19.55005576621546}}, 
      TableHeadings -> {{
        "Model", "Error", "Uncorrected Total", "Corrected Total"}, {
        "DF", "SumOfSq", "MeanSq"}}]]}], ",", 
   RowBox[{"AsymptoticCorrelationMatrix", "\[Rule]", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1.00000000000000000000000000093`14.77992435127747", 
         RowBox[{
         "-", "0.85644110936936225508074749265`14.779924222160558"}]},
        {
         RowBox[{"-", "0.85644110936936225508074749648`14.779924222160558"}], 
         "1.00000000000000000000000008511`14.779924351277469"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"FitCurvatureTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Curvature\"\>",
          HoldForm]},
        {
         TagBox["\<\"Max Intrinsic\"\>",
          HoldForm], "0.02465927352098118498354639966`12.496838137359447"},
        {
         TagBox["\<\"Max Parameter-Effects\"\>",
          HoldForm], "0.0126639095416162499801208695`12.496838137359447"},
        {
         TagBox["\<\"95. % Confidence Region\"\>",
          HoldForm], "0.32355692170919437`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{
         "Max Intrinsic", "Max Parameter-Effects", 
          "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}]], "Output",\

 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{526, 265},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->364853675]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1006],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Regress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/Regress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindFit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindFit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5568]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17181],

Cell[TextData[ButtonBox["Nonlinear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NonlinearRegression/tutorial/NonlinearRegression"]], "Tutorials",
 CellID->501]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NonlinearRegress - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 40.1079718}", "context" -> 
    "NonlinearRegression`", 
    "keywords" -> {
     "nonlinear fitting", "nonlinear least squares", "nonlinear regression"}, 
    "index" -> True, "label" -> "Nonlinear Regression Package Symbol", 
    "language" -> "en", "paclet" -> "NonlinearRegression Package", "status" -> 
    "None", "summary" -> 
    "NonlinearRegress[data, expr, pars, vars] finds numerical values of the \
parameters pars that make the model expr give a best fit to data as a \
function of vars and provides diagnostics for the fitting. \
NonlinearRegress[data, {expr, cons}, pars, vars] finds a best fit and \
provides diagnostics subject to the constraints cons.", "synonyms" -> {}, 
    "title" -> "NonlinearRegress", "type" -> "Symbol", "uri" -> 
    "NonlinearRegression/ref/NonlinearRegress"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15270, 529, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->592494912]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51921, 1630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1331, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1954, 61, 53, 1, 70, "ObjectName",
 CellID->5987],
Cell[2010, 64, 1501, 45, 70, "Usage",
 CellID->28193]
}, Open  ]],
Cell[CellGroupData[{
Cell[3548, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4026, 131, 1152, 41, 70, "Notes",
 CellID->2421],
Cell[5181, 174, 504, 18, 70, "Notes",
 CellID->6617],
Cell[5688, 194, 316, 12, 70, "Notes",
 CellID->54840033],
Cell[6007, 208, 154, 4, 70, "Notes",
 CellID->2995],
Cell[6164, 214, 341, 11, 70, "Notes",
 CellID->22704],
Cell[6508, 227, 311, 12, 70, "Notes",
 CellID->9514],
Cell[6822, 241, 247, 7, 70, "Notes",
 CellID->14309],
Cell[7072, 250, 225, 8, 70, "Notes",
 CellID->26500],
Cell[7300, 260, 165, 5, 70, "Notes",
 CellID->491],
Cell[7468, 267, 69, 1, 70, "Notes",
 CellID->11942],
Cell[7540, 270, 3395, 91, 70, "3ColumnTableMod",
 CellID->17035],
Cell[10938, 363, 1051, 40, 70, "Notes",
 CellID->77],
Cell[11992, 405, 469, 16, 70, "Notes",
 CellID->5436],
Cell[12464, 423, 364, 12, 70, "Notes",
 CellID->292],
Cell[12831, 437, 627, 24, 70, "Notes",
 CellID->12382],
Cell[13461, 463, 1376, 48, 70, "Notes",
 CellID->22190],
Cell[14840, 513, 393, 11, 70, "Notes",
 CellID->9741]
}, Closed]],
Cell[CellGroupData[{
Cell[15270, 529, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->592494912],
Cell[CellGroupData[{
Cell[15655, 543, 148, 5, 70, "ExampleSection",
 CellID->312217945],
Cell[15806, 550, 143, 4, 70, "Input",
 CellID->77853905],
Cell[15952, 556, 88, 1, 70, "ExampleText",
 CellID->585196825],
Cell[CellGroupData[{
Cell[16065, 561, 743, 25, 47, "Input",
 CellID->222455915],
Cell[16811, 588, 5376, 140, 269, "Output",
 CellID->76258809]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22236, 734, 218, 7, 70, "ExampleSection",
 CellID->20934],
Cell[CellGroupData[{
Cell[22479, 745, 236, 7, 70, "ExampleSubsection",
 CellID->502684921],
Cell[22718, 754, 143, 4, 70, "Input",
 CellID->38452346],
Cell[22864, 760, 94, 1, 70, "ExampleText",
 CellID->755057619],
Cell[CellGroupData[{
Cell[22983, 765, 881, 28, 70, "Input",
 CellID->41451835],
Cell[23867, 795, 1713, 48, 64, "Output",
 CellID->547965173]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25629, 849, 237, 7, 70, "ExampleSubsection",
 CellID->113227472],
Cell[25869, 858, 144, 4, 70, "Input",
 CellID->408620888],
Cell[26016, 864, 103, 2, 70, "ExampleText",
 CellID->92321839],
Cell[CellGroupData[{
Cell[26144, 870, 873, 29, 70, "Input",
 CellID->602819206],
Cell[27020, 901, 702, 19, 58, "Output",
 CellID->252214735]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27771, 926, 227, 7, 70, "ExampleSubsection",
 CellID->84386033],
Cell[28001, 935, 144, 4, 70, "Input",
 CellID->420520689],
Cell[28148, 941, 121, 3, 70, "ExampleText",
 CellID->333288755],
Cell[CellGroupData[{
Cell[28294, 948, 873, 29, 70, "Input",
 CellID->627417423],
Cell[29170, 979, 5419, 142, 269, "Output",
 CellID->4089248]
}, Open  ]],
Cell[34604, 1124, 125, 3, 70, "ExampleDelimiter",
 CellID->571455108],
Cell[34732, 1129, 144, 4, 70, "Input",
 CellID->553561731],
Cell[34879, 1135, 133, 4, 70, "ExampleText",
 CellID->143211852],
Cell[CellGroupData[{
Cell[35037, 1143, 862, 29, 70, "Input",
 CellID->302908791],
Cell[35902, 1174, 5400, 141, 269, "Output",
 CellID->272649599]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41351, 1321, 237, 7, 70, "ExampleSubsection",
 CellID->341192618],
Cell[41591, 1330, 143, 4, 70, "Input",
 CellID->37778317],
Cell[41737, 1336, 139, 5, 70, "ExampleText",
 CellID->31662345],
Cell[CellGroupData[{
Cell[41901, 1345, 941, 31, 70, "Input",
 CellID->483955089],
Cell[42845, 1378, 6255, 160, 286, "Output",
 CellID->364853675]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49173, 1546, 310, 9, 70, "SeeAlsoSection",
 CellID->1006],
Cell[49486, 1557, 463, 17, 70, "SeeAlso",
 CellID->5568]
}, Open  ]],
Cell[CellGroupData[{
Cell[49986, 1579, 314, 9, 70, "TutorialsSection",
 CellID->17181],
Cell[50303, 1590, 179, 4, 70, "Tutorials",
 CellID->501]
}, Open  ]],
Cell[50497, 1597, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

