(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     69518,       2284]
NotebookOptionsPosition[     64274,       2127]
NotebookOutlinePosition[     66517,       2178]
CellTagsIndexPosition[     66474,       2175]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NONLINEAR REGRESSION PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ANOVATable" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/ANOVATable"], 
         "AsymptoticCorrelationMatrix" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"], 
         "AsymptoticCovarianceMatrix" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/AsymptoticCovarianceMatrix"], 
         "BestFit" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/BestFit"], 
         "BestFitParameters" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/BestFitParameters"], "ConfidenceLevel" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/ConfidenceLevel"], 
         "EstimatedVariance" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/EstimatedVariance"], 
         "FitCurvatureTable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/FitCurvatureTable"], "FitResiduals" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/FitResiduals"],
          "HatDiagonal" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/HatDiagonal"], 
         "MeanPredictionCITable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/MeanPredictionCITable"], 
         "NonlinearRegress" :> 
         Documentation`HelpLookup[
          "paclet:NonlinearRegression/ref/NonlinearRegress"], "ParameterBias" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/ParameterBias"], "ParameterCITable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/ParameterCITable"], 
         "ParameterConfidenceRegion" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/ParameterConfidenceRegion"], 
         "ParameterTable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/ParameterTable"], "PredictedResponse" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/PredictedResponse"], 
         "SinglePredictionCITable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/SinglePredictionCITable"], 
         "StandardizedResiduals" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/StandardizedResiduals"], 
         "StartingParameters" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/StartingParameters"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"ANOVATable\"\>", 
      2->"\<\"AsymptoticCorrelationMatrix\"\>", 
      3->"\<\"AsymptoticCovarianceMatrix\"\>", 4->"\<\"BestFit\"\>", 
      5->"\<\"BestFitParameters\"\>", 6->"\<\"ConfidenceLevel\"\>", 
      7->"\<\"EstimatedVariance\"\>", 8->"\<\"FitCurvatureTable\"\>", 
      9->"\<\"FitResiduals\"\>", 10->"\<\"HatDiagonal\"\>", 
      11->"\<\"MeanPredictionCITable\"\>", 12->"\<\"NonlinearRegress\"\>", 
      13->"\<\"ParameterBias\"\>", 14->"\<\"ParameterCITable\"\>", 
      15->"\<\"ParameterConfidenceRegion\"\>", 16->"\<\"ParameterTable\"\>", 
      17->"\<\"PredictedResponse\"\>", 18->"\<\"SinglePredictionCITable\"\>", 
      19->"\<\"StandardizedResiduals\"\>", 
      20->"\<\"StartingParameters\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Nonlinear Regression Package", "Title",
 CellID->21922],

Cell[TextData[{
 "The built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " allows you to perform nonlinear least squares fitting. The function ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " gives a number of regression diagnostics and allows you to specify exactly \
what will be included in the output.",
 " ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " is similar to the ",
 ButtonBox["Linear Regression Package",
  BaseStyle->"Link",
  ButtonData->"paclet:LinearRegression/guide/LinearRegressionPackage"],
 " function ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 ", which gives diagnostics for linear least squares fitting. "
}], "Text",
 CellID->15857],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NonlinearRegress",
      BaseStyle->"Link",
      ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"], "[", 
     StyleBox["data", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["pars", "TI"], ",", 
     StyleBox["vars", "TI"], "]"}], Cell[TextData[{
     "finds",
     " ",
     "numerical",
     " ",
     "values",
     " ",
     "of",
     " ",
     "the",
     " ",
     "parameters",
     " ",
     Cell[BoxData[
      StyleBox["pars", "TI"]], "InlineFormula"],
     " ",
     "that",
     " ",
     "make",
     " ",
     "the",
     " ",
     "model",
     " ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " ",
     "give",
     " ",
     "a",
     " ",
     "best",
     " ",
     "fit",
     " ",
     "to",
     " ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " ",
     "as",
     " ",
     "a",
     " ",
     "function",
     " ",
     "of",
     " ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     " ",
     "and",
     " ",
     "provides",
     " ",
     "diagnostics",
     " ",
     "for",
     " ",
     "the",
     " ",
     "fitting",
     "."
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["NonlinearRegress",
       BaseStyle->"Link",
       ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"], "[", 
      RowBox[{
       RowBox[{
        StyleBox["data", "TI"], 
        RowBox[{",", "{"}], 
        StyleBox["expr", "TI"]}], ",", 
       RowBox[{
        StyleBox["cons", "TI"], 
        RowBox[{"}", ","}], 
        StyleBox["pars", "TI"]}], ",", 
       StyleBox["vars", "TI"]}], "]"}], " "}], Cell[TextData[{
     "fit",
     " ",
     "the",
     " ",
     "data",
     " ",
     "to",
     " ",
     "the",
     " ",
     "model",
     " ",
     "subject",
     " ",
     "to",
     " ",
     "the",
     " ",
     "given",
     " ",
     "constraints",
     ",",
     " ",
     "finds",
     " ",
     "a",
     " ",
     "best",
     " ",
     "fit",
     " ",
     "and",
     " ",
     "provides",
     " ",
     "diagnostics",
     " ",
     "subject",
     " ",
     "to",
     " ",
     "the",
     " ",
     "constraints",
     " ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->755],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " function. "
}], "Caption",
 CellID->15184],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " argument to ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " must be completely specified by the symbols in the ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " argument and the symbols in the ",
 Cell[BoxData[
  StyleBox["pars", "TI"]], "InlineFormula"],
 " argument. The ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " argument specifies the independent variables represented in ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  StyleBox["pars", "TI"]], "InlineFormula"],
 " argument specifies the parameters to be fitted. For constrained models, \
the ",
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " argument can contain equations, inequalities, or logical combinations of \
equations and inequalities."
}], "Text",
 CellID->14460],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " argument can be a list of vectors, each vector consisting of the values of \
the independent variables ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x", "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x", "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", \[Ellipsis] , followed by the observed value of the associated response \
",
 Cell[BoxData[
  FormBox[
   StyleBox["y", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". The data argument can also be a vector, in which case it is assumed that \
the vector represents the observed values of the response variable, with the \
independent variable(s) for the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["i", "TI"], "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " response equal to ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". "
}], "Text",
 CellID->22751],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["y", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], "2"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "data",
     " ",
     "points",
     " ",
     "specified",
     " ",
     "by",
     " ",
     "a",
     " ",
     "list",
     " ",
     "of",
     " ",
     "response",
     " ",
     "values",
     ",",
     " ",
     "where",
     " ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " ",
     "is",
     " ",
     "the",
     " ",
     "value",
     " ",
     "of",
     " ",
     "the",
     " ",
     "independent",
     " ",
     "variable",
     " ",
     "associated",
     " ",
     "with",
     " ",
     "the",
     " ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " ",
     "response",
     ",",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox[
      RowBox[{"{", "{"}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "11"]], "InlineFormula"], 
     StyleBox[
      RowBox[{",", " "}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "12"]], "InlineFormula"], 
     StyleBox[
      RowBox[{",", " ", "\[Ellipsis]", " ", ",", " "}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "1"]], "InlineFormula"], 
     StyleBox[
      RowBox[{"}", ",", "{"}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "21"]], "InlineFormula"], 
     StyleBox[
      RowBox[{",", " "}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "22"]], "InlineFormula"], 
     StyleBox[
      RowBox[{",", " ", "\[Ellipsis]", " ", ",", " "}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "2"]], "InlineFormula"], 
     StyleBox[
      RowBox[{
       RowBox[{"}", ",", " ", "\[Ellipsis]"}], " ", "}"}], "MR"], " "}], Cell[
    TextData[{
     "data",
     " ",
     "points",
     " ",
     "specified",
     " ",
     "by",
     " ",
     "a",
     " ",
     "matrix",
     ",",
     " ",
     "where",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox[
        RowBox[{"i", "k"}], "TI"]]], "InlineFormula"],
     " ",
     "is",
     " ",
     "the",
     " ",
     "value",
     " ",
     "of",
     " ",
     "the",
     " ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " ",
     "case",
     " ",
     "of",
     " ",
     "the",
     " ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " ",
     "independent",
     " ",
     "variable",
     ",",
     " ",
     "and",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " ",
     "is",
     " ",
     "the",
     " ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " ",
     "response",
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->20464],

Cell[TextData[{
 "Data specifications for ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->16960],

Cell[TextData[{
 "The estimates of the model parameters are chosen to minimize the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " merit function given by the sum of squared residuals ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", 
     StyleBox["i", "TI"],
     LimitsPositioning->True], 
    SubsuperscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["i", "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". The optimization methods used by ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " are iterative so starting values are required for the parameter estimate \
search. Careful choice of starting values may be necessary, as the parameter \
estimates found by",
 " ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " may represent a local minimum in the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " merit function. "
}], "Text",
 CellID->1084],

Cell[TextData[{
 "Parameters are specified using the same syntax as in ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 ". Parameters can be specified as ",
 Cell[BoxData[
  StyleBox["symbol", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["symbol", "TI"], ",", " ", 
    StyleBox["start", "TI"]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["symbol", "TI"], ",", " ", 
    SubscriptBox[
     StyleBox["start", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["start", "TI"], 
     StyleBox["1", "TR"]]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["symbol", "TI"], ",", " ", 
    StyleBox["start", "TI"], ",", " ", 
    StyleBox["min", "TI"], ",", " ", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula",
  ShowStringCharacters->False],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["symbol", "TI"], ",", " ", 
    SubscriptBox[
     StyleBox["start", "TI"], 
     StyleBox["0", "TR"]], ",", " ", 
    SubscriptBox[
     StyleBox["start", "TI"], 
     StyleBox["1", "TR"]], ",", " ", 
    StyleBox["min", "TI"], ",", " ", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["start", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["start", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["start", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " are real numbers specifying starting values and minimum and maximum values \
for symbol. If the method is ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " automatically finds a feasible starting point. If parameters are specified \
as symbol and the method is not ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ", the starting values for all parameters are taken to be 1."
}], "Text",
 CellID->21809],

Cell[TextData[{
 "If a parameter is specified as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["symbol", "TI"], ",", 
    SubscriptBox[
     StyleBox["start", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["start", "TI"], 
     StyleBox["1", "TR"]]}], "}"}]], "InlineFormula"],
 ", then the search for parameter estimates uses ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["start", "TI"], "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["start", "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " as the first two values of ",
 StyleBox["symbol", "TI"],
 ". This form must be used if symbolic derivatives of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " with respect to the parameters cannot be found. "
}], "Text",
 CellID->14468],

Cell["This loads the package. ", "MathCaption",
 CellID->31524],

Cell[BoxData[
 RowBox[{"<<", "NonlinearRegression`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24551],

Cell["\<\
This data set due to Roth and Meyer describes a chemical reaction. \
\>", "MathCaption",
 CellID->5225],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.0", ",", "1.0", ",", ".126"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.0", ",", "1.0", ",", ".219"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.0", ",", "2.0", ",", ".076"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.0", ",", "2.0", ",", ".126"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".1", ",", ".0", ",", ".186"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21625],

Cell[TextData[{
 "This fits the model ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Theta]", "1"], 
   SubscriptBox["\[Theta]", "3"], 
   RowBox[{"x1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SubscriptBox["\[Theta]", "1"], "x1"}], "+", 
      RowBox[{
       SubscriptBox["\[Theta]", "2"], "x2"}]}], ")"}]}]}]], "InlineFormula"],
 " and gives diagnostics for the fit. "
}], "MathCaption",
 CellID->10679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{"data", ",", 
   FractionBox[
    RowBox[{"theta1", " ", "theta3", " ", "x1"}], 
    RowBox[{"1", "+", 
     RowBox[{"theta1", " ", "x1"}], "+", 
     RowBox[{"theta2", " ", "x2"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"theta1", ",", "theta2", ",", "theta3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7967],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFitParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"theta1", "\[Rule]", "3.1315052420200065`"}], ",", 
      RowBox[{"theta2", "\[Rule]", "15.159362112360794`"}], ",", 
      RowBox[{"theta3", "\[Rule]", "0.7800626110719642`"}]}], "}"}]}], ",", 
   RowBox[{"ParameterCITable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"Asymptotic SE\"\>",
          HoldForm], 
         TagBox["\<\"CI\"\>",
          HoldForm]},
        {
         TagBox["theta1",
          HoldForm], "3.1315052420200065`", "0.8084169992079717`", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.34683236639804305`"}], ",", "6.609842850438056`"}],
           "}"}]},
        {
         TagBox["theta2",
          HoldForm], "15.159362112360794`", "0.631224069511218`", 
         RowBox[{"{", 
          RowBox[{"12.443424146594786`", ",", "17.875300078126802`"}], 
          "}"}]},
        {
         TagBox["theta3",
          HoldForm], "0.7800626110719642`", "0.151797140495166`", 
         RowBox[{"{", 
          RowBox[{"0.1269322301522754`", ",", "1.4331929919916528`"}], "}"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{$CellContext`theta1, $CellContext`theta2, \
$CellContext`theta3}, {"Estimate", "Asymptotic SE", "CI"}}]]]}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "0.000021776330970950895`"}], ",", 
   
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>"},
       {"\<\"Model\"\>", "3", "0.1200414473380581`", "0.0400138157793527`"},
       {"\<\"Error\"\>", "2", "0.00004355266194190179`", 
        "0.000021776330970950895`"},
       {"\<\"Uncorrected Total\"\>", "5", 
        "0.12008500000000001`", "\<\"\"\>"},
       {"\<\"Corrected Total\"\>", "4", "0.0126272`", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{3, 0.120041447338058, 0.0400138157793527}, {
       2, 0.0000435526619419018, 0.0000217763309709509}, {5, 0.120085}, {
       4, 0.0126272}}, 
      TableHeadings -> {{
        "Model", "Error", "Uncorrected Total", "Corrected Total"}, {
        "DF", "SumOfSq", "MeanSq"}}]]}], ",", 
   RowBox[{"AsymptoticCorrelationMatrix", "\[Rule]", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0.9999999999999998`", "0.2870146697682928`", 
         RowBox[{"-", "0.9918299927428288`"}]},
        {"0.2870146697682929`", "1.`", 
         RowBox[{"-", "0.18202083913186395`"}]},
        {
         RowBox[{"-", "0.9918299927428288`"}], 
         RowBox[{"-", "0.18202083913186393`"}], "1.`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"FitCurvatureTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Curvature\"\>",
          HoldForm]},
        {
         TagBox["\<\"Max Intrinsic\"\>",
          HoldForm], "0.03746695034874514`"},
        {
         TagBox["\<\"Max Parameter-Effects\"\>",
          HoldForm], "12.816088531939542`"},
        {
         TagBox["\<\"95. % Confidence Region\"\>",
          HoldForm], "0.22843024672369971`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{
         "Max Intrinsic", "Max Parameter-Effects", 
          "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}]], "Output",\

 ImageSize->{518, 279},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->259880884]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[BoxData[
     RowBox[{
      StyleBox["option", "TI"], " ", 
      StyleBox["name", "TI"], " "}]], "InlineFormula"], Cell[BoxData[
     RowBox[{
      StyleBox["default", "TI"], " ", 
      StyleBox["value", "TI"], " "}]], "InlineFormula"], " "},
   {
    RowBox[{
     ButtonBox["AccuracyGoal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AccuracyGoal"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "the accuracy sought", "TableText"]},
   {
    ButtonBox["Compiled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Compiled"], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "whether to compile model", "TableText"]},
   {
    RowBox[{"Gradient", " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "list of gradient functions", "TableText"]},
   {
    RowBox[{
     ButtonBox["MaxIterations",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MaxIterations"], " "}], "100", Cell[
    "maximum number of iterations to use", "TableText"]},
   {
    RowBox[{
     ButtonBox["Method",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Method"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[BoxData[
    Cell["method to use", "TableText"]]]},
   {
    RowBox[{
     ButtonBox["PrecisionGoal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrecisionGoal"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "the precision sought", "TableText"]},
   {
    ButtonBox["RegressionReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/RegressionReport"], 
    ButtonBox["SummaryReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/SummaryReport"], Cell[
    "fit diagnostics to include", "TableText"]},
   {
    RowBox[{
     ButtonBox["Tolerance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tolerance"], " "}], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "numerical tolerance for matrix operations", "TableText"]},
   {
    ButtonBox["Weights",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/Weights"], 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "list of weights for each point or pure function", "TableText"]},
   {
    RowBox[{
     ButtonBox["WorkingPrecision",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WorkingPrecision"], " "}], 
    RowBox[{
     ButtonBox["MachinePrecision",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MachinePrecision"], " "}], Cell[
    "the precision used in internal computations", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->13300],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->7040],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " to find parameter estimates, thus it accepts the ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " options ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Compiled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compiled"]], "InlineFormula"],
 ", ",
 Cell[BoxData["Gradient"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option allows you to choose between algorithms for performing the \
minimization of the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " merit function. Possible settings for ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " are ",
 Cell[BoxData["\"\<LevenbergMarquardt\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Gradient\>\""], "InlineFormula"],
 " (steepest descent), ",
 Cell[BoxData["\"\<Newton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<QuasiNewton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". Method options can be passed to methods by specifying ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["method", "TI"], ",", " ", 
     StyleBox["options", "TI"]}], "}"}]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->3623],

Cell[TextData[{
 "The default ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " setting ",
 Cell[BoxData[
  ButtonBox["SummaryReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/SummaryReport"]], 
  "InlineFormula"],
 " gives a list including values for ",
 Cell[BoxData[
  ButtonBox["BestFitParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/BestFitParameters"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ParameterCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EstimatedVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ANOVATable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AsymptoticCorrelationMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FitCurvatureTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/FitCurvatureTable"]], 
  "InlineFormula"],
 ". The option ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " can be used to specify a single object or a list of objects so that more \
(or less) than the default set of results is included in the output. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RegressionReportValues",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/RegressionReportValues"], "[", 
   ButtonBox["NonlinearRegress",
    BaseStyle->"Link",
    ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"], "]"}]], 
  "InlineFormula"],
 " gives the objects that may be included in the ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " list for the ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " function. "
}], "Text",
 CellID->15786],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Weights",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Weights"]], "InlineFormula"],
 " option allows you to implement weighted least squares by specifying a list \
of weights, one for each data point. The default ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weights",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Weights"], " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " implies a weight of unity for each data point. When ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weights",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Weights"], " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["w", "TI"], 
      StyleBox["1", "TR"]], ",", " ", "\[Ellipsis]", " ", ",", " ", 
     SubscriptBox[
      StyleBox["w", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 ", the parameter estimates are chosen to minimize the weighted sum of \
squared residuals ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["i", "TI"], "=", "1"}], 
     StyleBox["n", "TI"],
     LimitsPositioning->True], 
    RowBox[{
     SubscriptBox[
      StyleBox["w", "TI"], 
      StyleBox["i", "TI"]], " ", 
     SubsuperscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["i", "TI"], "2"]}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". "
}], "Text",
 CellID->17853],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Weights",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Weights"]], "InlineFormula"],
 " can also specify a pure function of the response. For example, to choose \
parameter estimates to minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["i", "TI"], "=", "1"}], 
     StyleBox["n", "TI"],
     LimitsPositioning->True], 
    RowBox[{
     SqrtBox[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], " ", 
     SubsuperscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["i", "TI"], "2"]}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weights",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Weights"], " ", "->", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["Sqrt",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sqrt"], "[", "#", "]"}], " ", "&"}], ")"}]}]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->3592],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 " will also accept any option that can be specified for ",
 Cell[BoxData[
  ButtonBox["StudentTCI",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"]], "InlineFormula"],
 ". In particular, ",
 Cell[BoxData[
  ButtonBox["ConfidenceLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"]], 
  "InlineFormula"],
 " specifies the confidence level for the reference parameter confidence \
region (the relative curvature of which is given in ",
 Cell[BoxData[
  ButtonBox["FitCurvatureTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/FitCurvatureTable"]], 
  "InlineFormula"],
 ") and the individual parameter confidence intervals given in ",
 Cell[BoxData[
  ButtonBox["ParameterCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->6316],

Cell["Here just the parameter estimates are returned. ", "MathCaption",
 CellID->30723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{"data", ",", 
   FractionBox[
    RowBox[{"theta1", " ", "theta3", " ", "x1"}], 
    RowBox[{"1", "+", 
     RowBox[{"theta1", " ", "x1"}], "+", 
     RowBox[{"theta2", " ", "x2"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"theta1", ",", "theta2", ",", "theta3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", 
   RowBox[{"RegressionReport", "->", "BestFitParameters"}]}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->4888],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"BestFitParameters", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"theta1", "\[Rule]", "3.1315052420200065`"}], ",", 
     RowBox[{"theta2", "\[Rule]", "15.159362112360794`"}], ",", 
     RowBox[{"theta3", "\[Rule]", "0.7800626110719642`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{518, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->51468808]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["BestFit",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/BestFit"], Cell[
    "best fit function ", "TableText"]},
   {
    ButtonBox["BestFitParameters",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/BestFitParameters"], Cell[
    "best fit parameter estimates", "TableText"]},
   {
    ButtonBox["ANOVATable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/ANOVATable"], Cell[
    "analysis of variance table", "TableText"]},
   {
    ButtonBox["EstimatedVariance",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"], Cell[
    "estimated error variance ", "TableText"]},
   {
    ButtonBox["ParameterTable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/ParameterTable"], Cell["\<\
table of parameter information including asymptotic standard errors and test \
statistics \
\>", "TableText"]},
   {
    ButtonBox["ParameterCITable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"], Cell[
    "table of asymptotic confidence intervals for the parameters", 
     "TableText"]},
   {
    ButtonBox["ParameterConfidenceRegion",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"], 
    Cell["\<\
asymptotic ellipsoidal joint confidence region for the parameters\
\>", "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["ParameterConfidenceRegion",
       BaseStyle->"Link",
       ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"], 
      "[", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["par", "TI"], 
         StyleBox["i1", "TI"]], ",", 
        SubscriptBox[
         StyleBox["par", "TI"], 
         StyleBox["i2", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], " "}], Cell[TextData[{
     "asymptotic ellipsoidal conditional joint confidence region for the \
parameters ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["par", "TI"], 
         StyleBox["i1", "TI"]], ",", 
        SubscriptBox[
         StyleBox["par", "TI"], 
         StyleBox["i2", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["FitResiduals",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/FitResiduals"], Cell["\<\
differences between the observed responses and the predicted responses \
\>", "TableText"]},
   {
    ButtonBox["PredictedResponse",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/PredictedResponse"], Cell["\<\
fitted values obtained by evaluating the best fit function at the observed \
values of the independent variables\
\>", "TableText"]},
   {
    ButtonBox["SinglePredictionCITable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/SinglePredictionCITable"], 
    Cell["\<\
table of asymptotic confidence intervals for predicting a single observation \
of the response variable \
\>", "TableText"]},
   {
    ButtonBox["MeanPredictionCITable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/MeanPredictionCITable"], 
    Cell["\<\
table of asymptotic confidence intervals for predicting the expected value of \
the response variable\
\>", "TableText"]},
   {
    ButtonBox["AsymptoticCovarianceMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/AsymptoticCovarianceMatrix"], 
    Cell["asymptotic covariance matrix of the parameters ", "TableText"]},
   {
    ButtonBox["AsymptoticCorrelationMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/AsymptoticCorrelationMatrix"], 
    Cell["asymptotic correlation matrix of the parameters ", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->17046],

Cell[TextData[{
 "Basic ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " values for ",
 Cell[BoxData[
  ButtonBox["NonlinearRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:NonlinearRegression/ref/NonlinearRegress"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->25574],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ANOVATable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], "InlineFormula"],
 " provides a partitioning of the sum of squares. Both the uncorrected total \
sum of squares (without intercept term) and the corrected total sum of \
squares (with intercept term) are included. The corrected total sum of \
squares is useful for calculating a value for ",
 Cell[BoxData[
  SuperscriptBox["R", "2"]], "InlineFormula"],
 " comparable to that produced by ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 ", so that the fit of a nonlinear model can be compared to the fit of a \
linear model. For example, one possible definition of ",
 Cell[BoxData[
  SuperscriptBox["R", "2"]], "InlineFormula"],
 " for a nonlinear regression is the ratio of the difference between the \
corrected total sum of squares and the residual sum of squares to the \
corrected total sum of squares. The other objects in this table have meanings \
similar to those of analogous ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " values for the linear regression function ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30161],

Cell[BoxData[GridBox[{
   {
    ButtonBox["StartingParameters",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/StartingParameters"], Cell[
    "starting values for the parameters", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->29423],

Cell["\<\
Value describing the search for the least\[Hyphen]squares fit.\
\>", "Caption",
 CellID->26018],

Cell[TextData[{
 "Including ",
 Cell[BoxData[
  ButtonBox["StartingParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/StartingParameters"]], 
  "InlineFormula"],
 " in the list of objects requested by ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " is helpful if the search for a least\[Hyphen]squares fit is unsuccessful \
and it is necessary to restart the search at a new point. "
}], "Text",
 CellID->1875],

Cell[BoxData[GridBox[{
   {
    ButtonBox["HatDiagonal",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"], Cell[TextData[{
     "diagonal of the hat matrix ",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox[
        RowBox[{"X", "(", 
         RowBox[{
          SuperscriptBox["X", "\[Transpose]"], "X"}], ")"}], 
        RowBox[{"-", "1"}]], 
       SuperscriptBox["X", "\[Transpose]"]}]], "InlineFormula"],
     ", where ",
     Cell[BoxData["X"], "InlineFormula"],
     " is the design matrix for the approximate linear model at the least\
\[Hyphen]squares parameter estimates "
    }], "TableText"]},
   {
    ButtonBox["StandardizedResiduals",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/StandardizedResiduals"], 
    Cell["\<\
fit residuals scaled by their asymptotic standard errors, computed using the \
estimated error variance\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->19734],

Cell["Diagnostics for detecting outliers.", "Caption",
 CellID->29367],

Cell[TextData[{
 "If the nonlinear model is approximately linear at the least\[Hyphen]squares \
fit, ",
 Cell[BoxData[
  ButtonBox["HatDiagonal",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StandardizedResiduals",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/StandardizedResiduals"]], 
  "InlineFormula"],
 " are useful for detecting outliers in the data. ",
 Cell[BoxData[
  ButtonBox["HatDiagonal",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"]], "InlineFormula"],
 " gives the leverage of each point, measuring whether each observation of \
the predictor variables is unusual. A leverage of zero indicates no \
influence, while a leverage of one indicates that a degree of freedom has \
been lost to fitting that point. "
}], "Text",
 CellID->30406],

Cell[BoxData[GridBox[{
   {
    ButtonBox["FitCurvatureTable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/FitCurvatureTable"], Cell[
    TextData[{
     "maximum relative intrinsic curvature, maximum relative parameter\
\[Hyphen]effects curvature, and relative curvature of the \
least\[Hyphen]squares solution confidence region (where confidence level is \
given by ",
     ButtonBox["ConfidenceLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["ParameterBias",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/ParameterBias"], Cell["\<\
bias in the least\[Hyphen]squares estimates of the parameters in a nonlinear \
model\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->16055],

Cell["\<\
Diagnostics for evaluating the validity of a linear model approximation to \
the nonlinear model.\
\>", "Caption",
 CellID->4531],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FitCurvatureTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/FitCurvatureTable"]], 
  "InlineFormula"],
 " expresses the relative curvature of the solution locus at the least\
\[Hyphen]squares estimate in terms of two components, intrinsic and parameter\
\[Hyphen]effects. For the combination of data and model given above, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], "=", "3"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "=", "5"}]], "InlineFormula"],
 ". The solution locus is a three\[Hyphen]dimensional subspace of ",
 Cell[BoxData[
  SuperscriptBox["R", "5"]], "InlineFormula"],
 " given by {",
 Cell[BoxData[
  RowBox[{"1.0", 
   SubscriptBox[
    StyleBox["\[Theta]", "TR"], 
    StyleBox["1", "TR"]], " ", 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Theta]", "TR"], 
     StyleBox["3", "TR"]], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"1.0", 
       SubscriptBox[
        StyleBox["\[Theta]", "TR"], 
        StyleBox["1", "TR"]]}], "+", 
      RowBox[{"1.0", 
       SubscriptBox[
        StyleBox["\[Theta]", "TR"], 
        StyleBox["2", "TR"]]}]}], ")"}]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"2.0", 
   SubscriptBox[
    StyleBox["\[Theta]", "TR"], 
    StyleBox["1", "TR"]], " ", 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Theta]", "TR"], 
     StyleBox["3", "TR"]], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2.0", 
       SubscriptBox[
        StyleBox["\[Theta]", "TR"], 
        StyleBox["1", "TR"]]}], "+", 
      RowBox[{"1.0", 
       SubscriptBox[
        StyleBox["\[Theta]", "TR"], 
        StyleBox["2", "TR"]]}]}], ")"}]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"1.0", 
   SubscriptBox[
    StyleBox["\[Theta]", "TR"], 
    StyleBox["1", "TR"]], " ", 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Theta]", "TR"], 
     StyleBox["3", "TR"]], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"1.0", 
       SubscriptBox[
        StyleBox["\[Theta]", "TR"], 
        StyleBox["1", "TR"]]}], "+", 
      RowBox[{"2.0", 
       SubscriptBox[
        StyleBox["\[Theta]", "TR"], 
        StyleBox["2", "TR"]]}]}], ")"}]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"2.0", 
   SubscriptBox[
    StyleBox["\[Theta]", "TR"], 
    StyleBox["1", "TR"]], " ", 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Theta]", "TR"], 
     StyleBox["3", "TR"]], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2.0", 
       SubscriptBox[
        StyleBox["\[Theta]", "TR"], 
        StyleBox["1", "TR"]]}], "+", 
      RowBox[{"2.0", 
       SubscriptBox[
        StyleBox["\[Theta]", "TR"], 
        StyleBox["2", "TR"]]}]}], ")"}]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"0.1", 
   SubscriptBox[
    StyleBox["\[Theta]", "TR"], 
    StyleBox["1", "TR"]], " ", 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Theta]", "TR"], 
     StyleBox["3", "TR"]], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0.1", 
       SubscriptBox[
        StyleBox["\[Theta]", "TR"], 
        StyleBox["1", "TR"]]}]}], ")"}]}]}]]],
 "}, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["\[Theta]", "TR"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["\[Theta]", "TR"], 
      StyleBox["2", "TR"]], ",", 
     SubscriptBox[
      StyleBox["\[Theta]", "TR"], 
      StyleBox["3", "TR"]]}], "}"}], "\[Element]", 
   SuperscriptBox[
    StyleBox["R", "TI"], "3"]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->25280],

Cell[TextData[{
 "Intrinsic curvature describes the normal component of the solution locus \
curvature at the least\[Hyphen]squares estimate. Parameter\[Hyphen]effects \
curvature describes the tangential component of the solution locus curvature \
at the least\[Hyphen]squares estimate. Standardizing curvature to be response\
\[Hyphen]invariant gives relative curvature. Maximizing the relative \
intrinsic curvature over the",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["n", "TI"], "-", 
     StyleBox["p", "TI"]}], ")"}]}]], "InlineFormula"],
 "\[Hyphen]dimensional subspace normal to the locus gives the maximum \
relative intrinsic curvature. Similarly, maximizing the relative parameter\
\[Hyphen]effects curvature over the ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]dimensional subspace tangential to the locus gives the maximum \
relative parameter\[Hyphen]effects curvature. "
}], "Text",
 CellID->29256],

Cell["\<\
Both of these quantities can be compared to the relative curvature of the \
confidence region centered on the least\[Hyphen]squares parameter estimates. \
If the maximum relative intrinsic curvature is small compared to the \
confidence region relative curvature, the solution locus is approximately \
planar over the confidence region. If the maximum relative \
parameter\[Hyphen]effects curvature is small compared to the confidence \
region relative curvature, the parameter coordinates projected onto the \
tangential plane are approximately parallel and uniformly spaced over the \
confidence region. \
\>", "Text",
 CellID->22933],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParameterBias",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterBias"]], 
  "InlineFormula"],
 " is based on the average curvature of the solution locus tangential to the \
least\[Hyphen]squares estimate. "
}], "Text",
 CellID->18483],

Cell[TextData[{
 "Here the same data is fit to a reparametrized model, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "=", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], "/", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["0", "TR"]], "+", 
      RowBox[{
       SubscriptBox[
        StyleBox["\[Phi]", "TR"], 
        StyleBox["1", "TR"]], " ", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]]}], " ", "+", 
      RowBox[{
       SubscriptBox[
        StyleBox["\[Phi]", "TR"], 
        StyleBox["2", "TR"]], " ", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]]}]}], ")"}]}]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->7226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonlinearRegress", "[", 
  RowBox[{"data", ",", 
   FractionBox["x1", 
    RowBox[{"phi0", "+", 
     RowBox[{"phi1", " ", "x1"}], "+", 
     RowBox[{"phi2", " ", "x2"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"phi0", ",", "phi1", ",", "phi2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}], ",", 
   RowBox[{"RegressionReport", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "BestFit", ",", "AsymptoticCorrelationMatrix", ",", 
      "FitCurvatureTable"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->22574],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BestFit", "\[Rule]", 
    FractionBox["x1", 
     RowBox[{"0.40937130197641386`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.2819483831322196`", " ", "x1"}], "+", 
      RowBox[{"6.205807805558492`", " ", "x2"}]}]]}], ",", 
   RowBox[{"AsymptoticCorrelationMatrix", "\[Rule]", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1.0000000000000002`", 
         RowBox[{"-", "0.8814080653822168`"}], "0.8026386256252573`"},
        {
         RowBox[{"-", "0.8814080653822169`"}], "0.9999999999999998`", 
         RowBox[{"-", "0.9274654903508783`"}]},
        {"0.8026386256252573`", 
         RowBox[{"-", "0.9274654903508781`"}], "1.`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"FitCurvatureTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Curvature\"\>",
          HoldForm]},
        {
         TagBox["\<\"Max Intrinsic\"\>",
          HoldForm], "0.03746690754452385`"},
        {
         TagBox["\<\"Max Parameter-Effects\"\>",
          HoldForm], "0.08932052625109074`"},
        {
         TagBox["\<\"95. % Confidence Region\"\>",
          HoldForm], "0.22843024672369971`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {{
         "Max Intrinsic", "Max Parameter-Effects", 
          "95. % Confidence Region"}, {"Curvature"}}]]]}]}], "}"}]], "Output",\

 ImageSize->{451, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->53323868]
}, Open  ]],

Cell[TextData[{
 "Note that reparametrizing the model does not affect the intrinsic \
curvature. However, here reparametrization has reduced the \
parameter\[Hyphen]effects curvature below the critical value of ",
 Cell[BoxData["0.22843"], "InlineFormula"],
 ". This indicates that the least\[Hyphen]squares estimates of the parameters \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Phi]", "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Phi]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Phi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " have nearly linear behavior. However, now the asymptotic correlation \
between parameters is high for all pairs, indicating that a model with fewer \
parameters should be considered. "
}], "Text",
 CellID->246],

Cell[TextData[{
 "The maximum relative curvature diagnostics are useful if you wish to make \
inferences based on the linear approximation to the nonlinear model. For \
example, diagnostics based on the asymptotic standard errors of the \
parameters, such as ",
 Cell[BoxData[
  ButtonBox["ParameterCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ParameterConfidenceRegion",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"]], 
  "InlineFormula"],
 ", are of questionable validity when the linear approximation to the model \
is poor at the least\[Hyphen]squares parameter estimates. The linear \
approximation is based on the planar assumption, tested by maximum relative \
intrinsic curvature, and the uniform coordinate assumption, tested by maximum \
relative parameter\[Hyphen]effects curvature. "
}], "Text",
 CellID->30165],

Cell[TextData[{
 "For constrained models, ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " values based on approximate normality assumptions may not be valid. If \
such values are listed in the ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " option, the values will be generated along with a warning message."
}], "Text",
 CellID->19703]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nonlinear Regression Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 40.5611084}", "context" -> 
    "NonlinearRegression`", 
    "keywords" -> {
     "nonlinear fitting", "nonlinear least squares", "nonlinear regression"}, 
    "index" -> True, "label" -> "Nonlinear Regression Package Tutorial", 
    "language" -> "en", "paclet" -> "NonlinearRegression Package", "status" -> 
    "None", "summary" -> 
    "The built-in function FindFit allows you to perform nonlinear least \
squares fitting. The function NonlinearRegress gives a number of regression \
diagnostics and allows you to specify exactly what will be included in the \
output. NonlinearRegress is similar to the Linear Regression Package function \
Regress, which gives diagnostics for linear least squares fitting. The \
NonlinearRegress function. The expr argument to NonlinearRegress must be \
completely specified by the symbols in the vars argument and the symbols in \
the pars argument. The vars argument specifies the independent variables \
represented in data. The pars argument specifies the parameters to be fitted. \
For constrained models, the cons argument can contain equations, \
inequalities, or logical combinations of equations and inequalities.", 
    "synonyms" -> {}, "title" -> "Nonlinear Regression Package", "type" -> 
    "Tutorial", "uri" -> 
    "NonlinearRegression/tutorial/NonlinearRegression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3691, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4316, 101, 61, 1, 70, "Title",
 CellID->21922],
Cell[4380, 104, 1080, 31, 70, "Text",
 CellID->15857],
Cell[5463, 137, 2411, 139, 70, "DefinitionBox",
 CellID->755],
Cell[7877, 278, 228, 9, 70, "Caption",
 CellID->15184],
Cell[8108, 289, 1031, 32, 70, "Text",
 CellID->14460],
Cell[9142, 323, 1752, 53, 70, "Text",
 CellID->22751],
Cell[10897, 378, 3472, 169, 70, "DefinitionBox",
 CellID->20464],
Cell[14372, 549, 238, 9, 70, "Caption",
 CellID->16960],
Cell[14613, 560, 1642, 48, 70, "Text",
 CellID->1084],
Cell[16258, 610, 2448, 86, 70, "Text",
 CellID->21809],
Cell[18709, 698, 1329, 42, 70, "Text",
 CellID->14468],
Cell[20041, 742, 63, 1, 70, "MathCaption",
 CellID->31524],
Cell[20107, 745, 103, 3, 70, "Input",
 CellID->24551],
Cell[20213, 750, 113, 3, 70, "MathCaption",
 CellID->5225],
Cell[20329, 755, 539, 17, 70, "Input",
 CellID->21625],
Cell[20871, 774, 436, 15, 70, "MathCaption",
 CellID->10679],
Cell[CellGroupData[{
Cell[21332, 793, 445, 13, 70, "Input",
 CellID->7967],
Cell[21780, 808, 5886, 153, 300, "Output",
 CellID->259880884]
}, Open  ]],
Cell[27681, 964, 3281, 102, 70, "DefinitionBox3Col",
 CellID->13300],
Cell[30965, 1068, 225, 9, 70, "Caption",
 CellID->7040],
Cell[31193, 1079, 2827, 97, 70, "Text",
 CellID->3623],
Cell[34023, 1178, 2440, 79, 70, "Text",
 CellID->15786],
Cell[36466, 1259, 1676, 53, 70, "Text",
 CellID->17853],
Cell[38145, 1314, 1209, 42, 70, "Text",
 CellID->3592],
Cell[39357, 1358, 1091, 32, 70, "Text",
 CellID->6316],
Cell[40451, 1392, 87, 1, 70, "MathCaption",
 CellID->30723],
Cell[CellGroupData[{
Cell[40563, 1397, 513, 15, 70, "Input",
 CellID->4888],
Cell[41079, 1414, 452, 13, 36, "Output",
 CellID->51468808]
}, Open  ]],
Cell[41546, 1430, 4045, 114, 70, "DefinitionBox",
 CellID->17046],
Cell[45594, 1546, 392, 15, 70, "Caption",
 CellID->25574],
Cell[45989, 1563, 1487, 36, 70, "Text",
 CellID->30161],
Cell[47479, 1601, 394, 11, 70, "DefinitionBox",
 CellID->29423],
Cell[47876, 1614, 105, 3, 70, "Caption",
 CellID->26018],
Cell[47984, 1619, 551, 16, 70, "Text",
 CellID->1875],
Cell[48538, 1637, 1103, 32, 70, "DefinitionBox",
 CellID->19734],
Cell[49644, 1671, 70, 1, 70, "Caption",
 CellID->29367],
Cell[49717, 1674, 901, 23, 70, "Text",
 CellID->30406],
Cell[50621, 1699, 969, 27, 70, "DefinitionBox",
 CellID->16055],
Cell[51593, 1728, 139, 4, 70, "Caption",
 CellID->4531],
Cell[51735, 1734, 3569, 133, 70, "Text",
 CellID->25280],
Cell[55307, 1869, 974, 21, 70, "Text",
 CellID->29256],
Cell[56284, 1892, 646, 11, 70, "Text",
 CellID->22933],
Cell[56933, 1905, 305, 9, 70, "Text",
 CellID->18483],
Cell[57241, 1916, 802, 30, 70, "MathCaption",
 CellID->7226],
Cell[CellGroupData[{
Cell[58068, 1950, 571, 17, 70, "Input",
 CellID->22574],
Cell[58642, 1969, 2742, 74, 155, "Output",
 CellID->53323868]
}, Open  ]],
Cell[61399, 2046, 1283, 34, 70, "Text",
 CellID->246],
Cell[62685, 2082, 982, 22, 70, "Text",
 CellID->30165],
Cell[63670, 2106, 562, 16, 70, "Text",
 CellID->19703]
}, Open  ]],
Cell[64247, 2125, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

