(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9892,        341]
NotebookOptionsPosition[      6431,        235]
NotebookOutlinePosition[      7910,        275]
CellTagsIndexPosition[      7827,        270]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Notation Package", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The Notation Package allows you to extend ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " so it understands and functions correctly with new typeset notations. \
Typically, new notations are defined by constructing explicit ",
 Cell[TextData[ButtonBox["MakeExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MakeExpression"]], "InlineFunctionSans"],
 " and ",
 Cell[TextData[ButtonBox["MakeBoxes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MakeBoxes"]], "InlineFunctionSans"],
 " rules. The Notation Package provides functionality for introducing new \
notations easily, intuitively, and graphically."
}], "GuideAbstract",
 CellTags->"NotationDocumentation",
 CellID->577004837],

Cell[CellGroupData[{

Cell["Defining Notations", "GuideFunctionsSubsection",
 CellID->250902537],

Cell[TextData[{
 Cell[TextData[ButtonBox["Notation",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/Notation"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create a custom notation for input and output"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Symbolize",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " force a box structure to be treated as a single symbol"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["InfixNotation",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " force a box structure to be treated as an infix operator"
}], "GuideText",
 CellID->356770658],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["Removing Defined Notations", "GuideFunctionsSubsection",
 CellID->334912194],

Cell[TextData[{
 Cell[TextData[ButtonBox["RemoveNotation",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/RemoveNotation"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " remove a custom notation"
}], "GuideText",
 CellID->55967367],

Cell[TextData[{
 Cell[TextData[ButtonBox["RemoveSymbolize",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/RemoveSymbolize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " remove the symbolization of a box structure"
}], "GuideText",
 CellID->404120845],

Cell[TextData[{
 Cell[TextData[ButtonBox["RemoveInfixNotation",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/RemoveInfixNotation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " remove the definition of a custom infix operator"
}], "GuideText",
 CellID->751711270],

Cell[TextData[{
 Cell[TextData[ButtonBox["ClearNotations",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/ClearNotations"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " clear all custom notations, symbolizations, and infix operators"
}], "GuideText",
 CellID->464889062],

Cell["\t", "GuideDelimiterSubsection",
 CellID->95393790]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input Aliases", "GuideFunctionsSubsection",
 CellID->237775194],

Cell[TextData[{
 Cell[TextData[ButtonBox["AddInputAlias",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/AddInputAlias"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " add an alias in the current notebook"
}], "GuideText",
 CellID->794799439],

Cell[TextData[{
 Cell[TextData[ButtonBox["ActiveInputAliases",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/ActiveInputAliases"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of active aliases in a notebook"
}], "GuideText",
 CellID->831122055],

Cell["\t", "GuideDelimiter",
 CellID->216769450],

Cell[TextData[{
 Cell[TextData[ButtonBox["UpdateNotebookStyles",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/ref/UpdateNotebookStyles"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " add the custom style and input alias notations to a notebook"
}], "GuideText",
 CellID->725103029]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Notation, Symbolize and InfixNotation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Notation/tutorial/NotationSymbolizeAndInfixNotation"]], \
"GuideTutorial",
 CellID->515121746],

Cell[TextData[ButtonBox["Precedence of Operators in Notations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Notation/tutorial/PrecedenceOfOperatorsInNotations"]], \
"GuideTutorial",
 CellID->267734956],

Cell[TextData[ButtonBox["Options and Auxiliary Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Notation/tutorial/OptionsAndAuxiliaryFunctions"]], "GuideTutorial",
 CellID->13421368],

Cell[TextData[ButtonBox["Complex Patterns and Advanced Features",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Notation/tutorial/ComplexPatternsAndAdvancedFeatures"]], \
"GuideTutorial",
 CellID->346711804],

Cell[TextData[ButtonBox["Advice and Suggested Guidelines",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Notation/tutorial/AdviceAndSuggestedGuidelines"]], "GuideTutorial",
 CellID->508481900]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialCharacters"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Notation Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 40.9204926}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Notation Package Guide", 
    "language" -> "en", "paclet" -> "Notation Package", "status" -> "None", 
    "summary" -> 
    "The Notation Package allows you to extend Mathematica so it understands \
and functions correctly with new typeset notations. Typically, new notations \
are defined by constructing explicit MakeExpression and MakeBoxes rules. The \
Notation Package provides functionality for introducing new notations easily, \
intuitively, and graphically.", "synonyms" -> {}, "title" -> 
    "Notation Package", "type" -> "Guide", "uri" -> 
    "Notation/guide/NotationPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "NotationDocumentation"->{
  Cell[680, 28, 717, 17, 70, "GuideAbstract",
   CellTags->"NotationDocumentation",
   CellID->577004837]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"NotationDocumentation", 7696, 263}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[680, 28, 717, 17, 70, "GuideAbstract",
 CellTags->"NotationDocumentation",
 CellID->577004837],
Cell[CellGroupData[{
Cell[1422, 49, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->250902537],
Cell[1499, 52, 278, 8, 70, "GuideText",
 CellID->203374175],
Cell[1780, 62, 290, 8, 70, "GuideText",
 CellID->1463276848],
Cell[2073, 72, 299, 8, 70, "GuideText",
 CellID->356770658],
Cell[2375, 82, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[2470, 88, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->334912194],
Cell[2555, 91, 268, 8, 70, "GuideText",
 CellID->55967367],
Cell[2826, 101, 290, 8, 70, "GuideText",
 CellID->404120845],
Cell[3119, 111, 306, 9, 70, "GuideText",
 CellID->751711270],
Cell[3428, 122, 308, 8, 70, "GuideText",
 CellID->464889062],
Cell[3739, 132, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->95393790]
}, Open  ]],
Cell[CellGroupData[{
Cell[3833, 138, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->237775194],
Cell[3905, 141, 279, 8, 70, "GuideText",
 CellID->794799439],
Cell[4187, 151, 292, 9, 70, "GuideText",
 CellID->831122055],
Cell[4482, 162, 48, 1, 70, "GuideDelimiter",
 CellID->216769450],
Cell[4533, 165, 320, 9, 70, "GuideText",
 CellID->725103029]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4902, 180, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4967, 183, 203, 5, 70, "GuideTutorial",
 CellID->515121746],
Cell[5173, 190, 201, 5, 70, "GuideTutorial",
 CellID->267734956],
Cell[5377, 197, 189, 4, 70, "GuideTutorial",
 CellID->13421368],
Cell[5569, 203, 205, 5, 70, "GuideTutorial",
 CellID->346711804],
Cell[5777, 210, 190, 4, 70, "GuideTutorial",
 CellID->508481900]
}, Open  ]],
Cell[CellGroupData[{
Cell[6004, 219, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6069, 222, 165, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6237, 227, 152, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[6404, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

