(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32048,        932]
NotebookOptionsPosition[     15241,        518]
NotebookOutlinePosition[     28265,        828]
CellTagsIndexPosition[     27896,        815]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NOTATION PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Advice and Suggested Guidelines", "Title",
 CellTags->"NotationDocumentation",
 CellID->336677607],

Cell[TextData[{
 "The following are some issues and considerations to be aware of when using \
the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package and/or designing notations."
}], "Text",
 CellTags->{
  "Notation:S5", "Notation:Documentation:Guidelines", 
   "NotationDocumentation"},
 CellID->289566130],

Cell[CellGroupData[{

Cell["Build up notations in stages", "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->13484691],

Cell[TextData[{
 "It is intrinsically difficult to debug something you cannot see; therefore, \
it is best to build up notations, seeing if something works or where a \
mistake has been made. It is harder to find errors if you enter a whole \
complex notation before testing it. Many notational problems will usually be \
revealed by examining the full form of an expression or its internal \
structure via ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"\[CommandKey]", "-", "\[ShiftKey]", "-"}]}], TraditionalForm]]],
 "e."
}], "Text",
 CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"},
 CellID->148926216]
}, Open  ]],

Cell[CellGroupData[{

Cell["Don't alter too much", "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->436557],

Cell[TextData[{
 "You should try not to alter too much. For example, changing commas to \
vertical separators is strongly discouraged. The more notational oddities \
present in the system, the higher the chance that one notation will adversely \
interact with another giving unexpected results. Some parsers have mechanisms \
to detect conflicts in a given grammar but the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package does not."
}], "Text",
 CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"},
 CellID->184406575]
}, Open  ]],

Cell[CellGroupData[{

Cell["Follow existing conventions where possible", "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->109409051],

Cell[TextData[{
 "Where possible, you should follow standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " conventions or follow the conventions of a given field. Inventing your own \
individual nonstandard notation is discouraged since such notations are \
necessarily unrecognizable to other users. Even if a notation has an \
historical origin and is not as intuitive as other possible notations the \
author could invent, it is usually better, where possible, to use the \
historical notation. Admittedly, however, it is sometimes difficult to \
resolve the inconsistencies present in a certain notation with the desire to \
have a uniform notation."
}], "Text",
 CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"},
 CellID->702334216]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parse without evaluation where possible", "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->150873128],

Cell["\<\
When designing notations it is desirable to be able to parse an expression to \
its correct full form without evaluation. This is not always possible for \
complex notations where there is no direct correspondence between an external \
form and an internal form. However, for the cases when it is possible there \
should be no side effects from evaluation.\
\>", "Text",
 CellTags->{
  "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
   "NotationDocumentation"},
 CellID->234012466],

Cell["\<\
The following notation does not depend on evaluation in order to behave \
correctly.\
\>", "MathCaption",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->712428571],

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    OverscriptBox["\[ScriptCapitalH]_", "^"],
    "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
   TagBox[
    RowBox[{"Operator", "[", "\[ScriptCapitalH]_", "]"}],
    "NotationTemplateTag"]}], "]"}]], "Input",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellLabel->"In[70]:=",
 CellID->98974843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   OverscriptBox["L", "^"], "]"}], "//", "FullForm"}]], "Input",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellLabel->"In[71]:=",
 CellID->110052215],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Hold", "[", 
    RowBox[{"Operator", "[", "L", "]"}], "]"}],
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellLabel->"Out[71]//FullForm=",
 CellID->91427822]
}, Open  ]],

Cell[TextData[{
 "A common instance of unwanted evaluation comes from testing functions used \
in ",
 ButtonBox["complex pattern matching",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Notation/tutorial/ComplexPatternsAndAdvancedFeatures#202592711"],
 ". If possible you should design testing functions to hold their arguments."
}], "Text",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->522740819],

Cell[TextData[{
 "The notation defined using the testing function ",
 Cell[BoxData[
  ButtonBox["StringNumericQ",
   BaseStyle->"Link",
   ButtonData->
    "paclet:Notation/tutorial/ComplexPatternsAndAdvancedFeatures#107773098"]],
   "InlineFormula"],
 " evaluates its arguments, which can lead to unpredictable results."
}], "MathCaption",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->2087095],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Hold", "[", 
   SubscriptBox["\[CapitalGamma]", 
    RowBox[{"Print", "[", "\"\<Oops...\>\"", "]"}]], "]"}], 
  TraditionalForm]], "Input",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellLabel->"In[72]:=",
 CellID->531146715],

Cell[BoxData["\<\"Oops...\"\>"], "Print",
 CellTags->"NotationDocumentation",
 CellLabel->"From In[72]:=",
 CellID->423475737],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  SubscriptBox["\[CapitalGamma]", 
   RowBox[{"Print", "[", "\<\"Oops...\"\>", "]"}]], "]"}]], "Output",
 ImageSize->{124, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellLabel->"Out[72]=",
 CellID->47230959]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Internal and External representations which are structurally different\
\>", "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->285777041],

Cell[TextData[{
 "In cases when a conventional notation does not easily equate to an internal \
form in ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " it is suggested that you have the notation take the conventional form to \
the internal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " name appended by \"",
 StyleBox["Typeset", "MR"],
 "\". For example the ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " function should have the ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"]
}], "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->455965433],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    SubsuperscriptBox["G", 
     RowBox[{"p", ",", "\[MediumSpace]", "q"}], 
     RowBox[{"m", ",", "\[MediumSpace]", "n"}]], "(", 
    RowBox[{"\[Xi]", "\[VerticalSeparator]", GridBox[{
       {
        RowBox[{
         SubscriptBox["a", "1"], ",", "...", 
         RowBox[{",", 
          SubscriptBox["a", "p"]}]}]},
       {
        RowBox[{
         SubscriptBox["b", "1"], ",", "...", 
         RowBox[{",", 
          SubscriptBox["b", "q"]}]}]}
      }]}], ")"}], " ", " "}], TraditionalForm]], "Picture",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->608860626],

Cell[TextData[{
 "But the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of the ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " function in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has the following form."
}], "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->75587356],

Cell[BoxData[
 RowBox[{Cell[BoxData[
   ButtonBox["MeijerG",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"], 
  StyleBox["[", "MR"], 
  RowBox[{
   RowBox[{
    StyleBox["{", "MR"], 
    RowBox[{
     RowBox[{
      StyleBox["{", "MR"], 
      RowBox[{
       FormBox[
        SubscriptBox["a", "1"],
        TraditionalForm], ",", "\[Ellipsis]", " ", ",", " ", 
       FormBox[
        SubscriptBox["a", "n"],
        TraditionalForm]}], 
      StyleBox["}", "MR"]}], 
     StyleBox[",", "MR"], 
     StyleBox[" ", "MR"], 
     RowBox[{
      StyleBox["{", "MR"], 
      RowBox[{
       FormBox[
        SubscriptBox["a", 
         RowBox[{"n", "+", "1"}]],
        TraditionalForm], ",", "\[Ellipsis]", " ", ",", " ", 
       FormBox[
        SubscriptBox["a", "p"],
        TraditionalForm]}], 
      StyleBox["}", "MR"]}]}], 
    StyleBox["}", "MR"]}], 
   StyleBox[",", "MR"], " ", 
   RowBox[{
    StyleBox["{", "MR"], 
    RowBox[{
     RowBox[{
      StyleBox["{", "MR"], 
      RowBox[{
       FormBox[
        SubscriptBox["b", "1"],
        TraditionalForm], ",", "\[Ellipsis]", " ", ",", " ", 
       FormBox[
        SubscriptBox["b", "m"],
        TraditionalForm]}], 
      StyleBox["}", "MR"]}], 
     StyleBox[",", "MR"], 
     StyleBox[" ", "MR"], 
     RowBox[{
      StyleBox["{", "MR"], 
      RowBox[{
       FormBox[
        SubscriptBox["b", 
         RowBox[{"m", "+", "1"}]],
        TraditionalForm], ",", "\[Ellipsis]", " ", ",", " ", 
       FormBox[
        SubscriptBox["b", "q"],
        TraditionalForm]}], 
      StyleBox["}", "MR"]}]}], 
    StyleBox["}", "MR"]}], 
   StyleBox[",", "MR"], " ", 
   FormBox["\[Xi]",
    TraditionalForm]}], 
  StyleBox["]", "MR"]}]], "Picture",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->245154521],

Cell[TextData[{
 "Therefore it is necessary to verify that the ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]]],
 " are numbers having the right values before it is even ",
 StyleBox["possible",
  FontSlant->"Italic"],
 " to construct the internal form of the ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " function. It is not possible to convert from the conventional form to the \
internal form ",
 StyleBox["without",
  FontSlant->"Italic"],
 " evaluation."
}], "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->501485465],

Cell[TextData[{
 "Therefore, in this case, we should take the traditional ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " box structure to a ",
 Cell[BoxData[
  RowBox[{" ", "MeijerGTypeset"}]], "InlineFormula"],
 StyleBox["[{{", "MR"],
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 ",",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 StyleBox["},{", "MR"],
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 StyleBox[",", "MR"],
 Cell[BoxData[
  FormBox["q", TraditionalForm]]],
 StyleBox["}},{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "1"], TraditionalForm]]],
 StyleBox[",", "MR"],
 "...",
 StyleBox[",", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "p"], TraditionalForm]]],
 StyleBox["},{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]]],
 StyleBox[",", "MR"],
 "...",
 StyleBox[",", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "q"], TraditionalForm]]],
 StyleBox["}}]", "MR"],
 ". Then evaluation takes this to the internal ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " function once it is has been established that it is possible to construct \
it."
}], "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->175839526],

Cell[TextData[{
 "Another possible case of this is taking a ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " defined using a ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 " to the expression ",
 StyleBox["TensorTypeset", "MR"],
 ". Then evaluation takes this to an internal form ",
 StyleBox["Tensor", "MR"],
 ", provided that the structure is valid, that is, the tensor does not have a \
contravariant and covariant index in the same column, etc."
}], "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->374508420],

Cell[BoxData[
 StyleBox[GridBox[{
    {" ", 
     StyleBox["Boxes",
      FontWeight->"Bold"], " "},
    {Cell[BoxData[
      ButtonBox["MakeBoxes",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"], 
     RowBox[{"\[UpArrow]", "\[DownArrow]"}], Cell[BoxData[
      ButtonBox["MakeExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"]},
    {" ", 
     StyleBox["Typeset",
      FontWeight->"Bold"], " "},
    {
     StyleBox["Formatting", "TI",
      FontSlant->"Italic"], 
     RowBox[{"\[UpArrow]", "\[DownArrow]"}], 
     StyleBox["Evaluation", "TI",
      FontSlant->"Italic"]},
    {" ", 
     StyleBox["FullForm",
      FontWeight->"Bold"], " "}
   },
   GridBoxAlignment->{
    "Columns" -> {Right, Center, {Left}}, "ColumnsIndexed" -> {}, 
     "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  SpanMinSize->4]], "Picture",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->39504829]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Advice and Suggested Guidelines - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 3.1554368}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Notation Package Tutorial",
     "language" -> "en", "paclet" -> "Notation Package", "status" -> "None", 
    "summary" -> 
    "The following are some issues and considerations to be aware of when \
using the Notation package and/or designing notations. It is intrinsically \
difficult to debug something you cannot see; therefore, it is best to build \
up notations, seeing if something works or where a mistake has been made. It \
is harder to find errors if you enter a whole complex notation before testing \
it. Many notational problems will usually be revealed by examining the full \
form of an expression or its internal structure via CMD-\\[ShiftKey]-e. You \
should try not to alter too much. For example, changing commas to vertical \
separators is strongly discouraged. The more notational oddities present in \
the system, the higher the chance that one notation will adversely interact \
with another giving unexpected results. Some parsers have mechanisms to \
detect conflicts in a given grammar but the Notation package does not.", 
    "synonyms" -> {}, "title" -> "Advice and Suggested Guidelines", "type" -> 
    "Tutorial", "uri" -> "Notation/tutorial/AdviceAndSuggestedGuidelines"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "NotationDocumentation"->{
  Cell[733, 29, 104, 2, 70, "Title",
   CellTags->"NotationDocumentation",
   CellID->336677607],
  Cell[840, 33, 316, 10, 70, "Text",
   CellTags->{
    "Notation:S5", "Notation:Documentation:Guidelines", 
     "NotationDocumentation"},
   CellID->289566130],
  Cell[1181, 47, 119, 2, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->13484691],
  Cell[1303, 51, 638, 14, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"},
   CellID->148926216],
  Cell[1978, 70, 109, 2, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->436557],
  Cell[2090, 74, 545, 11, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"},
   CellID->184406575],
  Cell[2672, 90, 134, 2, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->109409051],
  Cell[2809, 94, 765, 14, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"},
   CellID->702334216],
  Cell[3611, 113, 131, 2, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->150873128],
  Cell[3745, 117, 505, 10, 70, "Text",
   CellTags->{
    "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
     "NotationDocumentation"},
   CellID->234012466],
  Cell[4253, 129, 205, 5, 70, "MathCaption",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->712428571],
  Cell[4461, 136, 407, 11, 70, "Input",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->98974843],
  Cell[4893, 151, 226, 6, 70, "Input",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->110052215],
  Cell[5122, 159, 374, 12, 50, "Output",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->91427822],
  Cell[5511, 174, 432, 10, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->522740819],
  Cell[5946, 186, 428, 11, 70, "MathCaption",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->2087095],
  Cell[6399, 201, 288, 8, 70, "Input",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->531146715],
  Cell[6690, 211, 126, 3, 70, "Print",
   CellTags->"NotationDocumentation",
   CellID->423475737],
  Cell[6819, 216, 342, 9, 38, "Output",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->47230959],
  Cell[7210, 231, 170, 4, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->285777041],
  Cell[7383, 237, 759, 23, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->455965433],
  Cell[8145, 262, 656, 20, 70, "Picture",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->608860626],
  Cell[8804, 284, 473, 17, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->75587356],
  Cell[9280, 303, 1835, 67, 70, "Picture",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->245154521],
  Cell[11118, 372, 812, 28, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->501485465],
  Cell[11933, 402, 1385, 51, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->175839526],
  Cell[13321, 455, 626, 17, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->374508420],
  Cell[13950, 474, 1237, 38, 70, "Picture",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->39504829]},
 "Notation:S5"->{
  Cell[840, 33, 316, 10, 70, "Text",
   CellTags->{
    "Notation:S5", "Notation:Documentation:Guidelines", 
     "NotationDocumentation"},
   CellID->289566130],
  Cell[1181, 47, 119, 2, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->13484691],
  Cell[1303, 51, 638, 14, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"},
   CellID->148926216],
  Cell[1978, 70, 109, 2, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->436557],
  Cell[2090, 74, 545, 11, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"},
   CellID->184406575],
  Cell[2672, 90, 134, 2, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->109409051],
  Cell[2809, 94, 765, 14, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"},
   CellID->702334216],
  Cell[3611, 113, 131, 2, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->150873128],
  Cell[3745, 117, 505, 10, 70, "Text",
   CellTags->{
    "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
     "NotationDocumentation"},
   CellID->234012466],
  Cell[4253, 129, 205, 5, 70, "MathCaption",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->712428571],
  Cell[4461, 136, 407, 11, 70, "Input",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->98974843],
  Cell[4893, 151, 226, 6, 70, "Input",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->110052215],
  Cell[5122, 159, 374, 12, 50, "Output",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->91427822],
  Cell[5511, 174, 432, 10, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->522740819],
  Cell[5946, 186, 428, 11, 70, "MathCaption",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->2087095],
  Cell[6399, 201, 288, 8, 70, "Input",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->531146715],
  Cell[6819, 216, 342, 9, 38, "Output",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->47230959],
  Cell[7210, 231, 170, 4, 70, "Section",
   CellTags->{"Notation:S5", "NotationDocumentation"},
   CellID->285777041],
  Cell[7383, 237, 759, 23, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->455965433],
  Cell[8145, 262, 656, 20, 70, "Picture",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->608860626],
  Cell[8804, 284, 473, 17, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->75587356],
  Cell[9280, 303, 1835, 67, 70, "Picture",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->245154521],
  Cell[11118, 372, 812, 28, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->501485465],
  Cell[11933, 402, 1385, 51, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->175839526],
  Cell[13321, 455, 626, 17, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->374508420],
  Cell[13950, 474, 1237, 38, 70, "Picture",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->39504829]},
 "Notation:Documentation:Guidelines"->{
  Cell[840, 33, 316, 10, 70, "Text",
   CellTags->{
    "Notation:S5", "Notation:Documentation:Guidelines", 
     "NotationDocumentation"},
   CellID->289566130]},
 "Notation:S5.1"->{
  Cell[1303, 51, 638, 14, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"},
   CellID->148926216]},
 "Notation:S5.2"->{
  Cell[2090, 74, 545, 11, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"},
   CellID->184406575]},
 "Notation:S5.3"->{
  Cell[2809, 94, 765, 14, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"},
   CellID->702334216]},
 "Notation:S5.4"->{
  Cell[3745, 117, 505, 10, 70, "Text",
   CellTags->{
    "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
     "NotationDocumentation"},
   CellID->234012466],
  Cell[4253, 129, 205, 5, 70, "MathCaption",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->712428571],
  Cell[4461, 136, 407, 11, 70, "Input",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->98974843],
  Cell[4893, 151, 226, 6, 70, "Input",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->110052215],
  Cell[5122, 159, 374, 12, 50, "Output",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->91427822],
  Cell[5511, 174, 432, 10, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->522740819],
  Cell[5946, 186, 428, 11, 70, "MathCaption",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->2087095],
  Cell[6399, 201, 288, 8, 70, "Input",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->531146715],
  Cell[6819, 216, 342, 9, 38, "Output",
   CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
   CellID->47230959]},
 "Parse without evaluation"->{
  Cell[3745, 117, 505, 10, 70, "Text",
   CellTags->{
    "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
     "NotationDocumentation"},
   CellID->234012466]},
 "Notation:S5.5"->{
  Cell[7383, 237, 759, 23, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->455965433],
  Cell[8145, 262, 656, 20, 70, "Picture",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->608860626],
  Cell[8804, 284, 473, 17, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->75587356],
  Cell[9280, 303, 1835, 67, 70, "Picture",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->245154521],
  Cell[11118, 372, 812, 28, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->501485465],
  Cell[11933, 402, 1385, 51, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->175839526],
  Cell[13321, 455, 626, 17, 70, "Text",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->374508420],
  Cell[13950, 474, 1237, 38, 70, "Picture",
   CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
   CellID->39504829]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"NotationDocumentation", 17413, 561},
 {"Notation:S5", 21123, 650},
 {"Notation:Documentation:Guidelines", 24657, 733},
 {"Notation:S5.1", 24841, 739},
 {"Notation:S5.2", 24995, 743},
 {"Notation:S5.3", 25149, 747},
 {"Notation:S5.4", 25303, 751},
 {"Parse without evaluation", 26592, 781},
 {"Notation:S5.5", 26786, 787}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 108, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[733, 29, 104, 2, 70, "Title",
 CellTags->"NotationDocumentation",
 CellID->336677607],
Cell[840, 33, 316, 10, 70, "Text",
 CellTags->{
  "Notation:S5", "Notation:Documentation:Guidelines", 
   "NotationDocumentation"},
 CellID->289566130],
Cell[CellGroupData[{
Cell[1181, 47, 119, 2, 70, "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->13484691],
Cell[1303, 51, 638, 14, 70, "Text",
 CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"},
 CellID->148926216]
}, Open  ]],
Cell[CellGroupData[{
Cell[1978, 70, 109, 2, 70, "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->436557],
Cell[2090, 74, 545, 11, 70, "Text",
 CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"},
 CellID->184406575]
}, Open  ]],
Cell[CellGroupData[{
Cell[2672, 90, 134, 2, 70, "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->109409051],
Cell[2809, 94, 765, 14, 70, "Text",
 CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"},
 CellID->702334216]
}, Open  ]],
Cell[CellGroupData[{
Cell[3611, 113, 131, 2, 70, "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->150873128],
Cell[3745, 117, 505, 10, 70, "Text",
 CellTags->{
  "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
   "NotationDocumentation"},
 CellID->234012466],
Cell[4253, 129, 205, 5, 70, "MathCaption",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->712428571],
Cell[4461, 136, 407, 11, 70, "Input",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->98974843],
Cell[CellGroupData[{
Cell[4893, 151, 226, 6, 70, "Input",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->110052215],
Cell[5122, 159, 374, 12, 50, "Output",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->91427822]
}, Open  ]],
Cell[5511, 174, 432, 10, 70, "Text",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->522740819],
Cell[5946, 186, 428, 11, 70, "MathCaption",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->2087095],
Cell[CellGroupData[{
Cell[6399, 201, 288, 8, 70, "Input",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->531146715],
Cell[6690, 211, 126, 3, 70, "Print",
 CellTags->"NotationDocumentation",
 CellID->423475737],
Cell[6819, 216, 342, 9, 38, "Output",
 CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"},
 CellID->47230959]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7210, 231, 170, 4, 70, "Section",
 CellTags->{"Notation:S5", "NotationDocumentation"},
 CellID->285777041],
Cell[7383, 237, 759, 23, 70, "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->455965433],
Cell[8145, 262, 656, 20, 70, "Picture",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->608860626],
Cell[8804, 284, 473, 17, 70, "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->75587356],
Cell[9280, 303, 1835, 67, 70, "Picture",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->245154521],
Cell[11118, 372, 812, 28, 70, "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->501485465],
Cell[11933, 402, 1385, 51, 70, "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->175839526],
Cell[13321, 455, 626, 17, 70, "Text",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->374508420],
Cell[13950, 474, 1237, 38, 70, "Picture",
 CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"},
 CellID->39504829]
}, Open  ]]
}, Open  ]],
Cell[15214, 516, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

