(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83938,       2367]
NotebookOptionsPosition[     40942,       1345]
NotebookOutlinePosition[     74029,       2108]
CellTagsIndexPosition[     73257,       2088]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NOTATION PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SyntaxForm" :> 
         Documentation`HelpLookup["paclet:ref/SyntaxForm"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"SyntaxForm\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Complex Patterns and Advanced Features", "Title",
 CellTags->"NotationDocumentation",
 CellID->683412692],

Cell["This tutorial is intended for advanced users.", "Subsection",
 CellGroupingRules->"NormalGrouping",
 CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"},
 CellID->65452685],

Cell[TextData[{
 "Due to the complex inner workings of the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package it is helpful to outline some of the more advanced features and \
structures of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end and how they relate to the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package. The following sections give a small overview of the functionality \
of tag boxes the specific tags used by the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package and the tag box option SyntaxForm."
}], "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.1", "Notation:Documentation:Advanced Features", 
   "NotationDocumentation"},
 CellID->286358008],

Cell[TextData[{
 "The reader should be familiar with the concepts in ",
 ButtonBox["Textual Input and Output",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TextualInputAndOutputOverview"],
 " and moreover understand the following tutorials: ",
 ButtonBox["The Representation of Textual Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheRepresentationOfTextualForms"],
 ", ",
 ButtonBox["The Interpretation of Textual Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInterpretationOfTextualForms"],
 ", ",
 ButtonBox["Representing Textual Forms by Boxes",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"],
 ", ",
 ButtonBox["String Representation of Boxes",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/StringRepresentationOfBoxes"],
 ", ",
 ButtonBox["Converting between Strings, Boxes, and Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ConvertingBetweenStringsBoxesAndExpressions"],
 ", and ",
 ButtonBox["Low-Level Input and Output Rules",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LowLevelInputAndOutputRules"],
 "."
}], "Text",
 CellTags->"NotationDocumentation",
 CellID->304634832],

Cell[CellGroupData[{

Cell["Tag boxes", "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->108680983],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " is a box structure just like ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SubscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubscriptBox"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 ". It is used to change the structure of an expression or indicate a \
grouping or interpretation of a subexpression at an underlying level. To \
illustrate tag boxes consider the following input which contains an embedded \
",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
   "NotationDocumentation"},
 CellID->783014032],

Cell[BoxData[
 TagBox[
  SuperscriptBox["x", "2"],
  foo]], "Input",
 Evaluatable->False,
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->76814026],

Cell[TextData[{
 "All ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input and output is made up of box structures at a low level. When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " receives input, these box structures are parsed into internal expressions, \
which can be thought of as full form expressions. Internal evaluation then \
takes place, and finally the internal structures are transformed back into \
box structures for displaying in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. We can reveal how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sees this input at a low level by using the ",
 StyleBox["Show Expression",
  FontFamily->"Helvetica"],
 " command under the ",
 StyleBox["Cell",
  FontFamily->"Helvetica"],
 " menu."
}], "Text",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->181028596],

Cell[TextData[{
 "Here is the underlying representation of the expression above in terms of \
boxes, displayed using the ",
 StyleBox["Show Expression", "SR"],
 " menu item located under the ",
 StyleBox["Cell", "SR"],
 " menu. "
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->36480980],

Cell[BoxData[
 TagBox[
  SuperscriptBox["x", "2"],
  foo]], "Input",
 CellID->167577091],

Cell[TextData[{
 "The above expression contains a subexpression ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["TagBox",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TagBox"], "[", 
    RowBox[{
     RowBox[{
      ButtonBox["SuperscriptBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SuperscriptBox"], "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"x\", \"TI\"]\)\>\"", ",", " ", "\"\<2\>\""}], "]"}], ",", 
     StyleBox["foo", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ". It is important to note that this box expression as normally viewed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " looks visually like ",
 Cell[BoxData[
  TagBox[
   SuperscriptBox["x", "2"],
   foo]]],
 " even though it has an embedded ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 ". Information contained in the tag is visually hidden from the user. When \
an expression containing a ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " is input into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the default interpretation of the subexpression surrounded by the ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " is to wrap the ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " name around the parsed subexpression, in this case to wrap foo around \
x^2."
}], "Text",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->713884108],

Cell[TextData[{
 "The embedded ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " tag ",
 StyleBox["foo", "MR"],
 " has no special parsing behavior associated with it."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->291811214],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  SuperscriptBox["x", "2"],
  foo]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellLabel->"In[55]:=",
 CellID->204380449],

Cell[BoxData[
 RowBox[{"foo", "[", 
  SuperscriptBox["x", "2"], "]"}]], "Output",
 ImageSize->{52, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellLabel->"Out[55]=",
 CellID->4001723]
}, Open  ]],

Cell[TextData[{
 "However you can define your own rules for the way specific tag boxes are \
parsed. For instance by using the low level function ",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 " we can change how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will parse expressions containing ",
 StyleBox["TagBoxes", "MR"],
 "."
}], "Text",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->114489376],

Cell[TextData[{
 "By defining a new rule for ",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 " we can change how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will parse expressions containing a ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " with the tag ",
 StyleBox["literalBoxes", "MR"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->467928923],

Cell[BoxData[
 RowBox[{
  RowBox[{"MakeExpression", "[", 
   RowBox[{
    RowBox[{"TagBox", "[", 
     RowBox[{"expr_", ",", "literalBoxes"}], "]"}], ",", "form_"}], "]"}], ":=",
   
  RowBox[{"HoldComplete", "[", "expr", "]"}]}]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellLabel->"In[56]:=",
 CellID->929594838],

Cell[TextData[{
 "The embedded ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " tag ",
 StyleBox["literalBoxes", "MR"],
 " now has the special parsing behavior associated with it to just return the \
boxes."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->44818625],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  SuperscriptBox["x", "2"],
  literalBoxes]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellLabel->"In[57]:=",
 CellID->374056543],

Cell[BoxData[
 RowBox[{"SuperscriptBox", "[", 
  RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellLabel->"Out[57]=",
 CellID->26160784]
}, Open  ]],

Cell[TextData[{
 "Knowing that special behaviors can be set up for specific tags we can now \
examine the tags defined by the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package. The ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package defines three tags that have special behaviors: ",
 StyleBox["NotationTemplateTag", "MR"],
 ", ",
 Cell[BoxData[
  ButtonBox["NotationPatternTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationPatternTag"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["NotationMadeBoxesTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationMadeBoxesTag"]], 
  "InlineFormula"],
 ". These are all string tags for two reasons. One, by using string tags we \
can avoid any potential problems to do with package contexts and redefinition \
of the symbols. Secondly, in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " if a ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " has a string tag and there is a named-style on the stylesheet path with \
the same name as the string tag then the ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " will be displayed in that style.",
 " ",
 "This lets us omit the ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " option from the ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " and consequently our box structures are smaller and more readable."
}], "Text",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->568491970]
}, Open  ]],

Cell[CellGroupData[{

Cell["The tag NotationTemplateTag", "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->10645498],

Cell[TextData[{
 StyleBox["NotationTemplateTag", "MR"],
 " is a string tag used by the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package to grab box structures before they can be parsed by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In fact ",
 StyleBox["NotationTemplateTag", "MR"],
 " acts rather like the tag ",
 StyleBox["literalBoxes", "MR"],
 " defined above. All ",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 " , ",
 Cell[BoxData[
  ButtonBox["Symbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " templates on the ",
 ButtonBox["notation palette",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`ToFileName[{$InstallationDirectory, "AddOns", "Packages", 
      "Notation", "LocalPalettes", "English", "NotationPalette.nb"}], None},
  ButtonNote->"Show Palette"],
 " contain tag boxes with an embedded string tag: ",
 StyleBox["NotationTemplateTag", "MR"],
 ". The embedded ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " ensures that the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package can obtain the correct parsing information and retain the proper \
styling and grouping information. This embedded tag is used to capture the \
box structure, and the captured structure is thus wrapped with a \
\"ParsedBoxWrapper\"."
}], "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag", 
   "NotationDocumentation"},
 CellID->281647541],

Cell[TextData[{
 "An expression containing an embedded ",
 StyleBox["NotationTemplateTag", "MR"],
 " tag."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellID->533679860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  TagBox[
   SuperscriptBox["x", "2"],
   "NotationTemplateTag"], "//", "FullForm"}]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellLabel->"In[517]:=",
 CellID->725022287],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"ParsedBoxWrapper", "[", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellLabel->"Out[517]//FullForm=",
 CellID->432189313]
}, Open  ]],

Cell[TextData[{
 "We can avoid using notation templates if we wrap raw box structures with a \
",
 Cell[BoxData[
  ButtonBox["ParsedBoxWrapper",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/ParsedBoxWrapper"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellID->318437420],

Cell[BoxData[
 RowBox[{"Symbolize", "[", " ", 
  RowBox[{"ParsedBoxWrapper", " ", "[", " ", 
   RowBox[{"SubscriptBox", "[", 
    RowBox[{"\"\<fub\>\"", ",", "\"\<_\>\""}], "]"}], " ", "]"}], " ", 
  "]"}]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellLabel->"In[59]:=",
 CellID->209928122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["fub", "1"], "//", "FullForm"}]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellLabel->"In[60]:=",
 CellID->95803853],

Cell[BoxData[
 TagBox[
  StyleBox["fub\[UnderBracket]Subscript\[UnderBracket]1",
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellLabel->"Out[60]//FullForm=",
 CellID->54553883]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complex Patterns and the tag NotationPatternTag", "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->259282198],

Cell[TextData[{
 "For normal purposes it is usually sufficient that the patterns present in \
",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Symbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFormula"],
 " statements are simple patterns. However, it is sometimes necessary or \
desirable to use more complicated patterns in notations. For example, a \
notation might only be valid when a certain pattern is a number. To allow \
more complex patterns you can embed a ",
 Cell[BoxData[
  ButtonBox["NotationPatternTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationPatternTag"]], "InlineFormula"],
 " tag box inside a notation statement. It is critical that any notation you \
define which uses a complex pattern has an embedded ",
 Cell[BoxData[
  ButtonBox["NotationPatternTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationPatternTag"]], "InlineFormula"],
 ", otherwise the pattern will be treated as a verbatim expression and not \
function as a pattern.",
 " ",
 "Like ",
 StyleBox["NotationTemplateTag", "MR"],
 " this should be a string tag. The notation palette has a button labeled \
InsertPatternWrapper which will embed a ",
 Cell[BoxData[
  ButtonBox["NotationPatternTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationPatternTag"]], "InlineFormula"],
 " around the selection, as well as tint the background of the selection to \
indicate that a complex pattern is present. (This tinting occurs as a result \
of the named style ",
 Cell[BoxData[
  ButtonBox["NotationPatternTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationPatternTag"]], "InlineFormula"],
 " since this is a string tag.)"
}], "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag", 
   "NotationDocumentation"},
 CellID->202592711],

Cell[TextData[{
 "This creates a ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " notation that only functions with numbers."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->234084821],

Cell[BoxData[
 FormBox[
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TagBox[
      SubscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"a_", "?", "StringNumericQ"}],
        "NotationPatternTag"]],
      "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
     TagBox[
      RowBox[{"foo", "[", 
       TagBox[
        RowBox[{"a_", "?", "NumericQ"}],
        "NotationPatternTag"], "]"}],
      "NotationTemplateTag"]}], ",", " ", 
    RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], "]"}], 
  TraditionalForm]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellLabel->"In[61]:=",
 CellID->116509125],

Cell["\<\
It must also be pointed out that the pattern matching on the external \
representation is performed on the box structures, so usually you will have \
to make small transformations to convert box structures into normal \
expressions. Pattern matching on the internal representation follows \
conventional pattern matching.\
\>", "Text",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->469720415],

Cell[TextData[{
 "This defines a function analogous to ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " that operates on box structures."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->94731963],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringNumericQ", " ", "[", " ", "any___", "]"}], " ", ":=", " ", 
  RowBox[{"NumericQ", " ", "[", " ", 
   RowBox[{"ToExpression", " ", "[", " ", "any", "]"}], "]"}]}]], "Input",
 CellTags->{
  "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
   "NotationDocumentation"},
 CellLabel->"In[62]:=",
 CellID->107773098],

Cell["\<\
Now only input which matches the above pattern will be interpreted as a foo \
object.\
\>", "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->21149054],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "\[Pi]"], " ", "+", 
   SubscriptBox["\[CapitalGamma]", "h"]}], TraditionalForm]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellLabel->"In[63]:=",
 CellID->640830027],

Cell[BoxData[
 RowBox[{
  RowBox[{"foo", "[", "\[Pi]", "]"}], "+", 
  SubscriptBox["\[CapitalGamma]", "h"]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellLabel->"Out[63]=",
 CellID->1126005]
}, Open  ]],

Cell["\<\
Reciprocally only foo objects with numerical arguments will be formatted \
using the notation.\
\>", "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->526824018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"foo", "[", "\[Pi]", "]"}], "+", 
   RowBox[{"foo", "[", "h", "]"}]}], " ", "//", "TraditionalForm"}]], "Input",\

 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellLabel->"In[64]:=",
 CellID->23996110],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"foo", 
    RowBox[{"(", "h", ")"}]}], "+", 
   SubscriptBox["\[CapitalGamma]", "\[Pi]"]}], TraditionalForm]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellLabel->"Out[64]//TraditionalForm=",
 CellID->565508835]
}, Open  ]],

Cell[TextData[{
 "You should be careful to avoid unwanted evaluation through testing \
functions when parsing expressions (see ",
 ButtonBox["parsing without evaluation",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Notation/tutorial/AdviceAndSuggestedGuidelines#234012466"],
 ".)"
}], "Text",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->448520244],

Cell[TextData[{
 "We can examine the form of the rules created by using the option ",
 Cell[BoxData[
  ButtonBox["Action",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Action"]], "InlineFormula"],
 " \[Rule] ",
 Cell[BoxData[
  ButtonBox["PrintNotationRules",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/PrintNotationRules"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->401455642],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TagBox[
      SubscriptBox["\[CapitalGamma]", 
       TagBox[
        RowBox[{"a_", "?", "StringNumericQ"}],
        "NotationPatternTag"]],
      "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
     TagBox[
      RowBox[{"foo", "[", 
       TagBox[
        RowBox[{"a_", "?", "NumericQ"}],
        "NotationPatternTag"], "]"}],
      "NotationTemplateTag"]}], ",", " ", 
    RowBox[{"Action", " ", "\[Rule]", " ", "PrintNotationRules"}]}], "]"}], 
  TraditionalForm]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellLabel->"In[65]:=",
 CellID->925213327],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotationMakeExpression", "[", 
   RowBox[{
    RowBox[{"SubscriptBox", "[", 
     RowBox[{"\"\<\[CapitalGamma]\>\"", ",", 
      RowBox[{"a_", "?", "StringNumericQ"}]}], "]"}], ",", "StandardForm"}], 
   "]"}], ":=", 
  RowBox[{"MakeExpression", "[", 
   RowBox[{
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<foo\>\"", ",", "\"\<[\>\"", ",", "a", ",", "\"\<]\>\""}], 
      "}"}], "]"}], ",", "StandardForm"}], "]"}]}]], "Output",
 ShowStringCharacters->True,
 ImageSize->{537, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->137094281],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotationMakeBoxes", "[", 
   RowBox[{
    RowBox[{"foo", "[", 
     RowBox[{"a_", "?", "NumericQ"}], "]"}], ",", "StandardForm"}], "]"}], ":=",
   
  RowBox[{"SubscriptBox", "[", 
   RowBox[{"\"\<\[CapitalGamma]\>\"", ",", 
    RowBox[{"Notation`Private`makeEvaluatedRowBoxOfBoxes", "[", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", "StandardForm", ",", "None"}], "]"}]}], 
   "]"}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ShowStringCharacters->True,
 ImageSize->{496, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->216150258]
}, Open  ]],

Cell[TextData[{
 "We can see that the patterns ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a_", "TI"], "?", "StringNumericQ"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a_", "TI"], "?", 
   ButtonBox["NumericQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericQ"]}]], "InlineFormula"],
 " do not appear literally since they were surrounded by a ",
 Cell[BoxData[
  ButtonBox["NotationPatternTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationPatternTag"]], "InlineFormula"],
 " in the notation statement."
}], "Text",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->105823291]
}, Open  ]],

Cell[CellGroupData[{

Cell["The tag NotationMadeBoxesTag", "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->12894544],

Cell[TextData[{
 "The tag ",
 Cell[BoxData[
  ButtonBox["NotationMadeBoxesTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationMadeBoxesTag"]], 
  "InlineFormula"],
 " is intended for advanced users. It is also a string tag. It is used to \
indicate that box processing and formatting has already been done and that \
the Notation package should not perform any processing. Typically you would \
use this tag for surrounding your own functions that return expressions that \
have already been turned into boxes or parsed into expressions. To illustrate \
the tag ",
 Cell[BoxData[
  ButtonBox["NotationMadeBoxesTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationMadeBoxesTag"]], 
  "InlineFormula"],
 " we can examine a notation statement that might be part of a number of \
statements used to create a notation for Tensors."
}], "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.5", "Notation:Definition:NotationMadeBoxesTag", 
   "NotationDocumentation"},
 CellID->24102047],

Cell[TextData[{
 "An example notation for formatting tensors containing the tag ",
 Cell[BoxData[
  ButtonBox["NotationMadeBoxesTag",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/NotationMadeBoxesTag"]], 
  "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
 CellID->182634440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"Notation", "[", 
   RowBox[{
    RowBox[{
     TagBox[
      TagBox[
       RowBox[{
        StyleBox["\[CapitalGamma]_",
         FontWeight->"Bold"], 
        TagBox[
         RowBox[{"createGridBox", "[", "inds_", "]"}],
         "NotationMadeBoxesTag"]}],
       Tensor],
      "NotationTemplateTag"], " ", "\[DoubleLongLeftArrow]", " ", 
     TagBox[
      RowBox[{"Tensor", "[", 
       RowBox[{"\[CapitalGamma]_", ",", 
        TagBox[
         RowBox[{"inds_", "?", "validIndiciesQ"}],
         "NotationPatternTag"]}], "]"}],
      "NotationTemplateTag"]}], ",", 
    RowBox[{"Action", " ", "\[Rule]", " ", "PrintNotationRules"}]}], 
   "]"}]}]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
 CellLabel->"In[66]:=",
 CellID->111474825],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotationMakeBoxes", "[", 
   RowBox[{
    RowBox[{"Tensor", "[", 
     RowBox[{"\[CapitalGamma]_", ",", 
      RowBox[{"inds_", "?", "validIndiciesQ"}]}], "]"}], ",", 
    "StandardForm"}], "]"}], ":=", 
  RowBox[{"TagBox", "[", 
   RowBox[{
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"StyleBox", "[", 
        RowBox[{
         RowBox[{"MakeBoxes", "[", 
          RowBox[{"\[CapitalGamma]", ",", "StandardForm"}], "]"}], ",", 
         RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "]"}], ",", 
       RowBox[{"createGridBox", "[", "inds", "]"}]}], "}"}], "]"}], ",", 
    "Tensor"}], "]"}]}]], "Output",
 ShowStringCharacters->True,
 ImageSize->{512, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
 CellID->336642267]
}, Open  ]],

Cell[TextData[{
 "We can see from the internal definition returned that there is no further \
processing of the expression ",
 Cell[BoxData[
  RowBox[{
   StyleBox["createGridBox", "TI"], "[", 
   StyleBox["inds", "TI"], "]"}]], "InlineFormula"],
 ", i.e. it is not surrounded by a ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MakeBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeBoxes"], "[", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    ButtonBox["StandardForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StandardForm"]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
 CellID->7622121]
}, Open  ]],

Cell[CellGroupData[{

Cell["Changing precedences and the TagBox option SyntaxForm", "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->197209834],

Cell[TextData[{
 "Using the option ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " you can change the precedence of an expression containing a ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 ". A tag box containing a ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " option will look like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TagBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagBox"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["box", "TI"], " ", 
     StyleBox["structure", "TI"]}], ",", " ", 
    StyleBox["tag", "TI"], ",", " ", 
    RowBox[{
     ButtonBox["SyntaxForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SyntaxForm"], " ", "->", " ", 
     StyleBox["string", "TI"]}]}], "]"}]], "InlineFormula"],
 StyleBox[",", "MR"],
 " where ",
 StyleBox["string",
  FontSlant->"Italic"],
 " is a string indicating the operator on which the precedence of the tag box \
is modeled. The following examples illustrate the ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " option . "
}], "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.6", 
   "Changing precedences and the option SyntaxForm", 
   "Notation:Documentation:SyntaxForm", "NotationDocumentation"},
 CellID->4576917],

Cell["\<\
An expression which uses the arrow \[LongLeftRightArrow] with standard \
precedences.\
\>", "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->190975443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "+", 
   RowBox[{"b", " ", "\[LongLeftRightArrow]", " ", "c"}]}], "//", 
  "FullForm"}]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellLabel->"In[67]:=",
 CellID->179671412],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"a", ",", 
     RowBox[{"LongLeftRightArrow", "[", 
      RowBox[{"b", ",", "c"}], "]"}]}], "]"}],
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellLabel->"Out[67]//FullForm=",
 CellID->674471613]
}, Open  ]],

Cell[TextData[{
 "We can define a new notation for a composite arrow \[LongLeftRightArrow] \
surrounded by a ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " that has the ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " option set to a low precedence."
}], "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->120804539],

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    RowBox[{"a_", " ", 
     TagBox["\[LongLeftRightArrow]",
      Identity,
      SyntaxForm->","], "b_"}],
    "NotationTemplateTag"], " ", "\[DoubleLongRightArrow]", " ", 
   TagBox[
    RowBox[{"LongLeftRightArrow", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}],
    "NotationTemplateTag"]}], "]"}]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellLabel->"In[68]:=",
 CellID->315630718],

Cell["This new composite arrow has a low precedence.", "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->17091424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", " ", 
   RowBox[{
    RowBox[{"a", " ", "+", " ", "b"}], " ", 
    TagBox["\[LongLeftRightArrow]",
     Identity,
     SyntaxForm->","], "c"}], ")"}], "//", "FullForm"}]], "Input",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellLabel->"In[69]:=",
 CellID->901340367],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"LongLeftRightArrow", "[", 
    RowBox[{
     RowBox[{"Plus", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}],
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellLabel->"Out[69]//FullForm=",
 CellID->19061706]
}, Open  ]],

Cell["\<\
We can illustrate the underlying groupings of the expressions above in the \
following table.\
\>", "Text",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->202363133],

Cell[BoxData[GridBox[{
   {Cell["visual form of expression", "TableHeader"], Cell[
    "grouping", "TableHeader"], Cell[
    "box form of expression", "TableHeader"]},
   {
    StyleBox[
     FormBox[
      RowBox[{"a", 
       StyleBox["+", "MR"], "b", " ", "\[LongLeftRightArrow]", " ", "c"}],
      TraditionalForm], "TI"], 
    StyleBox[
     FormBox[
      RowBox[{
      "a", "+", "(", "b", " ", "\[LongLeftRightArrow]", " ", "c", ")"}],
      StandardForm], "Text"], 
    StyleBox[
     FormBox[
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"BoxData", "[", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<a\>\"", ",", " ", "\"\<+\>\"", ",", "\n", " ", 
            RowBox[{"RowBox", 
             RowBox[{"[", "{"}], "\"\<b\>\""}], ",", " ", "\"\< \>\"", ",", 
            " ", "\"\<\[LongLeftRightArrow]\>\"", ",", " ", "\"\< \>\"", ",", 
            " ", 
            RowBox[{"\"\<c\>\"", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"}", "]"}], "}"}], "]"}], "]"}], ","}], " ", 
             "\"\<Input\>\""}]}]}]}]}]}], "]"}],
      StandardForm], "Text"]},
   {
    StyleBox[
     FormBox[
      RowBox[{"a", 
       StyleBox["+", "MR"], "b", " ", 
       TagBox["\[LongLeftRightArrow]",
        Identity], " ", "c"}],
      TraditionalForm], "TI"], 
    StyleBox[
     FormBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], " ", 
       TagBox["\[LongLeftRightArrow]",
        Identity,
        SyntaxForm->","], " ", "c"}],
      StandardForm], "Text"], 
    StyleBox[
     FormBox[
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"BoxData", "[", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"RowBox", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<a\>\"", ",", " ", "\"\<+\>\"", ",", 
              RowBox[{"\"\<b\>\"", 
               RowBox[{
                RowBox[{"}", "]"}], ","}], " ", "\"\< \>\""}], ",", " ", "\n",
               
              RowBox[{"TagBox", "[", 
               RowBox[{
               "\"\<\[LongLeftRightArrow]\>\"", ",", "Identity", ",", 
                RowBox[{"SyntaxForm", " ", "->", "\"\<,\>\""}]}], "]"}], ",", 
              " ", "\"\< \>\"", ",", " ", 
              RowBox[{"\"\<c\>\"", 
               RowBox[{
                RowBox[{
                 RowBox[{"}", "]"}], "]"}], ","}], " ", 
               "\"\<Input\>\""}]}]}]}]}]}]}]}], "]"}],
      StandardForm], "Text"]}
  }]], "DefinitionBox3Col",
 PageWidth->WindowWidth,
 CellID->3686592],

Cell["\<\
A table illustrating the precedences and grouping of expressions with and \
without precedence changing tag boxes.\
\>", "Caption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->187808373],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " option value can be any operator string valid in ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " that is, any operator contained in the ",
 StyleBox["UnicodeCharacters.tr", "MR"],
 " file. The ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " value can also include symbols before and after the operator to indicate \
whether the precedence is that of a prefix operator, an infix operator, or a \
postfix operator. Some typical values for the ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " option are given in the table below."
}], "Text",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->230427148],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SyntaxForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula",
      FontSlant->"Plain"],
     " value"
    }], "TableHeader"], Cell["precedence behavior", "TableHeader"]},
   {
    StyleBox[
     FormBox["\"\<*\>\"",
      StandardForm], "Text"], Cell[
    "group as the operator times", "TableText"]},
   {
    StyleBox[
     FormBox["\"\<a\>\"",
      StandardForm], "Text"], Cell["group as a symbol", "TableText"]},
   {
    StyleBox[
     FormBox["\"\<a+b\>\"",
      StandardForm], "Text"], Cell[
    "group as an infix plus operator", "TableText"]},
   {
    StyleBox[
     FormBox["\"\<\[ForAll]\>\"",
      StandardForm], "Text"], Cell[
    "group as a for all operator", "TableText"]},
   {
    StyleBox[
     FormBox["\"\<\[Integral]\>\"",
      StandardForm], "Text"], Cell[
    "group as an integrate operator", "TableText"]},
   {
    StyleBox[
     FormBox["\"\<\[Union] a\>\"",
      StandardForm], "Text"], Cell[
    "group as a prefix union operator", "TableText"]},
   {
    StyleBox[
     FormBox["\"\< \>\"",
      StandardForm], "Text"], Cell["group as white space", "TableText"]}
  }]], "DefinitionBox", "TableHeaderLine",
 CellID->145821],

Cell[TextData[{
 "Typical ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " values and their associated precedence behaviors."
}], "Caption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->105776152]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Complex Patterns and Advanced Features - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 3.4210686}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Notation Package Tutorial",
     "language" -> "en", "paclet" -> "Notation Package", "status" -> "None", 
    "summary" -> 
    "Due to the complex inner workings of the Notation package it is helpful \
to outline some of the more advanced features and structures of the \
Mathematica front end and how they relate to the Notation package. The \
following sections give a small overview of the functionality of tag boxes \
the specific tags used by the Notation package and the tag box option \
SyntaxForm. The reader should be familiar with the concepts in Textual Input \
and Output and moreover understand the following tutorials: The \
Representation of Textual Forms, The Interpretation of Textual Forms, \
Representing Textual Forms by Boxes, String Representation of Boxes, \
Converting between Strings, Boxes, and Expressions, and Low-Level Input and \
Output Rules. A TagBox is a box structure just like RowBox, SubscriptBox, \
GridBox. It is used to change the structure of an expression or indicate a \
grouping or interpretation of a subexpression at an underlying level. To \
illustrate tag boxes consider the following input which contains an embedded \
TagBox.", "synonyms" -> {}, "title" -> 
    "Complex Patterns and Advanced Features", "type" -> "Tutorial", "uri" -> 
    "Notation/tutorial/ComplexPatternsAndAdvancedFeatures"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "NotationDocumentation"->{
  Cell[1196, 42, 111, 2, 70, "Title",
   CellTags->"NotationDocumentation",
   CellID->683412692],
  Cell[1310, 46, 194, 3, 70, "Subsection",
   CellGroupingRules->"NormalGrouping",
   CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"},
   CellID->65452685],
  Cell[1507, 51, 715, 20, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.1", 
     "Notation:Documentation:Advanced Features", "NotationDocumentation"},
   CellID->286358008],
  Cell[2225, 73, 1195, 32, 70, "Text",
   CellTags->"NotationDocumentation",
   CellID->304634832],
  Cell[3445, 109, 101, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->108680983],
  Cell[3549, 113, 1038, 34, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
     "NotationDocumentation"},
   CellID->783014032],
  Cell[4590, 149, 178, 6, 70, "Input",
   Evaluatable->False,
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->76814026],
  Cell[4771, 157, 891, 25, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->181028596],
  Cell[5665, 184, 337, 9, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->36480980],
  Cell[6096, 201, 1666, 52, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->713884108],
  Cell[7765, 255, 347, 11, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->291811214],
  Cell[8137, 270, 182, 6, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->204380449],
  Cell[8322, 278, 280, 8, 39, "Output",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->4001723],
  Cell[8617, 289, 528, 15, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->114489376],
  Cell[9148, 306, 574, 19, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->467928923],
  Cell[9725, 327, 354, 10, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->929594838],
  Cell[10082, 339, 387, 12, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->44818625],
  Cell[10494, 355, 191, 6, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->374056543],
  Cell[10688, 363, 308, 8, 36, "Output",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->26160784],
  Cell[11011, 374, 1765, 52, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->568491970],
  Cell[12813, 431, 118, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->10645498],
  Cell[12934, 435, 1776, 52, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag", 
     "NotationDocumentation"},
   CellID->281647541],
  Cell[14713, 489, 215, 6, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->533679860],
  Cell[14953, 499, 234, 7, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->725022287],
  Cell[15190, 508, 458, 14, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->432189313],
  Cell[15663, 525, 355, 10, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->318437420],
  Cell[16021, 537, 330, 8, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->209928122],
  Cell[16376, 549, 194, 5, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->95803853],
  Cell[16573, 556, 347, 10, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->54553883],
  Cell[16969, 572, 139, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->259282198],
  Cell[17111, 576, 1996, 49, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag", 
     "NotationDocumentation"},
   CellID->202592711],
  Cell[19110, 627, 324, 9, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->234084821],
  Cell[19437, 638, 694, 21, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->116509125],
  Cell[20134, 661, 435, 8, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->469720415],
  Cell[20572, 671, 321, 9, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->94731963],
  Cell[20896, 682, 371, 9, 70, "Input",
   CellTags->{
    "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
     "NotationDocumentation"},
   CellID->107773098],
  Cell[21270, 693, 205, 5, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->21149054],
  Cell[21500, 702, 275, 7, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->640830027],
  Cell[21778, 711, 319, 9, 36, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->1126005],
  Cell[22112, 723, 215, 5, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->526824018],
  Cell[22352, 732, 273, 8, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->23996110],
  Cell[22628, 742, 384, 11, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->565508835],
  Cell[23027, 756, 385, 10, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->448520244],
  Cell[23415, 768, 485, 14, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->401455642],
  Cell[23925, 786, 692, 21, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->925213327],
  Cell[24620, 809, 693, 19, 54, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->137094281],
  Cell[25316, 830, 694, 20, 54, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->216150258],
  Cell[26025, 853, 663, 20, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->105823291],
  Cell[26725, 878, 119, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->12894544],
  Cell[26847, 882, 1017, 24, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.5", 
     "Notation:Definition:NotationMadeBoxesTag", "NotationDocumentation"},
   CellID->24102047],
  Cell[27867, 908, 351, 10, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->182634440],
  Cell[28243, 922, 818, 26, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->111474825],
  Cell[29064, 950, 889, 25, 71, "Output",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->336642267],
  Cell[29968, 978, 691, 21, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->7622121],
  Cell[30696, 1004, 145, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->197209834],
  Cell[30844, 1008, 1517, 48, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.6", 
     "Changing precedences and the option SyntaxForm", 
     "Notation:Documentation:SyntaxForm", "NotationDocumentation"},
   CellID->4576917],
  Cell[32364, 1058, 206, 5, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->190975443],
  Cell[32595, 1067, 251, 7, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->179671412],
  Cell[32849, 1076, 438, 14, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->674471613],
  Cell[33302, 1093, 513, 15, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->120804539],
  Cell[33818, 1110, 488, 15, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->315630718],
  Cell[34309, 1127, 158, 2, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->17091424],
  Cell[34492, 1133, 333, 10, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->901340367],
  Cell[34828, 1145, 437, 14, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->19061706],
  Cell[35280, 1162, 207, 5, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->202363133],
  Cell[38109, 1250, 231, 5, 70, "Caption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->187808373],
  Cell[38343, 1257, 949, 26, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->230427148],
  Cell[40578, 1330, 310, 9, 70, "Caption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->105776152]},
 "Notation:S4.1"->{
  Cell[1310, 46, 194, 3, 70, "Subsection",
   CellGroupingRules->"NormalGrouping",
   CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"},
   CellID->65452685],
  Cell[1507, 51, 715, 20, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.1", 
     "Notation:Documentation:Advanced Features", "NotationDocumentation"},
   CellID->286358008]},
 "Notation:S4"->{
  Cell[1310, 46, 194, 3, 70, "Subsection",
   CellGroupingRules->"NormalGrouping",
   CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"},
   CellID->65452685],
  Cell[1507, 51, 715, 20, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.1", 
     "Notation:Documentation:Advanced Features", "NotationDocumentation"},
   CellID->286358008],
  Cell[3445, 109, 101, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->108680983],
  Cell[3549, 113, 1038, 34, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
     "NotationDocumentation"},
   CellID->783014032],
  Cell[4590, 149, 178, 6, 70, "Input",
   Evaluatable->False,
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->76814026],
  Cell[4771, 157, 891, 25, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->181028596],
  Cell[5665, 184, 337, 9, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->36480980],
  Cell[6096, 201, 1666, 52, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->713884108],
  Cell[7765, 255, 347, 11, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->291811214],
  Cell[8137, 270, 182, 6, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->204380449],
  Cell[8322, 278, 280, 8, 39, "Output",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->4001723],
  Cell[8617, 289, 528, 15, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->114489376],
  Cell[9148, 306, 574, 19, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->467928923],
  Cell[9725, 327, 354, 10, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->929594838],
  Cell[10082, 339, 387, 12, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->44818625],
  Cell[10494, 355, 191, 6, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->374056543],
  Cell[10688, 363, 308, 8, 36, "Output",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->26160784],
  Cell[11011, 374, 1765, 52, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->568491970],
  Cell[12813, 431, 118, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->10645498],
  Cell[12934, 435, 1776, 52, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag", 
     "NotationDocumentation"},
   CellID->281647541],
  Cell[14713, 489, 215, 6, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->533679860],
  Cell[14953, 499, 234, 7, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->725022287],
  Cell[15190, 508, 458, 14, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->432189313],
  Cell[15663, 525, 355, 10, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->318437420],
  Cell[16021, 537, 330, 8, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->209928122],
  Cell[16376, 549, 194, 5, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->95803853],
  Cell[16573, 556, 347, 10, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->54553883],
  Cell[16969, 572, 139, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->259282198],
  Cell[17111, 576, 1996, 49, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag", 
     "NotationDocumentation"},
   CellID->202592711],
  Cell[19110, 627, 324, 9, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->234084821],
  Cell[19437, 638, 694, 21, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->116509125],
  Cell[20134, 661, 435, 8, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->469720415],
  Cell[20572, 671, 321, 9, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->94731963],
  Cell[20896, 682, 371, 9, 70, "Input",
   CellTags->{
    "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
     "NotationDocumentation"},
   CellID->107773098],
  Cell[21270, 693, 205, 5, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->21149054],
  Cell[21500, 702, 275, 7, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->640830027],
  Cell[21778, 711, 319, 9, 36, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->1126005],
  Cell[22112, 723, 215, 5, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->526824018],
  Cell[22352, 732, 273, 8, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->23996110],
  Cell[22628, 742, 384, 11, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->565508835],
  Cell[23027, 756, 385, 10, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->448520244],
  Cell[23415, 768, 485, 14, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->401455642],
  Cell[23925, 786, 692, 21, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->925213327],
  Cell[24620, 809, 693, 19, 54, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->137094281],
  Cell[25316, 830, 694, 20, 54, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->216150258],
  Cell[26025, 853, 663, 20, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->105823291],
  Cell[26725, 878, 119, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->12894544],
  Cell[26847, 882, 1017, 24, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.5", 
     "Notation:Definition:NotationMadeBoxesTag", "NotationDocumentation"},
   CellID->24102047],
  Cell[27867, 908, 351, 10, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->182634440],
  Cell[28243, 922, 818, 26, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->111474825],
  Cell[29064, 950, 889, 25, 71, "Output",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->336642267],
  Cell[29968, 978, 691, 21, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->7622121],
  Cell[30696, 1004, 145, 2, 70, "Section",
   CellTags->{"Notation:S4", "NotationDocumentation"},
   CellID->197209834],
  Cell[30844, 1008, 1517, 48, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.6", 
     "Changing precedences and the option SyntaxForm", 
     "Notation:Documentation:SyntaxForm", "NotationDocumentation"},
   CellID->4576917],
  Cell[32364, 1058, 206, 5, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->190975443],
  Cell[32595, 1067, 251, 7, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->179671412],
  Cell[32849, 1076, 438, 14, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->674471613],
  Cell[33302, 1093, 513, 15, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->120804539],
  Cell[33818, 1110, 488, 15, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->315630718],
  Cell[34309, 1127, 158, 2, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->17091424],
  Cell[34492, 1133, 333, 10, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->901340367],
  Cell[34828, 1145, 437, 14, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->19061706],
  Cell[35280, 1162, 207, 5, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->202363133],
  Cell[38109, 1250, 231, 5, 70, "Caption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->187808373],
  Cell[38343, 1257, 949, 26, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->230427148],
  Cell[40578, 1330, 310, 9, 70, "Caption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->105776152]},
 "Notation:Documentation:Advanced Features"->{
  Cell[1507, 51, 715, 20, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.1", 
     "Notation:Documentation:Advanced Features", "NotationDocumentation"},
   CellID->286358008]},
 "Notation:S4.2"->{
  Cell[3549, 113, 1038, 34, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
     "NotationDocumentation"},
   CellID->783014032],
  Cell[4590, 149, 178, 6, 70, "Input",
   Evaluatable->False,
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->76814026],
  Cell[4771, 157, 891, 25, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->181028596],
  Cell[5665, 184, 337, 9, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->36480980],
  Cell[6096, 201, 1666, 52, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->713884108],
  Cell[7765, 255, 347, 11, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->291811214],
  Cell[8137, 270, 182, 6, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->204380449],
  Cell[8322, 278, 280, 8, 39, "Output",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->4001723],
  Cell[8617, 289, 528, 15, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->114489376],
  Cell[9148, 306, 574, 19, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->467928923],
  Cell[9725, 327, 354, 10, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->929594838],
  Cell[10082, 339, 387, 12, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->44818625],
  Cell[10494, 355, 191, 6, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->374056543],
  Cell[10688, 363, 308, 8, 36, "Output",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->26160784],
  Cell[11011, 374, 1765, 52, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
   CellID->568491970]},
 "Notation:Documentation:TagBoxes"->{
  Cell[3549, 113, 1038, 34, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
     "NotationDocumentation"},
   CellID->783014032]},
 "Notation:S4.3"->{
  Cell[12934, 435, 1776, 52, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag", 
     "NotationDocumentation"},
   CellID->281647541],
  Cell[14713, 489, 215, 6, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->533679860],
  Cell[14953, 499, 234, 7, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->725022287],
  Cell[15190, 508, 458, 14, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->432189313],
  Cell[15663, 525, 355, 10, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->318437420],
  Cell[16021, 537, 330, 8, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->209928122],
  Cell[16376, 549, 194, 5, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->95803853],
  Cell[16573, 556, 347, 10, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
   CellID->54553883]},
 "Notation:Documentation:NotationBoxTag"->{
  Cell[12934, 435, 1776, 52, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag", 
     "NotationDocumentation"},
   CellID->281647541]},
 "Notation:S4.4"->{
  Cell[17111, 576, 1996, 49, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag", 
     "NotationDocumentation"},
   CellID->202592711],
  Cell[19110, 627, 324, 9, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->234084821],
  Cell[19437, 638, 694, 21, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->116509125],
  Cell[20134, 661, 435, 8, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->469720415],
  Cell[20572, 671, 321, 9, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->94731963],
  Cell[20896, 682, 371, 9, 70, "Input",
   CellTags->{
    "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
     "NotationDocumentation"},
   CellID->107773098],
  Cell[21270, 693, 205, 5, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->21149054],
  Cell[21500, 702, 275, 7, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->640830027],
  Cell[21778, 711, 319, 9, 36, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->1126005],
  Cell[22112, 723, 215, 5, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->526824018],
  Cell[22352, 732, 273, 8, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->23996110],
  Cell[22628, 742, 384, 11, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->565508835],
  Cell[23027, 756, 385, 10, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->448520244],
  Cell[23415, 768, 485, 14, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->401455642],
  Cell[23925, 786, 692, 21, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->925213327],
  Cell[24620, 809, 693, 19, 54, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->137094281],
  Cell[25316, 830, 694, 20, 54, "Output",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->216150258],
  Cell[26025, 853, 663, 20, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
   CellID->105823291]},
 "Notation:Definition:NotationPatternTag"->{
  Cell[17111, 576, 1996, 49, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag", 
     "NotationDocumentation"},
   CellID->202592711]},
 "Complex Patterns:testing function"->{
  Cell[20896, 682, 371, 9, 70, "Input",
   CellTags->{
    "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
     "NotationDocumentation"},
   CellID->107773098]},
 "Notation:S4.5"->{
  Cell[26847, 882, 1017, 24, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.5", 
     "Notation:Definition:NotationMadeBoxesTag", "NotationDocumentation"},
   CellID->24102047],
  Cell[27867, 908, 351, 10, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->182634440],
  Cell[28243, 922, 818, 26, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->111474825],
  Cell[29064, 950, 889, 25, 71, "Output",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->336642267],
  Cell[29968, 978, 691, 21, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
   CellID->7622121]},
 "Notation:Definition:NotationMadeBoxesTag"->{
  Cell[26847, 882, 1017, 24, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.5", 
     "Notation:Definition:NotationMadeBoxesTag", "NotationDocumentation"},
   CellID->24102047]},
 "Notation:S4.6"->{
  Cell[30844, 1008, 1517, 48, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.6", 
     "Changing precedences and the option SyntaxForm", 
     "Notation:Documentation:SyntaxForm", "NotationDocumentation"},
   CellID->4576917],
  Cell[32364, 1058, 206, 5, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->190975443],
  Cell[32595, 1067, 251, 7, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->179671412],
  Cell[32849, 1076, 438, 14, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->674471613],
  Cell[33302, 1093, 513, 15, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->120804539],
  Cell[33818, 1110, 488, 15, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->315630718],
  Cell[34309, 1127, 158, 2, 70, "MathCaption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->17091424],
  Cell[34492, 1133, 333, 10, 70, "Input",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->901340367],
  Cell[34828, 1145, 437, 14, 50, "Output",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->19061706],
  Cell[35280, 1162, 207, 5, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->202363133],
  Cell[38109, 1250, 231, 5, 70, "Caption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->187808373],
  Cell[38343, 1257, 949, 26, 70, "Text",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->230427148],
  Cell[40578, 1330, 310, 9, 70, "Caption",
   CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
   CellID->105776152]},
 "Changing precedences and the option SyntaxForm"->{
  Cell[30844, 1008, 1517, 48, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.6", 
     "Changing precedences and the option SyntaxForm", 
     "Notation:Documentation:SyntaxForm", "NotationDocumentation"},
   CellID->4576917]},
 "Notation:Documentation:SyntaxForm"->{
  Cell[30844, 1008, 1517, 48, 70, "Text",
   CellTags->{
    "Notation:S4", "Notation:S4.6", 
     "Changing precedences and the option SyntaxForm", 
     "Notation:Documentation:SyntaxForm", "NotationDocumentation"},
   CellID->4576917]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"NotationDocumentation", 43262, 1391},
 {"Notation:S4.1", 52904, 1613},
 {"Notation:S4", 53288, 1623},
 {"Notation:Documentation:Advanced Features", 62758, 1839},
 {"Notation:S4.2", 62967, 1845},
 {"Notation:Documentation:TagBoxes", 65116, 1894},
 {"Notation:S4.3", 65318, 1900},
 {"Notation:Documentation:NotationBoxTag", 66511, 1927},
 {"Notation:S4.4", 66720, 1933},
 {"Notation:Definition:NotationPatternTag", 69332, 1992},
 {"Complex Patterns:testing function", 69562, 1998},
 {"Notation:S4.5", 69766, 2004},
 {"Notation:Definition:NotationMadeBoxesTag", 70552, 2022},
 {"Notation:S4.6", 70763, 2028},
 {"Changing precedences and the option SyntaxForm", 72714, 2071},
 {"Notation:Documentation:SyntaxForm", 72994, 2078}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 571, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1196, 42, 111, 2, 70, "Title",
 CellTags->"NotationDocumentation",
 CellID->683412692],
Cell[1310, 46, 194, 3, 70, "Subsection",
 CellGroupingRules->"NormalGrouping",
 CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"},
 CellID->65452685],
Cell[1507, 51, 715, 20, 70, "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.1", "Notation:Documentation:Advanced Features", 
   "NotationDocumentation"},
 CellID->286358008],
Cell[2225, 73, 1195, 32, 70, "Text",
 CellTags->"NotationDocumentation",
 CellID->304634832],
Cell[CellGroupData[{
Cell[3445, 109, 101, 2, 70, "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->108680983],
Cell[3549, 113, 1038, 34, 70, "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
   "NotationDocumentation"},
 CellID->783014032],
Cell[4590, 149, 178, 6, 70, "Input",
 Evaluatable->False,
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->76814026],
Cell[4771, 157, 891, 25, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->181028596],
Cell[5665, 184, 337, 9, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->36480980],
Cell[6005, 195, 88, 4, 70, "Input",
 CellID->167577091],
Cell[6096, 201, 1666, 52, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->713884108],
Cell[7765, 255, 347, 11, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->291811214],
Cell[CellGroupData[{
Cell[8137, 270, 182, 6, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->204380449],
Cell[8322, 278, 280, 8, 39, "Output",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->4001723]
}, Open  ]],
Cell[8617, 289, 528, 15, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->114489376],
Cell[9148, 306, 574, 19, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->467928923],
Cell[9725, 327, 354, 10, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->929594838],
Cell[10082, 339, 387, 12, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->44818625],
Cell[CellGroupData[{
Cell[10494, 355, 191, 6, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->374056543],
Cell[10688, 363, 308, 8, 36, "Output",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->26160784]
}, Open  ]],
Cell[11011, 374, 1765, 52, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"},
 CellID->568491970]
}, Open  ]],
Cell[CellGroupData[{
Cell[12813, 431, 118, 2, 70, "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->10645498],
Cell[12934, 435, 1776, 52, 70, "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag", 
   "NotationDocumentation"},
 CellID->281647541],
Cell[14713, 489, 215, 6, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellID->533679860],
Cell[CellGroupData[{
Cell[14953, 499, 234, 7, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellID->725022287],
Cell[15190, 508, 458, 14, 50, "Output",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellID->432189313]
}, Open  ]],
Cell[15663, 525, 355, 10, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellID->318437420],
Cell[16021, 537, 330, 8, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellID->209928122],
Cell[CellGroupData[{
Cell[16376, 549, 194, 5, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellID->95803853],
Cell[16573, 556, 347, 10, 50, "Output",
 CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"},
 CellID->54553883]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16969, 572, 139, 2, 70, "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->259282198],
Cell[17111, 576, 1996, 49, 70, "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag", 
   "NotationDocumentation"},
 CellID->202592711],
Cell[19110, 627, 324, 9, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->234084821],
Cell[19437, 638, 694, 21, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->116509125],
Cell[20134, 661, 435, 8, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->469720415],
Cell[20572, 671, 321, 9, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->94731963],
Cell[20896, 682, 371, 9, 70, "Input",
 CellTags->{
  "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
   "NotationDocumentation"},
 CellID->107773098],
Cell[21270, 693, 205, 5, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->21149054],
Cell[CellGroupData[{
Cell[21500, 702, 275, 7, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->640830027],
Cell[21778, 711, 319, 9, 36, "Output",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->1126005]
}, Open  ]],
Cell[22112, 723, 215, 5, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->526824018],
Cell[CellGroupData[{
Cell[22352, 732, 273, 8, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->23996110],
Cell[22628, 742, 384, 11, 50, "Output",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->565508835]
}, Open  ]],
Cell[23027, 756, 385, 10, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->448520244],
Cell[23415, 768, 485, 14, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->401455642],
Cell[CellGroupData[{
Cell[23925, 786, 692, 21, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->925213327],
Cell[24620, 809, 693, 19, 54, "Output",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->137094281],
Cell[25316, 830, 694, 20, 54, "Output",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->216150258]
}, Open  ]],
Cell[26025, 853, 663, 20, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"},
 CellID->105823291]
}, Open  ]],
Cell[CellGroupData[{
Cell[26725, 878, 119, 2, 70, "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->12894544],
Cell[26847, 882, 1017, 24, 70, "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.5", "Notation:Definition:NotationMadeBoxesTag", 
   "NotationDocumentation"},
 CellID->24102047],
Cell[27867, 908, 351, 10, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
 CellID->182634440],
Cell[CellGroupData[{
Cell[28243, 922, 818, 26, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
 CellID->111474825],
Cell[29064, 950, 889, 25, 71, "Output",
 CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
 CellID->336642267]
}, Open  ]],
Cell[29968, 978, 691, 21, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"},
 CellID->7622121]
}, Open  ]],
Cell[CellGroupData[{
Cell[30696, 1004, 145, 2, 70, "Section",
 CellTags->{"Notation:S4", "NotationDocumentation"},
 CellID->197209834],
Cell[30844, 1008, 1517, 48, 70, "Text",
 CellTags->{
  "Notation:S4", "Notation:S4.6", 
   "Changing precedences and the option SyntaxForm", 
   "Notation:Documentation:SyntaxForm", "NotationDocumentation"},
 CellID->4576917],
Cell[32364, 1058, 206, 5, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->190975443],
Cell[CellGroupData[{
Cell[32595, 1067, 251, 7, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->179671412],
Cell[32849, 1076, 438, 14, 50, "Output",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->674471613]
}, Open  ]],
Cell[33302, 1093, 513, 15, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->120804539],
Cell[33818, 1110, 488, 15, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->315630718],
Cell[34309, 1127, 158, 2, 70, "MathCaption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->17091424],
Cell[CellGroupData[{
Cell[34492, 1133, 333, 10, 70, "Input",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->901340367],
Cell[34828, 1145, 437, 14, 50, "Output",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->19061706]
}, Open  ]],
Cell[35280, 1162, 207, 5, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->202363133],
Cell[35490, 1169, 2616, 79, 70, "DefinitionBox3Col",
 CellID->3686592],
Cell[38109, 1250, 231, 5, 70, "Caption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->187808373],
Cell[38343, 1257, 949, 26, 70, "Text",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->230427148],
Cell[39295, 1285, 1280, 43, 70, "DefinitionBox",
 CellID->145821],
Cell[40578, 1330, 310, 9, 70, "Caption",
 CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"},
 CellID->105776152]
}, Open  ]]
}, Open  ]],
Cell[40915, 1343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

