(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55826,       1645]
NotebookOptionsPosition[     29840,       1032]
NotebookOutlinePosition[     49486,       1481]
CellTagsIndexPosition[     49188,       1470]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NOTATION PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ClearNotations" :> 
         Documentation`HelpLookup["paclet:Notation/ref/ClearNotations"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"ClearNotations\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Options and Auxiliary Functions", "Title",
 CellTags->"NotationDocumentation",
 CellID->673075098],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 " , ",
 Cell[BoxData[
  ButtonBox["Symbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " have several options that modify their behavior. These notation functions \
all take the options ",
 Cell[BoxData[
  ButtonBox["WorkingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/WorkingForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Action",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Action"]], "InlineFormula"],
 ". In addition the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package has a local option ",
 Cell[BoxData[
  ButtonBox["AutoLoadNotationPalette",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/AutoLoadNotationPalette"]], 
  "InlineFormula"],
 " which affects the loading of the palette. Finally, the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package has a function which clears all notations, symbolizations, and \
infix notations defined so far."
}], "Text",
 CellTags->{
  "Notation:Documentation:Options", "Notation:S3", "NotationDocumentation"},
 CellID->72647214],

Cell[CellGroupData[{

Cell["The option Action", "Section",
 CellTags->{"Notation:S3", "NotationDocumentation"},
 CellID->190204628],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell[
    "possible values", "TableHeader"], Cell["effect", "TableHeader"]},
   {
    ButtonBox["Action",
     BaseStyle->"Link",
     ButtonData->"paclet:Notation/ref/Action"], 
    ButtonBox["CreateNotationRules",
     BaseStyle->"Link",
     ButtonData->"paclet:Notation/ref/CreateNotationRules"], Cell[
    "notations are entered into the system", "TableText"]},
   {"", 
    ButtonBox["RemoveNotationRules",
     BaseStyle->"Link",
     ButtonData->"paclet:Notation/ref/RemoveNotationRules"], Cell[
    "notations are removed from the system", "TableText"]},
   {"", 
    ButtonBox["PrintNotationRules",
     BaseStyle->"Link",
     ButtonData->"paclet:Notation/ref/PrintNotationRules"], Cell["\<\
cells containing the rules defining the given notation are pasted into the \
current notebook\
\>", "TableText"]}
  }]], "DefinitionBox3Col", "TableHeaderLine",
 CellID->750075914],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Action",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Action"]], "InlineFormula"],
 " option and",
 " ",
 "its possible values."
}], "Caption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->552242601],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Symbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " option ",
 Cell[BoxData[
  ButtonBox["Action",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Action"]], "InlineFormula"],
 " determines what a notation statement does with the rules it generates. The \
default value of the ",
 Cell[BoxData[
  ButtonBox["Action",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Action"]], "InlineFormula"],
 " option is ",
 Cell[BoxData[
  ButtonBox["CreateNotationRules",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/CreateNotationRules"]], "InlineFormula"],
 ", which causes the generated notation rules to be entered into the system."
}], "Text",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->313842301],

Cell["\<\
This creates a notation for pure functions more in keeping with that of \
traditional mathematics.\
\>", "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->624733724],

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   RowBox[{
    TagBox[
     RowBox[{" ", 
      SubscriptBox[
       RowBox[{"(", 
        RowBox[{"x_", " ", 
         StyleBox["\[RightTeeArrow]",
          SpanMinSize->1], " ", "body_"}], ")"}], "&"], " "}],
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TagBox[
     RowBox[{"Function", "[", 
      RowBox[{"x_", ",", "body_"}], "]"}],
     "NotationTemplateTag"]}], " ", ",", "\n", "\t    ", 
   RowBox[{"Action", " ", "\[Rule]", " ", "CreateNotationRules"}]}], 
  "]"}]], "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellLabel->"In[43]:=",
 CellID->232596097],

Cell["Pure functions now use this new notation.", "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->137930412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", "1"}]}], "]"}]], "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellLabel->"In[44]:=",
 CellID->24925702],

Cell[BoxData[
 RowBox[{" ", 
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"x", " ", 
     StyleBox["\[RightTeeArrow]",
      SpanMinSize->1], " ", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "1"}]}], ")"}], "&"], " "}]], "Output",
 ImageSize->{96, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellLabel->"Out[44]=",
 CellID->3615659]
}, Open  ]],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  ButtonBox["Action",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Action"]], "InlineFormula"],
 " option is set to ",
 Cell[BoxData[
  ButtonBox["RemoveNotationRules",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/RemoveNotationRules"]], "InlineFormula"],
 ", then the notation rules are removed from the system. Using the option \
value ",
 Cell[BoxData[
  ButtonBox["RemoveNotationRules",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/RemoveNotationRules"]], "InlineFormula"],
 " in a notation statement is equivalent to using the appropriate ",
 Cell[BoxData[
  ButtonBox["RemoveNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/RemoveNotation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RemoveSymbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/RemoveSymbolize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RemoveInfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/RemoveInfixNotation"]], "InlineFormula"],
 " statement."
}], "Text",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->545006733],

Cell["This removes the above notation from the system.", "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->418418200],

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   RowBox[{
    TagBox[
     RowBox[{" ", 
      SubscriptBox[
       RowBox[{"(", 
        RowBox[{"x_", " ", 
         StyleBox["\[RightTeeArrow]",
          SpanMinSize->1], " ", "body_"}], ")"}], "&"], " "}],
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TagBox[
     RowBox[{"Function", "[", 
      RowBox[{"x_", ",", "body_"}], "]"}],
     "NotationTemplateTag"]}], " ", ",", "\n", "\t    ", 
   RowBox[{"Action", " ", "\[Rule]", " ", "RemoveNotationRules"}]}], 
  "]"}]], "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellLabel->"In[45]:=",
 CellID->340723354],

Cell["Now the special notation for functions is no longer defined.", \
"MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->19938032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", "1"}]}], "]"}]], "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellLabel->"In[46]:=",
 CellID->203555513],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", "1"}]}], "]"}]], "Output",
 ImageSize->{125, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellLabel->"Out[46]=",
 CellID->671412985]
}, Open  ]],

Cell[TextData[{
 "By setting the option ",
 Cell[BoxData[
  ButtonBox["Action",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Action"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["PrintNotationRules",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/PrintNotationRules"]], "InlineFormula"],
 ", you can view the rules generated by a notation statement. Examining the \
",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " rules is often useful to give you an idea of the underlying box structures \
that are used in your notation statement."
}], "Text",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->14351040],

Cell[TextData[{
 "This prints the ",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " rules corresponding to the given ",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->689251812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   RowBox[{
    TagBox[
     RowBox[{" ", 
      SubscriptBox[
       RowBox[{"(", 
        RowBox[{"x_", " ", 
         StyleBox["\[RightTeeArrow]",
          SpanMinSize->1], " ", "body_"}], ")"}], "&"], " "}],
     "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
    TagBox[
     RowBox[{"Function", "[", 
      RowBox[{"x_", ",", "body_"}], "]"}],
     "NotationTemplateTag"]}], " ", ",", "\n", "\t    ", 
   RowBox[{"Action", " ", "\[Rule]", " ", "PrintNotationRules"}]}], 
  "]"}]], "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellLabel->"In[47]:=",
 CellID->141373250],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotationMakeExpression", "[", 
   RowBox[{
    RowBox[{"SubscriptBox", "[", 
     RowBox[{
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<(\>\"", ",", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"x_", ",", "\"\<\[RightTeeArrow]\>\"", ",", "body_"}], 
           "}"}], "]"}], ",", "\"\<)\>\""}], "}"}], "]"}], ",", "\"\<&\>\""}],
      "]"}], ",", "StandardForm"}], "]"}], ":=", 
  RowBox[{"MakeExpression", "[", 
   RowBox[{
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<Function\>\"", ",", "\"\<[\>\"", ",", 
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "\"\<,\>\"", ",", "body"}], "}"}], "]"}], ",", 
       "\"\<]\>\""}], "}"}], "]"}], ",", "StandardForm"}], "]"}]}]], "Output",\

 ShowStringCharacters->True,
 ImageSize->{583, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->60384521],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotationMakeBoxes", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{"x_", ",", "body_"}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
  
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\< \>\"", ",", 
     RowBox[{"SubscriptBox", "[", 
      RowBox[{
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<(\>\"", ",", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Parenthesize", "[", 
              RowBox[{"x", ",", "StandardForm", ",", "RightTeeArrow"}], "]"}],
              ",", "\"\< \>\"", ",", 
             RowBox[{"StyleBox", "[", 
              RowBox[{"\"\<\[RightTeeArrow]\>\"", ",", 
               RowBox[{"SpanMinSize", "\[Rule]", "1.`"}]}], "]"}], ",", 
             "\"\< \>\"", ",", 
             RowBox[{"Parenthesize", "[", 
              RowBox[{"body", ",", "StandardForm", ",", "RightTeeArrow"}], 
              "]"}]}], "}"}], "]"}], ",", "\"\<)\>\""}], "}"}], "]"}], ",", 
       "\"\<&\>\""}], "]"}], ",", "\"\< \>\""}], "}"}], "]"}]}]], "Output",
 ShowStringCharacters->True,
 ImageSize->{535, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->255074768]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The option WorkingForm", "Section",
 CellTags->{"Notation:S3", "NotationDocumentation"},
 CellID->12442871],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell[
    "possible values", "TableHeader"], Cell["effect", "TableHeader"]},
   {
    ButtonBox["WorkingForm",
     BaseStyle->"Link",
     ButtonData->"paclet:Notation/ref/WorkingForm"], 
    ButtonBox["StandardForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StandardForm"], Cell[TextData[{
     "notations",
     ",",
     " ",
     "symbolizations",
     " ",
     "and",
     " ",
     "infix",
     " ",
     "notations",
     " ",
     "are",
     " ",
     "defined",
     " ",
     "in",
     " ",
     ButtonBox["StandardForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardForm"]
    }], "TableText"]},
   {"", 
    ButtonBox["TraditionalForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraditionalForm"], Cell[TextData[{
     "notations",
     ",",
     " ",
     "symbolizations",
     " ",
     "and",
     " ",
     "infix",
     " ",
     "notations",
     " ",
     "are",
     " ",
     "defined",
     " ",
     "in",
     " ",
     ButtonBox["TraditionalForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraditionalForm"]
    }], "TableText"]},
   {"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "notations, symbolizations and infix notations are defined in the ",
     StyleBox["DefaultOutputFormatType", "InlineCode"]
    }], "TableText"]}
  }]], "DefinitionBox3Col", "TableHeaderLine",
 CellID->23919567],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["WorkingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/WorkingForm"]], "InlineFormula"],
 " option and some of",
 " ",
 "its possible values."
}], "Caption",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->49441749],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["WorkingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/WorkingForm"]], "InlineFormula"],
 " specifies the ",
 StyleBox["form",
  FontSlant->"Italic"],
 " or ",
 StyleBox["environment",
  FontSlant->"Italic"],
 " the ",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Symbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " statement is generated in. The typical values of ",
 Cell[BoxData[
  ButtonBox["WorkingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/WorkingForm"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 "; any notations created would only apply in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " (respectively). However, ",
 Cell[BoxData[
  ButtonBox["WorkingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/WorkingForm"]], "InlineFormula"],
 " can be set to any form you define, for instance ",
 StyleBox["LogicForm", "MR"],
 ", ",
 StyleBox["PhysicsForm", "MR"],
 " etc."
}], "Text",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->187612230],

Cell[TextData[{
 "When the option ",
 Cell[BoxData[
  ButtonBox["WorkingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/WorkingForm"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Symbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " statement will be created in the ",
 Cell[BoxData["DefaultOutputFormatType"], "InlineFormula"],
 ". This form is show in the menu item ",
 StyleBox["Default Output Format Type",
  FontFamily->"Helvetica"],
 " under the menu ",
 StyleBox["Cell",
  FontFamily->"Helvetica"],
 "."
}], "Text",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->962640983],

Cell[TextData[{
 "This creates ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " notations for the vector calculus functions ",
 StyleBox["Div", "MR"],
 ", ",
 StyleBox["Curl", "MR"],
 " and the wrapper ",
 StyleBox["Vector", "MR"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->615374186],

Cell[BoxData[{
 FormBox[
  RowBox[{"Notation", "[", " ", 
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{"\[Del]", 
       RowBox[{".", "a_"}]}],
      "NotationTemplateTag"], "  ", "\[DoubleLongLeftRightArrow]", "  ", 
     TagBox[
      RowBox[{"Div", "[", "a_", "]"}],
      "NotationTemplateTag"]}], " ", ",", 
    RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], "]"}], 
  TraditionalForm], "\n", 
 FormBox[
  FormBox[
   RowBox[{"Notation", "[", " ", 
    RowBox[{
     RowBox[{
      TagBox[
       RowBox[{"\[Del]", 
        RowBox[{"\[Cross]", " ", "a__"}]}],
       "NotationTemplateTag"], "  ", "\[DoubleLongLeftRightArrow]", "  ", 
      TagBox[
       RowBox[{"Curl", "[", "a__", "]"}],
       "NotationTemplateTag"]}], " ", ",", 
     RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], "]"}],
   
   TraditionalForm], TraditionalForm], "\n", 
 FormBox[
  RowBox[{"Notation", "[", "  ", 
   RowBox[{
    RowBox[{
     TagBox[
      OverscriptBox["a_", "\[RightVector]"],
      "NotationTemplateTag"], "  ", "\[DoubleLongLeftRightArrow]", "  ", 
     TagBox[
      RowBox[{"Vector", "[", "a_", "]"}],
      "NotationTemplateTag"]}], " ", ",", 
    RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], "]"}], 
  TraditionalForm]}], "Input",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellLabel->"In[48]:=",
 CellID->56745206],

Cell["These notations behave as expected.", "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->113681934],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[Del]", 
    RowBox[{"\[Cross]", " ", 
     OverscriptBox["a", "\[RightVector]"]}]}], " ", "//", "TraditionalForm"}],
   TraditionalForm]], "Input",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellLabel->"In[51]:=",
 CellID->82612776],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Del]", 
   RowBox[{"\[Cross]", " ", 
    OverscriptBox["a", "\[RightVector]"]}]}], TraditionalForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellLabel->"Out[51]//TraditionalForm=",
 CellID->177452774]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", " ", "@", " ", "%"}]], "Input",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellLabel->"In[52]:=",
 CellID->129187778],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Curl", "[", 
    RowBox[{"Vector", "[", "a", "]"}], "]"}],
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellLabel->"Out[52]//FullForm=",
 CellID->300411597]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[Del]", 
    RowBox[{".", 
     RowBox[{"\[Del]", 
      RowBox[{"\[Cross]", " ", 
       OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
       OverscriptBox["b", "\[RightVector]"]}]}]}]}], " ", "+", " ", 
   RowBox[{"\[Del]", 
    RowBox[{".", 
     RowBox[{"(", 
      RowBox[{
       OverscriptBox["a", "\[RightVector]"], "+", 
       OverscriptBox["b", "\[RightVector]"]}], ")"}]}]}]}], 
  TraditionalForm]], "Input",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellLabel->"In[53]:=",
 CellID->506052764],

Cell[BoxData[
 RowBox[{
  RowBox[{"Div", "[", 
   RowBox[{"Curl", "[", 
    RowBox[{
     RowBox[{"Vector", "[", "a", "]"}], "\[Cross]", 
     RowBox[{"Vector", "[", "b", "]"}]}], "]"}], "]"}], "+", 
  RowBox[{"Div", "[", 
   RowBox[{
    RowBox[{"Vector", "[", "a", "]"}], "+", 
    RowBox[{"Vector", "[", "b", "]"}]}], "]"}]}]], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellLabel->"Out[53]=",
 CellID->833798143]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The option AutoLoadNotationPalette", "Section",
 CellTags->{"Notation:S3", "NotationDocumentation"},
 CellID->979137619],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell[
    "possible values", "TableHeader"], Cell["effect", "TableHeader"]},
   {
    ButtonBox["AutoLoadNotationPalette",
     BaseStyle->"Link",
     ButtonData->"paclet:Notation/ref/AutoLoadNotationPalette"], 
    RowBox[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], ",", " ", 
     StyleBox["undefined",
      FontSlant->"Italic"]}], Cell[TextData[{
     "the",
     " ",
     "notation",
     " ",
     "palette",
     " ",
     "will",
     " ",
     "be",
     " ",
     "loaded",
     " ",
     "when",
     " ",
     "the",
     " ",
     StyleBox["Notation",
      FontSlant->"Italic"],
     " ",
     "package",
     " ",
     "loads"
    }], "TableText"]},
   {"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "the",
     " ",
     "notation",
     " ",
     "palette",
     " ",
     "will",
     " ",
     "not",
     " ",
     "be",
     " ",
     "loaded",
     " ",
     "when",
     " ",
     "the",
     " ",
     StyleBox["Notation",
      FontSlant->"Italic"],
     " ",
     "package",
     " ",
     "loads"
    }], "TableText"]}
  }]], "DefinitionBox3Col", "TableHeaderLine",
 CellID->196483904],

Cell["The option AutoLoadNotationPalette and its behavior.", "Caption",
 CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
 CellID->376469780],

Cell[TextData[{
 "If you are designing a package you may want to hide the ",
 ButtonBox["notation palette",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`ToFileName[{$InstallationDirectory, "AddOns", "Packages", 
      "Notation", "LocalPalettes", "English", "NotationPalette.nb"}], None},
  ButtonNote->"Show Palette"],
 " when the user loads the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package so as not to confuse them. You can set the boolean variable ",
 Cell[BoxData[
  ButtonBox["AutoLoadNotationPalette",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/AutoLoadNotationPalette"]], 
  "InlineFormula"],
 " inside your package to achieve this. If ",
 Cell[BoxData[
  ButtonBox["AutoLoadNotationPalette",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/AutoLoadNotationPalette"]], 
  "InlineFormula"],
 " has been set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " then the notation palette will not be loaded when the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package is loaded. If the value is undefined or ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", the notation palette will be loaded when the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package loads. In input form the statement would look like the following."
}], "Text",
 CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
 CellID->177468766],

Cell[TextData[{
 "Statement forcing the notation palette not to load when the ",
 StyleBox["Notation",
  FontSlant->"Italic"],
 " package loads."
}], "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
 CellID->186519730],

Cell[BoxData[
 RowBox[{"Notation`AutoLoadNotationPalette", " ", "=", " ", 
  "False"}]], "Input",
 Evaluatable->False,
 CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
 CellID->264437729]
}, Open  ]],

Cell[CellGroupData[{

Cell["The function ClearNotations", "Section",
 CellTags->{"Notation:S3", "NotationDocumentation"},
 CellID->308175002],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ClearNotations",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/ClearNotations"], "[", "]"}], Cell[
    TextData[{
     ButtonBox["ClearNotations",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/ClearNotations"],
     "[] clears all notations, symbolizations and infix notations"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->174112642],

Cell[TextData[{
 "Syntax of ",
 Cell[BoxData[
  ButtonBox["ClearNotations",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/ClearNotations"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
 CellID->36708659],

Cell[TextData[{
 "If you would like to re-enter a set of notations or would like to make a \
\"clean start\" you can use the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClearNotations",
    BaseStyle->"Link",
    ButtonData->"paclet:Notation/ref/ClearNotations"], "[", "]"}]], 
  "InlineFormula"],
 " command to erase all notations, symbolizations and infix notations present \
in the system. Using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClearNotations",
    BaseStyle->"Link",
    ButtonData->"paclet:Notation/ref/ClearNotations"], "[", "]"}]], 
  "InlineFormula"],
 " should not affect other packages or definitions you have made to ",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
 CellID->310324812],

Cell["Wipe all notations, symbolizations and infix notations.", "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
 CellID->344501025],

Cell[BoxData[
 RowBox[{"ClearNotations", "[", "]"}]], "Input",
 CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
 CellLabel->"In[54]:=",
 CellID->297377237]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Options and Auxiliary Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 4.0617100}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Notation Package Tutorial",
     "language" -> "en", "paclet" -> "Notation Package", "status" -> "None", 
    "summary" -> 
    "Notation , Symbolize and InfixNotation have several options that modify \
their behavior. These notation functions all take the options WorkingForm and \
Action. In addition the Notation package has a local option \
AutoLoadNotationPalette which affects the loading of the palette. Finally, \
the Notation package has a function which clears all notations, \
symbolizations, and infix notations defined so far. The Action option and its \
possible values. The Notation, Symbolize and InfixNotation option Action \
determines what a notation statement does with the rules it generates. The \
default value of the Action option is CreateNotationRules, which causes the \
generated notation rules to be entered into the system.", "synonyms" -> {}, 
    "title" -> "Options and Auxiliary Functions", "type" -> "Tutorial", "uri" -> 
    "Notation/tutorial/OptionsAndAuxiliaryFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "NotationDocumentation"->{
  Cell[1218, 42, 104, 2, 70, "Title",
   CellTags->"NotationDocumentation",
   CellID->673075098],
  Cell[1325, 46, 1400, 43, 70, "Text",
   CellTags->{
    "Notation:Documentation:Options", "Notation:S3", "NotationDocumentation"},
   
   CellID->72647214],
  Cell[2750, 93, 109, 2, 70, "Section",
   CellTags->{"Notation:S3", "NotationDocumentation"},
   CellID->190204628],
  Cell[3811, 123, 299, 11, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->552242601],
  Cell[4113, 136, 1148, 35, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->313842301],
  Cell[5264, 173, 219, 5, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->624733724],
  Cell[5486, 180, 682, 20, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->232596097],
  Cell[6171, 202, 154, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->137930412],
  Cell[6350, 208, 247, 7, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->24925702],
  Cell[6600, 217, 437, 14, 40, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->3615659],
  Cell[7052, 234, 1193, 35, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->545006733],
  Cell[8248, 271, 161, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->418418200],
  Cell[8412, 275, 682, 20, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->340723354],
  Cell[9097, 297, 174, 3, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->19938032],
  Cell[9296, 304, 248, 7, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->203555513],
  Cell[9547, 313, 337, 10, 39, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->671412985],
  Cell[9899, 326, 890, 26, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->14351040],
  Cell[10792, 354, 579, 19, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->689251812],
  Cell[11396, 377, 681, 20, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->141373250],
  Cell[12080, 399, 1038, 29, 71, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->60384521],
  Cell[13121, 430, 1316, 34, 88, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->255074768],
  Cell[14486, 470, 113, 2, 70, "Section",
   CellTags->{"Notation:S3", "NotationDocumentation"},
   CellID->12442871],
  Cell[16118, 540, 316, 11, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->49441749],
  Cell[16437, 553, 1892, 64, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->187612230],
  Cell[18332, 619, 1112, 37, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->962640983],
  Cell[19447, 658, 435, 15, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->615374186],
  Cell[19885, 675, 1417, 43, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->56745206],
  Cell[21305, 720, 148, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->113681934],
  Cell[21478, 726, 309, 9, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->82612776],
  Cell[21790, 737, 366, 10, 50, "Output",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->177452774],
  Cell[22193, 752, 180, 4, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->129187778],
  Cell[22376, 758, 373, 12, 50, "Output",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->300411597],
  Cell[22786, 775, 587, 18, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->506052764],
  Cell[23376, 795, 542, 16, 36, "Output",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->833798143],
  Cell[23967, 817, 126, 2, 70, "Section",
   CellTags->{"Notation:S3", "NotationDocumentation"},
   CellID->979137619],
  Cell[25385, 889, 161, 2, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->376469780],
  Cell[25549, 893, 1531, 42, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->177468766],
  Cell[27083, 937, 254, 7, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->186519730],
  Cell[27340, 946, 208, 5, 70, "Input",
   Evaluatable->False,
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->264437729],
  Cell[27585, 956, 119, 2, 70, "Section",
   CellTags->{"Notation:S3", "NotationDocumentation"},
   CellID->308175002],
  Cell[28146, 975, 279, 9, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->36708659],
  Cell[28428, 986, 1008, 30, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->310324812],
  Cell[29439, 1018, 168, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->344501025],
  Cell[29610, 1022, 176, 4, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->297377237]},
 "Notation:Documentation:Options"->{
  Cell[1325, 46, 1400, 43, 70, "Text",
   CellTags->{
    "Notation:Documentation:Options", "Notation:S3", "NotationDocumentation"},
   
   CellID->72647214]},
 "Notation:S3"->{
  Cell[1325, 46, 1400, 43, 70, "Text",
   CellTags->{
    "Notation:Documentation:Options", "Notation:S3", "NotationDocumentation"},
   
   CellID->72647214],
  Cell[2750, 93, 109, 2, 70, "Section",
   CellTags->{"Notation:S3", "NotationDocumentation"},
   CellID->190204628],
  Cell[3811, 123, 299, 11, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->552242601],
  Cell[4113, 136, 1148, 35, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->313842301],
  Cell[5264, 173, 219, 5, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->624733724],
  Cell[5486, 180, 682, 20, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->232596097],
  Cell[6171, 202, 154, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->137930412],
  Cell[6350, 208, 247, 7, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->24925702],
  Cell[6600, 217, 437, 14, 40, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->3615659],
  Cell[7052, 234, 1193, 35, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->545006733],
  Cell[8248, 271, 161, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->418418200],
  Cell[8412, 275, 682, 20, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->340723354],
  Cell[9097, 297, 174, 3, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->19938032],
  Cell[9296, 304, 248, 7, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->203555513],
  Cell[9547, 313, 337, 10, 39, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->671412985],
  Cell[9899, 326, 890, 26, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->14351040],
  Cell[10792, 354, 579, 19, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->689251812],
  Cell[11396, 377, 681, 20, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->141373250],
  Cell[12080, 399, 1038, 29, 71, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->60384521],
  Cell[13121, 430, 1316, 34, 88, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->255074768],
  Cell[14486, 470, 113, 2, 70, "Section",
   CellTags->{"Notation:S3", "NotationDocumentation"},
   CellID->12442871],
  Cell[16118, 540, 316, 11, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->49441749],
  Cell[16437, 553, 1892, 64, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->187612230],
  Cell[18332, 619, 1112, 37, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->962640983],
  Cell[19447, 658, 435, 15, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->615374186],
  Cell[19885, 675, 1417, 43, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->56745206],
  Cell[21305, 720, 148, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->113681934],
  Cell[21478, 726, 309, 9, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->82612776],
  Cell[21790, 737, 366, 10, 50, "Output",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->177452774],
  Cell[22193, 752, 180, 4, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->129187778],
  Cell[22376, 758, 373, 12, 50, "Output",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->300411597],
  Cell[22786, 775, 587, 18, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->506052764],
  Cell[23376, 795, 542, 16, 36, "Output",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->833798143],
  Cell[23967, 817, 126, 2, 70, "Section",
   CellTags->{"Notation:S3", "NotationDocumentation"},
   CellID->979137619],
  Cell[25385, 889, 161, 2, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->376469780],
  Cell[25549, 893, 1531, 42, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->177468766],
  Cell[27083, 937, 254, 7, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->186519730],
  Cell[27340, 946, 208, 5, 70, "Input",
   Evaluatable->False,
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->264437729],
  Cell[27585, 956, 119, 2, 70, "Section",
   CellTags->{"Notation:S3", "NotationDocumentation"},
   CellID->308175002],
  Cell[28146, 975, 279, 9, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->36708659],
  Cell[28428, 986, 1008, 30, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->310324812],
  Cell[29439, 1018, 168, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->344501025],
  Cell[29610, 1022, 176, 4, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->297377237]},
 "Notation:S3.1"->{
  Cell[3811, 123, 299, 11, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->552242601],
  Cell[4113, 136, 1148, 35, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->313842301],
  Cell[5264, 173, 219, 5, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->624733724],
  Cell[5486, 180, 682, 20, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->232596097],
  Cell[6171, 202, 154, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->137930412],
  Cell[6350, 208, 247, 7, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->24925702],
  Cell[6600, 217, 437, 14, 40, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->3615659],
  Cell[7052, 234, 1193, 35, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->545006733],
  Cell[8248, 271, 161, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->418418200],
  Cell[8412, 275, 682, 20, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->340723354],
  Cell[9097, 297, 174, 3, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->19938032],
  Cell[9296, 304, 248, 7, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->203555513],
  Cell[9547, 313, 337, 10, 39, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->671412985],
  Cell[9899, 326, 890, 26, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->14351040],
  Cell[10792, 354, 579, 19, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->689251812],
  Cell[11396, 377, 681, 20, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->141373250],
  Cell[12080, 399, 1038, 29, 71, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->60384521],
  Cell[13121, 430, 1316, 34, 88, "Output",
   CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
   CellID->255074768]},
 "Notation:S3.2"->{
  Cell[16118, 540, 316, 11, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->49441749],
  Cell[16437, 553, 1892, 64, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->187612230],
  Cell[18332, 619, 1112, 37, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->962640983],
  Cell[19447, 658, 435, 15, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->615374186],
  Cell[19885, 675, 1417, 43, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->56745206],
  Cell[21305, 720, 148, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->113681934],
  Cell[21478, 726, 309, 9, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->82612776],
  Cell[21790, 737, 366, 10, 50, "Output",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->177452774],
  Cell[22193, 752, 180, 4, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->129187778],
  Cell[22376, 758, 373, 12, 50, "Output",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->300411597],
  Cell[22786, 775, 587, 18, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->506052764],
  Cell[23376, 795, 542, 16, 36, "Output",
   CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
   CellID->833798143]},
 "Notation:S3.3"->{
  Cell[25385, 889, 161, 2, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->376469780],
  Cell[25549, 893, 1531, 42, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->177468766],
  Cell[27083, 937, 254, 7, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->186519730],
  Cell[27340, 946, 208, 5, 70, "Input",
   Evaluatable->False,
   CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
   CellID->264437729]},
 "Notation:S3.4"->{
  Cell[28146, 975, 279, 9, 70, "Caption",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->36708659],
  Cell[28428, 986, 1008, 30, 70, "Text",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->310324812],
  Cell[29439, 1018, 168, 2, 70, "MathCaption",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->344501025],
  Cell[29610, 1022, 176, 4, 70, "Input",
   CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
   CellID->297377237]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"NotationDocumentation", 31818, 1073},
 {"Notation:Documentation:Options", 37816, 1209},
 {"Notation:S3", 37994, 1215},
 {"Notation:S3.1", 43876, 1348},
 {"Notation:S3.2", 46356, 1403},
 {"Notation:S3.3", 48021, 1440},
 {"Notation:S3.4", 48614, 1454}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 593, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1218, 42, 104, 2, 70, "Title",
 CellTags->"NotationDocumentation",
 CellID->673075098],
Cell[1325, 46, 1400, 43, 70, "Text",
 CellTags->{
  "Notation:Documentation:Options", "Notation:S3", "NotationDocumentation"},
 CellID->72647214],
Cell[CellGroupData[{
Cell[2750, 93, 109, 2, 70, "Section",
 CellTags->{"Notation:S3", "NotationDocumentation"},
 CellID->190204628],
Cell[2862, 97, 946, 24, 70, "DefinitionBox3Col",
 CellID->750075914],
Cell[3811, 123, 299, 11, 70, "Caption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->552242601],
Cell[4113, 136, 1148, 35, 70, "Text",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->313842301],
Cell[5264, 173, 219, 5, 70, "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->624733724],
Cell[5486, 180, 682, 20, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->232596097],
Cell[6171, 202, 154, 2, 70, "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->137930412],
Cell[CellGroupData[{
Cell[6350, 208, 247, 7, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->24925702],
Cell[6600, 217, 437, 14, 40, "Output",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->3615659]
}, Open  ]],
Cell[7052, 234, 1193, 35, 70, "Text",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->545006733],
Cell[8248, 271, 161, 2, 70, "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->418418200],
Cell[8412, 275, 682, 20, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->340723354],
Cell[9097, 297, 174, 3, 70, "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->19938032],
Cell[CellGroupData[{
Cell[9296, 304, 248, 7, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->203555513],
Cell[9547, 313, 337, 10, 39, "Output",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->671412985]
}, Open  ]],
Cell[9899, 326, 890, 26, 70, "Text",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->14351040],
Cell[10792, 354, 579, 19, 70, "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->689251812],
Cell[CellGroupData[{
Cell[11396, 377, 681, 20, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->141373250],
Cell[12080, 399, 1038, 29, 71, "Output",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->60384521],
Cell[13121, 430, 1316, 34, 88, "Output",
 CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"},
 CellID->255074768]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14486, 470, 113, 2, 70, "Section",
 CellTags->{"Notation:S3", "NotationDocumentation"},
 CellID->12442871],
Cell[14602, 474, 1513, 64, 70, "DefinitionBox3Col",
 CellID->23919567],
Cell[16118, 540, 316, 11, 70, "Caption",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->49441749],
Cell[16437, 553, 1892, 64, 70, "Text",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->187612230],
Cell[18332, 619, 1112, 37, 70, "Text",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->962640983],
Cell[19447, 658, 435, 15, 70, "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->615374186],
Cell[19885, 675, 1417, 43, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->56745206],
Cell[21305, 720, 148, 2, 70, "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->113681934],
Cell[CellGroupData[{
Cell[21478, 726, 309, 9, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->82612776],
Cell[21790, 737, 366, 10, 50, "Output",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->177452774]
}, Open  ]],
Cell[CellGroupData[{
Cell[22193, 752, 180, 4, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->129187778],
Cell[22376, 758, 373, 12, 50, "Output",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->300411597]
}, Open  ]],
Cell[CellGroupData[{
Cell[22786, 775, 587, 18, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->506052764],
Cell[23376, 795, 542, 16, 36, "Output",
 CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"},
 CellID->833798143]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23967, 817, 126, 2, 70, "Section",
 CellTags->{"Notation:S3", "NotationDocumentation"},
 CellID->979137619],
Cell[24096, 821, 1286, 66, 70, "DefinitionBox3Col",
 CellID->196483904],
Cell[25385, 889, 161, 2, 70, "Caption",
 CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
 CellID->376469780],
Cell[25549, 893, 1531, 42, 70, "Text",
 CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
 CellID->177468766],
Cell[27083, 937, 254, 7, 70, "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
 CellID->186519730],
Cell[27340, 946, 208, 5, 70, "Input",
 Evaluatable->False,
 CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"},
 CellID->264437729]
}, Open  ]],
Cell[CellGroupData[{
Cell[27585, 956, 119, 2, 70, "Section",
 CellTags->{"Notation:S3", "NotationDocumentation"},
 CellID->308175002],
Cell[27707, 960, 436, 13, 70, "DefinitionBox",
 CellID->174112642],
Cell[28146, 975, 279, 9, 70, "Caption",
 CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
 CellID->36708659],
Cell[28428, 986, 1008, 30, 70, "Text",
 CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
 CellID->310324812],
Cell[29439, 1018, 168, 2, 70, "MathCaption",
 CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
 CellID->344501025],
Cell[29610, 1022, 176, 4, 70, "Input",
 CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"},
 CellID->297377237]
}, Open  ]]
}, Open  ]],
Cell[29813, 1030, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

