(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6970,        243]
NotebookOptionsPosition[      4517,        171]
NotebookOutlinePosition[      5777,        202]
CellTagsIndexPosition[      5734,        199]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Numerical Calculus Package", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The built\[Hyphen]in functions ",
 Cell[TextData[ButtonBox["D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/D"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Limit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Limit"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Residue",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Residue"]], "InlineFunctionSans"],
 " and ",
 Cell[TextData[ButtonBox["Series",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Series"]], "InlineFunctionSans"],
 " perform computations using symbolic and analytic methods. The functions ",
 Cell[TextData[ButtonBox["ND",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/ND"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NLimit",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/NLimit"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NResidue",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/NResidue"]], 
  "InlineFunctionSans"],
 " and ",
 Cell[TextData[ButtonBox["NSeries",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/NSeries"]], 
  "InlineFunctionSans"],
 ", in this package, are the numerical versions of these functions",
 "."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Limits and Derivatives", "GuideFunctionsSubsection",
 CellID->173109221],

Cell[TextData[{
 Cell[TextData[ButtonBox["NLimit",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/NLimit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical limit of a function"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ND",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/ND"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical derivative of a function at a point"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiterSubsection",
 CellID->195981991]
}, Open  ]],

Cell[CellGroupData[{

Cell["Summations and Series", "GuideFunctionsSubsection",
 CellID->137740830],

Cell[TextData[{
 Cell[TextData[ButtonBox["EulerSum",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/EulerSum"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical sum using Euler's transformation"
}], "GuideText",
 CellID->39625104],

Cell[TextData[{
 Cell[TextData[ButtonBox["NSeries",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/NSeries"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical series expansion of a function"
}], "GuideText",
 CellID->547646493],

Cell["\t", "GuideDelimiter",
 CellID->195090415],

Cell[TextData[{
 Cell[TextData[ButtonBox["NResidue",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalCalculus/ref/NResidue"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical residue of an expression near a specified point"
}], "GuideText",
 CellID->182913984]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "GuideTutorial",
 CellID->846728239]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalEvaluationAndPrecision"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Calculus Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 4.6242244}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Guide", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "The built-in functions D, Limit, Residue and Series perform computations \
using symbolic and analytic methods. The functions ND, NLimit, NResidue and \
NSeries, in this package, are the numerical versions of these functions.", 
    "synonyms" -> {}, "title" -> "Numerical Calculus Package", "type" -> 
    "Guide", "uri" -> "NumericalCalculus/guide/NumericalCalculusPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 68, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[690, 28, 1287, 38, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[2002, 70, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->173109221],
Cell[2083, 73, 267, 8, 70, "GuideText",
 CellID->203374175],
Cell[2353, 83, 276, 8, 70, "GuideText",
 CellID->1463276848],
Cell[2632, 93, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->195981991]
}, Open  ]],
Cell[CellGroupData[{
Cell[2727, 99, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->137740830],
Cell[2807, 102, 286, 9, 70, "GuideText",
 CellID->39625104],
Cell[3096, 113, 283, 9, 70, "GuideText",
 CellID->547646493],
Cell[3382, 124, 48, 1, 70, "GuideDelimiter",
 CellID->195090415],
Cell[3433, 127, 302, 9, 70, "GuideText",
 CellID->182913984]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3784, 142, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[3849, 145, 183, 4, 70, "GuideTutorial",
 CellID->846728239]
}, Open  ]],
Cell[CellGroupData[{
Cell[4069, 154, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4134, 157, 184, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[4321, 163, 154, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[4490, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

