(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6861,        237]
NotebookOptionsPosition[      5061,        180]
NotebookOutlinePosition[      6164,        210]
CellTagsIndexPosition[      6121,        207]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerSum" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/EulerSum"], 
          "Terms" :> Documentation`HelpLookup[
           "paclet:NumericalCalculus/ref/Terms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EulerSum\"\>", 
       2->"\<\"Terms\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExtraTerms", "ObjectName",
 CellID->31210],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ExtraTerms"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["EulerSum",
       BaseStyle->"Link",
       ButtonData->"paclet:NumericalCalculus/ref/EulerSum"]], 
      "InlineFormula"],
     " that specifies the number of terms to be used in the extrapolation \
process."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3495]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are integers greater than 1. The default setting is ",
 Cell[BoxData["7"], "InlineFormula"],
 "."
}], "Notes",
 CellID->26419],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData["ExtraTerms"], "InlineFormula"],
 " gives the number of terms to be used in the extrapolation process after \
the number of terms specified by the option ",
 Cell[BoxData[
  ButtonBox["Terms",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Terms"]], "InlineFormula"],
 " have been explicitly summed."
}], "Notes",
 CellID->14648]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11223],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerSum",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/EulerSum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Terms",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/Terms"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3637]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4189],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->10171]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExtraTerms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 10.7806320}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "ExtraTerms is an option to EulerSum that specifies the number of terms \
to be used in the extrapolation process.", "synonyms" -> {}, "title" -> 
    "ExtraTerms", "type" -> "Symbol", "uri" -> 
    "NumericalCalculus/ref/ExtraTerms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1347, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1970, 62, 48, 1, 70, "ObjectName",
 CellID->31210],
Cell[2021, 65, 562, 17, 70, "Usage",
 CellID->3495]
}, Open  ]],
Cell[CellGroupData[{
Cell[2620, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3098, 104, 159, 5, 70, "Notes",
 CellID->26419],
Cell[3260, 111, 400, 11, 70, "Notes",
 CellID->14648]
}, Closed]],
Cell[CellGroupData[{
Cell[3697, 127, 311, 9, 70, "SeeAlsoSection",
 CellID->11223],
Cell[4011, 138, 480, 17, 70, "SeeAlso",
 CellID->3637]
}, Open  ]],
Cell[CellGroupData[{
Cell[4528, 160, 313, 9, 70, "TutorialsSection",
 CellID->4189],
Cell[4844, 171, 175, 4, 70, "Tutorials",
 CellID->10171]
}, Open  ]],
Cell[5034, 178, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

