(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77343,       2947]
NotebookOptionsPosition[     61834,       2370]
NotebookOutlinePosition[     63194,       2408]
CellTagsIndexPosition[     63108,       2403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NLimit" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NLimit"], 
          "NSeries" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NSeries"], 
          "D" :> Documentation`HelpLookup["paclet:ref/D"], "NResidue" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/ref/NResidue"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NLimit\"\>", 2->"\<\"NSeries\"\>", 
       3->"\<\"D\"\>", 4->"\<\"NResidue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ND", "ObjectName",
 CellID->14331],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ND", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a numerical approximation to the derivative of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " at the point ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ND", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a numerical approximation to the ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox[
        StyleBox["n", "TI"], "th"], TraditionalForm]], "InlineFormula"],
     " derivative of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7970]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " must be numeric when its argument ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is numeric."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->26053],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ND", "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], "0"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"ND", "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", "1"}], "}"}], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], "0"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8768],

Cell[TextData[{
 Cell[BoxData["ND"], "InlineFormula"],
 " is unable to recognize small numbers that should in fact be zero. ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " may be needed to eliminate these spurious residuals."
}], "Notes",
 CellID->28052],

Cell["The following options can be given: ", "Notes",
 CellID->13178],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Method",
     BaseStyle->"FunctionLink",
     ButtonData->"paclet:ref/Method"], "EulerSum", Cell[
    "method to use", "TableText"]},
   {
    ButtonBox["Scale",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalCalculus/ref/Scale"], "1", Cell[
    "size at which variations are expected", "TableText"]},
   {
    ButtonBox["Terms",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalCalculus/ref/Terms"], "7", Cell[
    "number of terms to be used", "TableText"]},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"FunctionLink",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"FunctionLink",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision to use in internal computations", "TableText"]}
  }]], "3ColumnTable",
 CellID->11156],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->24981],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "EulerSum", Cell[
    "use Richardson's extrapolation to the limit", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], Cell[
    "use Cauchy's integral formula", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->12695],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", "EulerSum"}]], "InlineFormula"],
 ", ",
 Cell[BoxData["ND"], "InlineFormula"],
 " needs to evaluate ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " at ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17586],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is not analytic in the neighborhood of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 ", then the default method ",
 Cell[BoxData["EulerSum"], "InlineFormula"],
 " must be used."
}], "Notes",
 CellID->13929],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/Scale"], "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " is used to capture the scale of variation when using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", "EulerSum"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->731],

Cell[TextData[{
 "When the value of the derivative depends on the direction, the default is \
to the right. Other directions can be chosen with the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/Scale"], "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 ", where the direction is ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4278],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Terms",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/Terms"], "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " gives the number of terms to use for extrapolation when using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", "EulerSum"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17859],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"]}]], "InlineFormula"],
 ", the expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " must be analytic in a neighborhood of the point ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8752],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/Scale"], "->", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " specifies the radius of the contour of integration to use with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5089]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->534050516],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->7894293],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->553284329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", "x", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19511],

Cell[BoxData["2.718281828499301`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "3"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28819],

Cell[BoxData[
 RowBox[{"-", "3.000002612074262`"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26107]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22599],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->131317981],

Cell["The expression and evaluation point may be complex:", "ExampleText",
 CellID->788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "x", ",", 
   RowBox[{"\[Pi]", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13261],

Cell[BoxData[
 RowBox[{"11.591953275551333`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.323365937623129`*^-10", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29045]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"I", " ", "x"}], "]"}], ",", "x", ",", 
   RowBox[{"1", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24435],

Cell[BoxData[
 RowBox[{"0.6349639147965727`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.2984575814314623`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7492]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5732],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->191528983],

Cell["ND is threaded element-wise:", "ExampleText",
 CellID->30076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", "x", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.718281828499301`", ",", "0.5403023058792048`"}], "}"}]], "Output",\

 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->403]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18367],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18899],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->390580160],

Cell[TextData[{
 "Use the default ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Method"], "->", "EulerSum"}]], "InlineFormula"],
 " when ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is not analytic in the neighborhood of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Cos", "[", 
     RowBox[{"I", " ", "y"}], "]"}], "]"}], ",", "y", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10167],

Cell[BoxData["1.1752011936656868`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19212]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->26114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"Re", "[", 
       RowBox[{"Cos", "[", 
        RowBox[{"I", " ", "y"}], "]"}], "]"}], "]"}], ",", "y"}], "]"}], "/.",
    
   RowBox[{"y", "->", "1"}]}], "//", "N"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30129],

Cell[BoxData["1.1752011936438014`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5793]
}, Open  ]],

Cell[TextData[{
 "An incorrect answer is obtained with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Cos", "[", 
     RowBox[{"I", " ", "y"}], "]"}], "]"}], ",", "y", ",", "1", ",", 
   RowBox[{"Method", "->", "NIntegrate"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29854],

Cell[BoxData[
 RowBox[{"0.5876005968219005`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.7755575615628914`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->15012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6831],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->270734359],

Cell["Here is a derivative where the default method works poorly:", \
"ExampleText",
 CellID->14889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    SuperscriptBox["x", "2"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23326],

Cell[BoxData["68.50733029097267`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32647]
}, Open  ]],

Cell["The correct answer is:", "ExampleText",
 CellID->11299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     SuperscriptBox["x", "2"], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "3"}], "}"}]}], "]"}], "/.", 
  RowBox[{"x", "->", "1."}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2489],

Cell[BoxData["54.36563656918091`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29674]
}, Open  ]],

Cell[TextData[{
 "In this case the expression is analytic, so ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"]}]], "InlineFormula"],
 " will work well:"
}], "ExampleText",
 CellID->25836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    SuperscriptBox["x", "2"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}], ",", "1", ",", 
   RowBox[{"Method", "->", "NIntegrate"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6612],

Cell[BoxData[
 RowBox[{"54.3656365691809`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.798561299892754`*^-14", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->24387]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scale",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11957],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->98964196],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/Scale"], "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " to capture region of variation:"
}], "ExampleText",
 CellID->15503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"100", "x"}], "]"}], ",", "x", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19491],

Cell[BoxData["215.87924646390655`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10482]
}, Open  ]],

Cell[TextData[{
 "The scale of variation is around ",
 Cell[BoxData[".01"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"100", "x"}], "]"}], ",", "x", ",", "0", ",", 
   RowBox[{"Scale", "->", ".01"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27027],

Cell[BoxData["100.00000000025713`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13361]
}, Open  ]],

Cell[TextData[{
 "A value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/Scale"], "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " which is too large can be compensated by increasing the number of terms:"
}], "ExampleText",
 CellID->952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"100", "x"}], "]"}], ",", "x", ",", "0", ",", 
   RowBox[{"Terms", "->", "11"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8496],

Cell[BoxData["100.00003898691293`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->5646]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15183],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->423400582],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Scale"]], "InlineFormula"],
 " to specify directional derivatives. The left and right derivatives of the \
nonanalytic function ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"\[LeftBracketingBar]", "x", "\[RightBracketingBar]"}], "TI"]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11554],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25032]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", "0", ",", 
   RowBox[{"Scale", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18102],

Cell[BoxData[
 RowBox[{"-", "1.`"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5945]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->20476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28224],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->23079353]
}, Open  ]],

Cell["Complex directions may also be specified:", "ExampleText",
 CellID->22195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", "0", ",", 
   RowBox[{"Scale", "->", 
    RowBox[{"1", "+", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31623],

Cell[BoxData[
 RowBox[{"0.7071067811865475`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.7071067811865475`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->27632]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->28343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "I"}], ")"}], "h"}], "]"}], "-", 
      RowBox[{"Abs", "[", "0", "]"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "I"}], ")"}], "h"}]], ",", 
    RowBox[{"h", "->", "0"}]}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->22602],

Cell[BoxData[
 RowBox[{"0.7071067811865475`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.7071067811865475`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->15369]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3282],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->222227622],

Cell[TextData[{
 "Use the option ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " to avoid regions of nonanalyticity when the method used is ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    FractionBox["1", 
     RowBox[{"1", "-", "x"}]], "]"}], ",", "x", ",", ".5", ",", 
   RowBox[{"Method", "->", "NIntegrate"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14437],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvi\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"NIntegrate failed to converge to \
prescribed accuracy after \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(9\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" iterated refinements \
in \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(NumericalMath`NLimit`Private`t$174\\)\\!\\(\\*StyleBox[\\\
\"\\\\\\\" in the region \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\({\\({0.`, \
6.283185307179586`}\\)}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\".\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NIntegrate/ncvi\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->21599],

Cell[BoxData[
 RowBox[{"0``15.405544587387448", "+", 
  RowBox[{"0``15.405544587387448", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->35]
}, Open  ]],

Cell[TextData[{
 "Shrinking the radius avoids the essential singularity at ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Equal]", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    FractionBox["1", 
     RowBox[{"1", "-", "x"}]], "]"}], ",", "x", ",", ".5", ",", 
   RowBox[{"Method", "->", "NIntegrate"}], ",", 
   RowBox[{"Scale", "->", ".1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19654],

Cell[BoxData[
 RowBox[{"29.5562243957226`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.7763568394002505`*^-15", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24652]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->23399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     FractionBox["1", 
      RowBox[{"1", "-", "x"}]], "]"}], ",", "x"}], "]"}], "/.", 
  RowBox[{"x", "->", ".5"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28350],

Cell[BoxData["29.5562243957226`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->30132]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Terms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28945],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->541718349],

Cell["\<\
Increasing the number of terms may improve accuracy. Here is a somewhat \
inaccurate approximation:\
\>", "ExampleText",
 CellID->5293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["x", "2"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21871],

Cell[BoxData[
 RowBox[{"-", "14.415801450148729`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2649]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->22590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "3"}], "}"}]}], "]"}], "/.", 
  RowBox[{"x", "->", "1`30"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29204],

Cell[BoxData[
 RowBox[{"-", 
  "14.42007026463987581903752071910740082533`29.71750058728235"}]], "Output",
 ImageSize->{229, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32177]
}, Open  ]],

Cell["\<\
Increasing the number of terms produces a more accurate answer:\
\>", "ExampleText",
 CellID->25705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ND", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "3"}], "}"}], ",", "1", ",", 
    RowBox[{"Terms", "->", "10"}]}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5319],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"-", "14.420070284583973`"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->4750]
}, Open  ]],

Cell["\<\
Increasing the number of terms further can produce nonsense due to numerical \
instability:\
\>", "ExampleText",
 CellID->897419669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["x", "2"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}], ",", "1", ",", 
   RowBox[{"Terms", "->", "20"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->20228],

Cell[BoxData["33.97412842860368`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->5722]
}, Open  ]],

Cell["\<\
Combining an increase in the number of terms with a higher working precision \
often will reduce the error:\
\>", "ExampleText",
 CellID->29668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SuperscriptBox["x", "2"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}], ",", "1", ",", 
   RowBox[{"Terms", "->", "20"}], ",", 
   RowBox[{"WorkingPrecision", "->", "40"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->8785],

Cell[BoxData[
 RowBox[{"-", 
  "14.42007026463987581903752071910748618358`22.483070848463477"}]], "Output",\

 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->23774]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19184],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->389541661],

Cell[TextData[{
 "High-order derivatives with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", "EulerSum"}]], "InlineFormula"],
 " experience significant subtractive cancellation:"
}], "ExampleText",
 CellID->6651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10"}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18884],

Cell[BoxData[
 RowBox[{"-", "86411.29081217309`"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27037]
}, Open  ]],

Cell["\<\
Using a higher working precision and additional terms produces an accurate \
answer:\
\>", "ExampleText",
 CellID->10915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10"}], "}"}], ",", "0", ",", 
   RowBox[{"WorkingPrecision", "->", "40"}], ",", 
   RowBox[{"Terms", "->", "10"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15189],

Cell[BoxData["0.9999999999990373947`9.353757621007098"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11681]
}, Open  ]],

Cell[TextData[{
 "For this problem, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"]}]], "InlineFormula"],
 " with default options produces a correct answer:"
}], "ExampleText",
 CellID->19074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10"}], "}"}], ",", "0", ",", 
   RowBox[{"Method", "->", "NIntegrate"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13759],

Cell[BoxData[
 RowBox[{"1.0000000007853282`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.3345324845204234`*^-9", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->5850]
}, Open  ]],

Cell["\<\
Higher order derivatives will again experience numerical instability:\
\>", "ExampleText",
 CellID->4546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "20"}], "}"}], ",", "0", ",", 
   RowBox[{"Method", "->", "NIntegrate"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->29260],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvi\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"NIntegrate failed to converge to \
prescribed accuracy after \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(9\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" iterated refinements \
in \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(NumericalMath`NLimit`Private`t$288\\)\\!\\(\\*StyleBox[\\\
\"\\\\\\\" in the region \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\({\\({0.`, \
6.283185307179586`}\\)}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\".\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NIntegrate/ncvi\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->6427],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "386.41500867166883`"}], "+", 
  RowBox[{"51.024124401161124`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->22233]
}, Open  ]],

Cell[TextData[{
 "Increasing ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " will improve the accuracy:"
}], "ExampleText",
 CellID->9421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "20"}], "}"}], ",", "0", ",", 
   RowBox[{"Method", "->", "NIntegrate"}], ",", 
   RowBox[{"WorkingPrecision", "->", "30"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->3161],

Cell[BoxData[
 RowBox[{"0.999999999999999997352548475328941139579119201496`30.\
15051499783199", "+", 
  RowBox[{
  "1.40537810099299720256763078`8.298308179784005*^-22", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{370, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->27818]
}, Open  ]],

Cell["\<\
An alternative is to increase the radius of the contour of integration:\
\>", "ExampleText",
 CellID->9546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "20"}], "}"}], ",", "0", ",", 
   RowBox[{"Method", "->", "NIntegrate"}], ",", 
   RowBox[{"Scale", "->", "5"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->21350],

Cell[BoxData[
 RowBox[{"0.9999999996449286`", "\[InvisibleSpace]", "+", 
  RowBox[{"3.17631121920142`*^-10", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->21263]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16461],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->106482491],

Cell[TextData[{
 Cell[BoxData["ND"], "InlineFormula"],
 " is useful for differentiating functions which are only defined \
numerically. Here is such a function:"
}], "ExampleText",
 CellID->21846],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"a_", "?", "NumericQ"}], ",", 
    RowBox[{"b_", "?", "NumericQ"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "t", "}"}], ",", 
     RowBox[{"y", "/.", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
            RowBox[{"a", "-", 
             RowBox[{"b", " ", 
              SuperscriptBox[
               RowBox[{"y", "[", "t", "]"}], "3"]}]}]}], ",", 
           RowBox[{
            RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", ",",
          
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], 
       "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23458],

Cell[TextData[{
 "Here is the derivative of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "]"}], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " evaluated at ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["t", "TI"]}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"1", ",", "b"}], "]"}], "[", "1", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27371],

Cell[BoxData[
 RowBox[{"-", "0.13290422223299753`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17945]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["ND"], "InlineFormula"],
 " can be used as an aid in developing and testing a more robust function for \
finding the derivative:"
}], "ExampleText",
 CellID->13502],

Cell[BoxData[
 RowBox[{
  RowBox[{"fb", "[", 
   RowBox[{
    RowBox[{"a_", "?", "NumericQ"}], ",", 
    RowBox[{"b_", "?", "NumericQ"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"fb", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "t", "}"}], ",", 
     RowBox[{"yb", "/.", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
            RowBox[{"a", "-", 
             RowBox[{"b", " ", 
              SuperscriptBox[
               RowBox[{"y", "[", "t", "]"}], "3"]}]}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"yb", "'"}], "[", "t", "]"}], "==", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox[
               RowBox[{"y", "[", "t", "]"}], "3"]}], "-", 
             RowBox[{"3", "b", " ", 
              SuperscriptBox[
               RowBox[{"y", "[", "t", "]"}], "2"], 
              RowBox[{"yb", "[", "t", "]"}]}]}]}], ",", 
           RowBox[{
            RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
           RowBox[{
            RowBox[{"yb", "[", "0", "]"}], "==", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "yb"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], 
       "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8246],

Cell["Check:", "ExampleText",
 CellID->20420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fb", "[", 
   RowBox[{"1", ",", "2"}], "]"}], "[", "1", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->25254],

Cell[BoxData[
 RowBox[{"-", "0.13290423230072387`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->7953]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15760],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->907180813],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"]}]], "InlineFormula"],
 " uses Cauchy's integral formula to compute derivatives:"
}], "ExampleText",
 CellID->3586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    SuperscriptBox["x", "2"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4"}], "}"}], ",", "0", ",", 
   RowBox[{"Method", "->", "NIntegrate"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25419],

Cell[BoxData[
 RowBox[{"11.999999999999993`", "\[InvisibleSpace]", "+", 
  RowBox[{"7.072469981567318`*^-16", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28735]
}, Open  ]],

Cell[TextData[{
 "The equivalent computation can be performed using ",
 Cell[BoxData[
  ButtonBox["NResidue",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NResidue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"4", "!"}], 
  RowBox[{"NResidue", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Exp", "[", 
      SuperscriptBox["x", "2"], "]"}], 
     SuperscriptBox["x", 
      RowBox[{"4", "+", "1"}]]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13335],

Cell[BoxData[
 RowBox[{"11.999999647960067`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.085432435414935`*^-7", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29018],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->373729283],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has built in code to compute derivatives of numerical functions:"
}], "ExampleText",
 CellID->9265],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"t_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"0.001", "+", 
   RowBox[{"0.002", 
    RowBox[{"Sin", "[", 
     RowBox[{"50", "t"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9370],

Cell["\<\
The built-in numerical derivative code can be used. However, it is unable to \
capture the rapid oscillations:\
\>", "ExampleText",
 CellID->22336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "'"}], "[", ".1", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26525],

Cell[BoxData["0.018292619556887216`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12746]
}, Open  ]],

Cell["The correct answer:", "ExampleText",
 CellID->17644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{".001", "+", 
     RowBox[{".002", 
      RowBox[{"Sin", "[", 
       RowBox[{"50", "t"}], "]"}]}]}], ",", "t"}], "]"}], "/.", 
  RowBox[{"t", "->", ".1"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->19512],

Cell[BoxData["0.028366218546322625`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->29482]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData["ND"], "InlineFormula"],
 " with the appropriate options can compute an accurate derivative:"
}], "ExampleText",
 CellID->2815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", "t", ",", ".1", ",", 
   RowBox[{"Scale", "->", ".1"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->5105],

Cell[BoxData["0.028366202321072575`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->25726]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", "t", ",", ".1", ",", 
   RowBox[{"Method", "->", "NIntegrate"}], ",", 
   RowBox[{"Scale", "->", 
    FractionBox["1", "2"]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->23201],

Cell[BoxData[
 RowBox[{"0.02836622449405861`", "\[InvisibleSpace]", "-", 
  RowBox[{"3.724118967894652`*^-8", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25306],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->24780450],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", "EulerSum"}]], "InlineFormula"],
 ", ",
 Cell[BoxData["ND"], "InlineFormula"],
 " must be able to evaluate ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " at the point ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3080],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"Tanh", "[", 
    RowBox[{"\[Pi]", " ", "x"}], "]"}], 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}]]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x", ",", "I"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23990],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Infinite expression \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(1\\/\\(\\(\\(0.`\[InvisibleSpace]\\)\\) + \\(\\(0.`\\\\ \
\[ImaginaryI]\\)\\)\\)\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" \
encountered.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/General/infy\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->4591],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Indeterminate expression \\\\\\\"\\\
\", \\\"MSG\\\"]\\)\\!\\(ComplexInfinity + \
ComplexInfinity\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" encountered.\\\\\\\"\\\", \\\
\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/General/indet\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->24214],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Indeterminate expression \\\\\\\"\\\
\", \\\"MSG\\\"]\\)\\!\\(ComplexInfinity + \
ComplexInfinity\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" encountered.\\\\\\\"\\\", \\\
\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/General/indet\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->3223],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Indeterminate expression \\\\\\\"\\\
\", \\\"MSG\\\"]\\)\\!\\(ComplexInfinity + \
ComplexInfinity\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" encountered.\\\\\\\"\\\", \\\
\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/General/indet\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->5857],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Further output of \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(\[Infinity] :: \
\\\"indet\\\"\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" will be suppressed during this \
calculation.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/General/stop\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->2700],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18849]
}, Open  ]],

Cell[TextData[{
 "Adding an additional definition for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " allows ",
 Cell[BoxData["ND"], "InlineFormula"],
 " to compute the derivative:"
}], "ExampleText",
 CellID->2322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"I", "//", "N"}], "]"}], "=", 
  RowBox[{"Limit", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"\[Pi]", " ", "x"}], "]"}], 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}]], ",", 
    RowBox[{"x", "->", "I"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13285],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]}]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->6762]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x", ",", "I"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2702],

Cell[BoxData[
 RowBox[{"0.7854017336217205`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.00004270855386688568`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1268]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->21374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"Tanh", "[", 
        RowBox[{"\[Pi]", " ", "x"}], "]"}], 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}]], ",", "x"}], "]"}], ",", 
    RowBox[{"x", "->", "I"}]}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5152],

Cell[BoxData["0.7853981633974483`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->23848]
}, Open  ]],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"]}]], "InlineFormula"],
 " produces a more accurate answer:"
}], "ExampleText",
 CellID->29235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x", ",", "I", ",", 
   RowBox[{"Method", "->", "NIntegrate"}], ",", 
   RowBox[{"Scale", "->", 
    FractionBox["1", "10"]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->28638],

Cell[BoxData[
 RowBox[{"0.7853981633974472`", "\[InvisibleSpace]", "+", 
  RowBox[{"8.969364576509012`*^-16", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->22762]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6272],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->243210088],

Cell["Some fractional and complex derivatives can be computed:", "ExampleText",
 CellID->1792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}], ",", "1", ",", 
   RowBox[{"Method", "->", "NIntegrate"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12200],

Cell[BoxData[
 RowBox[{"0.7522528886964267`", "\[InvisibleSpace]", "+", 
  RowBox[{"9.070416050491317`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26343]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   SuperscriptBox["x", "4"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "I"}], "}"}], ",", "1", ",", 
   RowBox[{"Method", "->", "NIntegrate"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17519],

Cell[BoxData[
 RowBox[{"0.06320276376510124`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.1142473372089585`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7481]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4208],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NSeries"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NResidue",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NResidue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25656]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31958],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->20238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ND - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 11.1087654}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "ND[expr, x, x_0] gives a numerical approximation to the derivative of \
expr with respect to x at the point x_0. ND[expr, {x, n}, x_0] gives a \
numerical approximation to the n^th derivative of expr.", "synonyms" -> {}, 
    "title" -> "ND", "type" -> "Symbol", "uri" -> 
    "NumericalCalculus/ref/ND"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10474, 378, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->534050516]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 62964, 2396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1549, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2172, 65, 40, 1, 70, "ObjectName",
 CellID->14331],
Cell[2215, 68, 1523, 50, 70, "Usage",
 CellID->7970]
}, Open  ]],
Cell[CellGroupData[{
Cell[3775, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4253, 140, 376, 13, 70, "Notes",
 CellID->26053],
Cell[4632, 155, 508, 20, 70, "Notes",
 CellID->8768],
Cell[5143, 177, 331, 9, 70, "Notes",
 CellID->28052],
Cell[5477, 188, 69, 1, 70, "Notes",
 CellID->13178],
Cell[5549, 191, 867, 25, 70, "3ColumnTable",
 CellID->11156],
Cell[6419, 218, 199, 8, 70, "Notes",
 CellID->24981],
Cell[6621, 228, 568, 14, 70, "2ColumnTableMod",
 CellID->12695],
Cell[7192, 244, 447, 19, 70, "Notes",
 CellID->17586],
Cell[7642, 265, 351, 13, 70, "Notes",
 CellID->13929],
Cell[7996, 280, 449, 16, 70, "Notes",
 CellID->731],
Cell[8448, 298, 455, 14, 70, "Notes",
 CellID->4278],
Cell[8906, 314, 460, 16, 70, "Notes",
 CellID->17859],
Cell[9369, 332, 524, 20, 70, "Notes",
 CellID->8752],
Cell[9896, 354, 541, 19, 70, "Notes",
 CellID->5089]
}, Closed]],
Cell[CellGroupData[{
Cell[10474, 378, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->534050516],
Cell[CellGroupData[{
Cell[10859, 392, 146, 5, 70, "ExampleSection",
 CellID->7894293],
Cell[11008, 399, 142, 4, 70, "Input",
 CellID->553284329],
Cell[CellGroupData[{
Cell[11175, 407, 158, 5, 28, "Input",
 CellID->19511],
Cell[11336, 414, 171, 5, 36, "Output",
 CellID->32174]
}, Open  ]],
Cell[CellGroupData[{
Cell[11544, 424, 233, 8, 30, "Input",
 CellID->28819],
Cell[11780, 434, 188, 6, 36, "Output",
 CellID->26107]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12017, 446, 216, 7, 70, "ExampleSection",
 CellID->22599],
Cell[12236, 455, 142, 4, 70, "Input",
 CellID->131317981],
Cell[12381, 461, 88, 1, 70, "ExampleText",
 CellID->788],
Cell[CellGroupData[{
Cell[12494, 466, 186, 6, 70, "Input",
 CellID->13261],
Cell[12683, 474, 273, 7, 36, "Output",
 CellID->29045]
}, Open  ]],
Cell[CellGroupData[{
Cell[12993, 486, 207, 7, 70, "Input",
 CellID->24435],
Cell[13203, 495, 268, 7, 36, "Output",
 CellID->7492]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13520, 508, 238, 7, 70, "ExampleSection",
 CellID->5732],
Cell[13761, 517, 142, 4, 70, "Input",
 CellID->191528983],
Cell[13906, 523, 67, 1, 70, "ExampleText",
 CellID->30076],
Cell[CellGroupData[{
Cell[13998, 528, 244, 9, 70, "Input",
 CellID->4667],
Cell[14245, 539, 235, 8, 36, "Output",
 CellID->403]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14529, 553, 218, 7, 70, "ExampleSection",
 CellID->18367],
Cell[CellGroupData[{
Cell[14772, 564, 223, 7, 70, "ExampleSubsection",
 CellID->18899],
Cell[14998, 573, 142, 4, 70, "Input",
 CellID->390580160],
Cell[15143, 579, 449, 17, 70, "ExampleText",
 CellID->21054],
Cell[CellGroupData[{
Cell[15617, 600, 218, 8, 70, "Input",
 CellID->10167],
Cell[15838, 610, 172, 5, 36, "Output",
 CellID->19212]
}, Open  ]],
Cell[16025, 618, 45, 1, 70, "ExampleText",
 CellID->26114],
Cell[CellGroupData[{
Cell[16095, 623, 336, 12, 70, "Input",
 CellID->30129],
Cell[16434, 637, 171, 5, 36, "Output",
 CellID->5793]
}, Open  ]],
Cell[16620, 645, 327, 12, 70, "ExampleText",
 CellID->11977],
Cell[CellGroupData[{
Cell[16972, 661, 264, 8, 70, "Input",
 CellID->29854],
Cell[17239, 671, 274, 7, 36, "Output",
 CellID->15012]
}, Open  ]],
Cell[17528, 681, 120, 3, 70, "ExampleDelimiter",
 CellID->6831],
Cell[17651, 686, 142, 4, 70, "Input",
 CellID->270734359],
Cell[17796, 692, 100, 2, 70, "ExampleText",
 CellID->14889],
Cell[CellGroupData[{
Cell[17921, 698, 233, 8, 70, "Input",
 CellID->23326],
Cell[18157, 708, 171, 5, 36, "Output",
 CellID->32647]
}, Open  ]],
Cell[18343, 716, 61, 1, 70, "ExampleText",
 CellID->11299],
Cell[CellGroupData[{
Cell[18429, 721, 275, 10, 70, "Input",
 CellID->2489],
Cell[18707, 733, 171, 5, 36, "Output",
 CellID->29674]
}, Open  ]],
Cell[18893, 741, 349, 12, 70, "ExampleText",
 CellID->25836],
Cell[CellGroupData[{
Cell[19267, 757, 281, 9, 70, "Input",
 CellID->6612],
Cell[19551, 768, 271, 7, 36, "Output",
 CellID->24387]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19871, 781, 222, 7, 70, "ExampleSubsection",
 CellID->11957],
Cell[20096, 790, 141, 4, 70, "Input",
 CellID->98964196],
Cell[20240, 796, 273, 10, 70, "ExampleText",
 CellID->15503],
Cell[CellGroupData[{
Cell[20538, 810, 180, 6, 70, "Input",
 CellID->19491],
Cell[20721, 818, 172, 5, 36, "Output",
 CellID->10482]
}, Open  ]],
Cell[20908, 826, 132, 5, 70, "ExampleText",
 CellID->2829],
Cell[CellGroupData[{
Cell[21065, 835, 221, 7, 70, "Input",
 CellID->27027],
Cell[21289, 844, 172, 5, 36, "Output",
 CellID->13361]
}, Open  ]],
Cell[21476, 852, 319, 10, 70, "ExampleText",
 CellID->952],
Cell[CellGroupData[{
Cell[21820, 866, 219, 7, 70, "Input",
 CellID->8496],
Cell[22042, 875, 171, 5, 36, "Output",
 CellID->5646]
}, Open  ]],
Cell[22228, 883, 121, 3, 70, "ExampleDelimiter",
 CellID->15183],
Cell[22352, 888, 142, 4, 70, "Input",
 CellID->423400582],
Cell[22497, 894, 421, 14, 70, "ExampleText",
 CellID->15597],
Cell[CellGroupData[{
Cell[22943, 912, 207, 7, 70, "Input",
 CellID->11554],
Cell[23153, 921, 156, 5, 36, "Output",
 CellID->25032]
}, Open  ]],
Cell[CellGroupData[{
Cell[23346, 931, 266, 9, 70, "Input",
 CellID->18102],
Cell[23615, 942, 172, 6, 36, "Output",
 CellID->5945]
}, Open  ]],
Cell[23802, 951, 45, 1, 70, "ExampleText",
 CellID->20476],
Cell[CellGroupData[{
Cell[23872, 956, 230, 8, 70, "Input",
 CellID->28224],
Cell[24105, 966, 2961, 53, 70, "Output",
 Evaluatable->False,
 CellID->23079353]
}, Open  ]],
Cell[27081, 1022, 80, 1, 70, "ExampleText",
 CellID->22195],
Cell[CellGroupData[{
Cell[27186, 1027, 271, 9, 70, "Input",
 CellID->31623],
Cell[27460, 1038, 269, 7, 36, "Output",
 CellID->27632]
}, Open  ]],
Cell[27744, 1048, 45, 1, 70, "ExampleText",
 CellID->28343],
Cell[CellGroupData[{
Cell[27814, 1053, 446, 16, 70, "Input",
 CellID->22602],
Cell[28263, 1071, 269, 7, 36, "Output",
 CellID->15369]
}, Open  ]],
Cell[28547, 1081, 120, 3, 70, "ExampleDelimiter",
 CellID->3282],
Cell[28670, 1086, 142, 4, 70, "Input",
 CellID->222227622],
Cell[28815, 1092, 376, 13, 70, "ExampleText",
 CellID->19989],
Cell[CellGroupData[{
Cell[29216, 1109, 257, 8, 70, "Input",
 CellID->14437],
Cell[29476, 1119, 733, 14, 70, "Message",
 CellID->21599],
Cell[30212, 1135, 249, 7, 36, "Output",
 CellID->35]
}, Open  ]],
Cell[30476, 1145, 204, 7, 70, "ExampleText",
 CellID->3179],
Cell[CellGroupData[{
Cell[30705, 1156, 297, 9, 70, "Input",
 CellID->19654],
Cell[31005, 1167, 272, 7, 36, "Output",
 CellID->24652]
}, Open  ]],
Cell[31292, 1177, 45, 1, 70, "ExampleText",
 CellID->23399],
Cell[CellGroupData[{
Cell[31362, 1182, 249, 9, 70, "Input",
 CellID->28350],
Cell[31614, 1193, 170, 5, 36, "Output",
 CellID->30132]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31833, 1204, 222, 7, 70, "ExampleSubsection",
 CellID->28945],
Cell[32058, 1213, 142, 4, 70, "Input",
 CellID->541718349],
Cell[32203, 1219, 145, 4, 70, "ExampleText",
 CellID->5293],
Cell[CellGroupData[{
Cell[32373, 1227, 233, 8, 70, "Input",
 CellID->21871],
Cell[32609, 1237, 188, 6, 36, "Output",
 CellID->2649]
}, Open  ]],
Cell[32812, 1246, 45, 1, 70, "ExampleText",
 CellID->22590],
Cell[CellGroupData[{
Cell[32882, 1251, 278, 10, 70, "Input",
 CellID->29204],
Cell[33163, 1263, 233, 7, 36, "Output",
 CellID->32177]
}, Open  ]],
Cell[33411, 1273, 110, 3, 70, "ExampleText",
 CellID->25705],
Cell[CellGroupData[{
Cell[33546, 1280, 309, 10, 70, "Input",
 CellID->5319],
Cell[33858, 1292, 322, 12, 50, "Output",
 CellID->4750]
}, Open  ]],
Cell[34195, 1307, 142, 4, 70, "ExampleText",
 CellID->897419669],
Cell[CellGroupData[{
Cell[34362, 1315, 273, 9, 70, "Input",
 CellID->20228],
Cell[34638, 1326, 170, 5, 36, "Output",
 CellID->5722]
}, Open  ]],
Cell[34823, 1334, 154, 4, 70, "ExampleText",
 CellID->29668],
Cell[CellGroupData[{
Cell[35002, 1342, 323, 10, 70, "Input",
 CellID->8785],
Cell[35328, 1354, 236, 8, 36, "Output",
 CellID->23774]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35613, 1368, 233, 7, 70, "ExampleSubsection",
 CellID->19184],
Cell[35849, 1377, 142, 4, 70, "Input",
 CellID->389541661],
Cell[35994, 1383, 284, 9, 70, "ExampleText",
 CellID->6651],
Cell[CellGroupData[{
Cell[36303, 1396, 208, 7, 70, "Input",
 CellID->18884],
Cell[36514, 1405, 188, 6, 36, "Output",
 CellID->27037]
}, Open  ]],
Cell[36717, 1414, 131, 4, 70, "ExampleText",
 CellID->10915],
Cell[CellGroupData[{
Cell[36873, 1422, 299, 9, 70, "Input",
 CellID->15189],
Cell[37175, 1433, 192, 5, 36, "Output",
 CellID->11681]
}, Open  ]],
Cell[37382, 1441, 355, 12, 70, "ExampleText",
 CellID->19074],
Cell[CellGroupData[{
Cell[37762, 1457, 257, 8, 70, "Input",
 CellID->13759],
Cell[38022, 1467, 272, 7, 36, "Output",
 CellID->5850]
}, Open  ]],
Cell[38309, 1477, 115, 3, 70, "ExampleText",
 CellID->4546],
Cell[CellGroupData[{
Cell[38449, 1484, 257, 8, 70, "Input",
 CellID->29260],
Cell[38709, 1494, 732, 14, 70, "Message",
 CellID->6427],
Cell[39444, 1510, 266, 8, 36, "Output",
 CellID->22233]
}, Open  ]],
Cell[39725, 1521, 231, 8, 70, "ExampleText",
 CellID->9421],
Cell[CellGroupData[{
Cell[39981, 1533, 307, 9, 70, "Input",
 CellID->3161],
Cell[40291, 1544, 338, 10, 36, "Output",
 CellID->27818]
}, Open  ]],
Cell[40644, 1557, 117, 3, 70, "ExampleText",
 CellID->9546],
Cell[CellGroupData[{
Cell[40786, 1564, 296, 9, 70, "Input",
 CellID->21350],
Cell[41085, 1575, 272, 7, 36, "Output",
 CellID->21263]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41418, 1589, 223, 7, 70, "ExampleSection",
 CellID->16461],
Cell[41644, 1598, 142, 4, 70, "Input",
 CellID->106482491],
Cell[41789, 1604, 196, 5, 70, "ExampleText",
 CellID->21846],
Cell[41988, 1611, 1015, 33, 70, "Input",
 CellID->23458],
Cell[43006, 1646, 633, 25, 70, "ExampleText",
 CellID->9594],
Cell[CellGroupData[{
Cell[43664, 1675, 261, 9, 70, "Input",
 CellID->27371],
Cell[43928, 1686, 190, 6, 36, "Output",
 CellID->17945]
}, Open  ]],
Cell[44133, 1695, 194, 5, 70, "ExampleText",
 CellID->13502],
Cell[44330, 1702, 1563, 47, 70, "Input",
 CellID->8246],
Cell[45896, 1751, 45, 1, 70, "ExampleText",
 CellID->20420],
Cell[CellGroupData[{
Cell[45966, 1756, 146, 5, 70, "Input",
 CellID->25254],
Cell[46115, 1763, 189, 6, 36, "Output",
 CellID->7953]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46353, 1775, 233, 7, 70, "ExampleSection",
 CellID->15760],
Cell[46589, 1784, 142, 4, 70, "Input",
 CellID->907180813],
Cell[46734, 1790, 354, 12, 70, "ExampleText",
 CellID->3586],
Cell[CellGroupData[{
Cell[47113, 1806, 282, 9, 70, "Input",
 CellID->25419],
Cell[47398, 1817, 273, 7, 36, "Output",
 CellID->28735]
}, Open  ]],
Cell[47686, 1827, 247, 8, 70, "ExampleText",
 CellID->16616],
Cell[CellGroupData[{
Cell[47958, 1839, 349, 13, 70, "Input",
 CellID->13335],
Cell[48310, 1854, 272, 7, 36, "Output",
 CellID->28592]
}, Open  ]],
Cell[48597, 1864, 121, 3, 70, "ExampleDelimiter",
 CellID->29018],
Cell[48721, 1869, 142, 4, 70, "Input",
 CellID->373729283],
Cell[48866, 1875, 167, 5, 70, "ExampleText",
 CellID->9265],
Cell[49036, 1882, 252, 9, 70, "Input",
 CellID->9370],
Cell[49291, 1893, 157, 4, 70, "ExampleText",
 CellID->22336],
Cell[CellGroupData[{
Cell[49473, 1901, 112, 4, 70, "Input",
 CellID->26525],
Cell[49588, 1907, 174, 5, 36, "Output",
 CellID->12746]
}, Open  ]],
Cell[49777, 1915, 58, 1, 70, "ExampleText",
 CellID->17644],
Cell[CellGroupData[{
Cell[49860, 1920, 276, 10, 70, "Input",
 CellID->19512],
Cell[50139, 1932, 174, 5, 36, "Output",
 CellID->29482]
}, Open  ]],
Cell[50328, 1940, 168, 5, 70, "ExampleText",
 CellID->2815],
Cell[CellGroupData[{
Cell[50521, 1949, 196, 6, 70, "Input",
 CellID->5105],
Cell[50720, 1957, 174, 5, 36, "Output",
 CellID->25726]
}, Open  ]],
Cell[CellGroupData[{
Cell[50931, 1967, 268, 8, 70, "Input",
 CellID->23201],
Cell[51202, 1977, 271, 7, 36, "Output",
 CellID->773]
}, Open  ]],
Cell[51488, 1987, 121, 3, 70, "ExampleDelimiter",
 CellID->25306],
Cell[51612, 1992, 141, 4, 70, "Input",
 CellID->24780450],
Cell[51756, 1998, 469, 19, 70, "ExampleText",
 CellID->3080],
Cell[52228, 2019, 281, 10, 70, "Input",
 CellID->31593],
Cell[CellGroupData[{
Cell[52534, 2033, 156, 5, 70, "Input",
 CellID->23990],
Cell[52693, 2040, 523, 10, 70, "Message",
 CellID->4591],
Cell[53219, 2052, 492, 10, 70, "Message",
 CellID->24214],
Cell[53714, 2064, 491, 10, 70, "Message",
 CellID->3223],
Cell[54208, 2076, 491, 10, 70, "Message",
 CellID->5857],
Cell[54702, 2088, 504, 10, 70, "Message",
 CellID->2700],
Cell[55209, 2100, 166, 5, 36, "Output",
 CellID->18849]
}, Open  ]],
Cell[55390, 2108, 230, 8, 70, "ExampleText",
 CellID->2322],
Cell[CellGroupData[{
Cell[55645, 2120, 365, 13, 70, "Input",
 CellID->13285],
Cell[56013, 2135, 231, 8, 51, "Output",
 CellID->6762]
}, Open  ]],
Cell[CellGroupData[{
Cell[56281, 2148, 155, 5, 70, "Input",
 CellID->2702],
Cell[56439, 2155, 272, 7, 36, "Output",
 CellID->1268]
}, Open  ]],
Cell[56726, 2165, 45, 1, 70, "ExampleText",
 CellID->21374],
Cell[CellGroupData[{
Cell[56796, 2170, 378, 13, 70, "Input",
 CellID->5152],
Cell[57177, 2185, 172, 5, 36, "Output",
 CellID->23848]
}, Open  ]],
Cell[57364, 2193, 336, 12, 70, "ExampleText",
 CellID->29235],
Cell[CellGroupData[{
Cell[57725, 2209, 268, 8, 70, "Input",
 CellID->28638],
Cell[57996, 2219, 273, 7, 36, "Output",
 CellID->22762]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58318, 2232, 223, 7, 70, "ExampleSection",
 CellID->6272],
Cell[58544, 2241, 142, 4, 70, "Input",
 CellID->243210088],
Cell[58689, 2247, 94, 1, 70, "ExampleText",
 CellID->1792],
Cell[CellGroupData[{
Cell[58808, 2252, 271, 9, 70, "Input",
 CellID->12200],
Cell[59082, 2263, 273, 7, 36, "Output",
 CellID->26343]
}, Open  ]],
Cell[CellGroupData[{
Cell[59392, 2275, 250, 8, 70, "Input",
 CellID->17519],
Cell[59645, 2285, 269, 7, 36, "Output",
 CellID->7481]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59975, 2299, 310, 9, 70, "SeeAlsoSection",
 CellID->4208],
Cell[60288, 2310, 975, 35, 70, "SeeAlso",
 CellID->25656]
}, Open  ]],
Cell[CellGroupData[{
Cell[61300, 2350, 314, 9, 70, "TutorialsSection",
 CellID->31958],
Cell[61617, 2361, 175, 4, 70, "Tutorials",
 CellID->20238]
}, Open  ]],
Cell[61807, 2368, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

