(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36890,       1433]
NotebookOptionsPosition[     28895,       1139]
NotebookOutlinePosition[     30155,       1175]
CellTagsIndexPosition[     30069,       1170]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NSeries" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NSeries"], 
          "Residue" :> Documentation`HelpLookup["paclet:ref/Residue"], 
          "NLimit" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NLimit"], 
          "ND" :> Documentation`HelpLookup[
           "paclet:NumericalCalculus/ref/ND"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NSeries\"\>", 2->"\<\"Residue\"\>", 
       3->"\<\"NLimit\"\>", 4->"\<\"ND\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NResidue", "ObjectName",
 CellID->19659],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NResidue", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["z", "TI"], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["0", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]numerically finds the residue of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " near the point ",
     Cell[BoxData[
      RowBox[{
       StyleBox["z", "TI"], "=", 
       SubscriptBox[
        StyleBox["z", "TI"], 
        StyleBox["0", "TR"]]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " must be numeric when its argument ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is numeric."
}], "Notes",
 CellID->29368],

Cell[TextData[{
 "The residue is defined as the coefficient of ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["z", "TI"], "-", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["0", "TR"]]}], ")"}], 
   RowBox[{"-", "1"}]]], "InlineFormula"],
 " in the Laurent expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10282],

Cell[TextData[{
 Cell[BoxData["NResidue"], "InlineFormula"],
 " numerically integrates around a small circle centered at the point ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["z", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " in the complex plane. ",
 Cell[BoxData["NResidue"], "InlineFormula"],
 " will return an incorrect result when the punctured disk is not analytic."
}], "Notes",
 CellID->1848],

Cell[TextData[{
 Cell[BoxData["NResidue"], "InlineFormula"],
 " is unable to recognize small numbers that should in fact be zero. ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " is often needed to eliminate these spurious residuals."
}], "Notes",
 CellID->20366],

Cell[TextData[{
 "Although ",
 Cell[BoxData[
  ButtonBox["Residue",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Residue"]], "InlineFormula"],
 " usually needs to be able to evaluate power series at a point, ",
 Cell[BoxData["NResidue"], "InlineFormula"],
 " can find residues even if the power series cannot be computed."
}], "Notes",
 CellID->23290],

Cell[TextData[{
 Cell[BoxData["NResidue"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->3227],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Radius",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalCalculus/ref/Radius"], 
    RowBox[{"1", "/", "100"}], Cell[
    "radius of contour on which integral is evaluated", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], "Trapezoidal", Cell[
    "integration method to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->14458]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->116522021],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->471519599],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->155925627],

Cell[TextData[{
 "Residue of the function ",
 Cell[BoxData[
  FractionBox["1", 
   StyleBox["x", "TI"]]]],
 " about the origin:"
}], "ExampleText",
 CellID->7730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NResidue", "[", 
  RowBox[{
   FractionBox["1", "x"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4075],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8803]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26194],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->324530909],

Cell[TextData[{
 Cell[BoxData["NResidue"], "InlineFormula"],
 " can find residues of functions with essential singularities:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->22488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     FractionBox["1", 
      RowBox[{"10", "x"}]], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28664],

Cell[BoxData["0.10000000000000181`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26673]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " is unable to handle essential singularities, ",
 Cell[BoxData[
  ButtonBox["Residue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Residue"]], "InlineFormula"],
 " returns unevaluated:"
}], "ExampleText",
 CellID->27048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["1", 
     RowBox[{"10", "x"}]], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25358],

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["1", 
     RowBox[{"10", " ", "x"}]], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Output",
 ImageSize->{181, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2280]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32487],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->969307522],

Cell[TextData[{
 Cell[BoxData["NResidue"], "InlineFormula"],
 " allows for some error in the location of the pole:"
}], "ExampleText",
 CellID->19764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1.7", "-", 
      RowBox[{"2.7", "z"}], "+", 
      SuperscriptBox["z", "2"]}]], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "1."}], "}"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23713],

Cell[BoxData[
 RowBox[{"-", "1.4285714285714246`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24013]
}, Open  ]],

Cell[TextData[{
 "Due to machine-precision arithmetic, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["z", "TI"], "\[Rule]", "1."}]], "InlineFormula"],
 " is not a pole:"
}], "ExampleText",
 CellID->12452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1.7", "-", 
    RowBox[{"2.7", "z"}], "+", 
    SuperscriptBox["z", "2"]}]], "/.", 
  RowBox[{"z", "->", "1."}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18170],

Cell[BoxData[
 RowBox[{"-", "4.503599627370496`*^15"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24978]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["Residue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Residue"]], "InlineFormula"],
 ", the error in the location of the pole yields a result of zero:"
}], "ExampleText",
 CellID->6766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1.7", "-", 
     RowBox[{"2.7", "z"}], "+", 
     SuperscriptBox["z", "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1."}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12704],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->21416]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28649],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->5409682],

Cell[TextData[{
 Cell[BoxData["NResidue"], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->10377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Exp", "[", 
       FractionBox["1", "x"], "]"}], ",", 
      RowBox[{"Sin", "[", 
       FractionBox["1", "x"], "]"}], ",", 
      RowBox[{"Cos", "[", 
       FractionBox["1", "x"], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}], ",", 
    RowBox[{"Radius", "->", "1"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22837],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvi\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"NIntegrate failed to converge to \
prescribed accuracy after \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(9\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" iterated refinements \
in \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(NumericalMath`NResidue`Private`t$895\\)\
\\!\\(\\*StyleBox[\\\"\\\\\\\" in the region \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\
\\({\\({0.`, \
6.283185307179586`}\\)}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\".\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NIntegrate/ncvi\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->28537],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9999999999999999`", ",", "1.`", ",", "0"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19459]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20432],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Radius",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20955],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->31382167],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Radius",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Radius"]], "InlineFormula"],
 " to shrink the radius of the contour of integration to isolate a single \
pole:"
}], "ExampleText",
 CellID->22105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "x"], "+", 
     FractionBox["1", 
      RowBox[{"x", "+", "0.005"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20526],

Cell[BoxData["2.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5937]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "x"], "+", 
     FractionBox["1", 
      RowBox[{"x", "+", ".005"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}], ",", 
    RowBox[{"Radius", "->", ".001"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1366],

Cell[BoxData["0.9999999999999999`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23155],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->173747074],

Cell["\<\
Increase the radius to improve convergence of the integration if no other \
poles are nearby:\
\>", "ExampleText",
 CellID->19290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     FractionBox["1", "x"], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6446],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvi\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"NIntegrate failed to converge to \
prescribed accuracy after \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(9\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" iterated refinements \
in \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(NumericalMath`NResidue`Private`t$1085\\)\\!\\(\\*\
StyleBox[\\\"\\\\\\\" in the region \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\({\\({0.`, 6.283185307179586`}\\)}\\)\\!\\(\\*StyleBox[\\\
\"\\\\\\\".\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NIntegrate/ncvi\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->18182],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.0220108153499`*^25"}], "+", 
  RowBox[{"7.32409526702564`*^23", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19635]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     FractionBox["1", "x"], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}], ",", 
    RowBox[{"Radius", "->", "1"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20093],

Cell[BoxData["0.9999999999999999`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3936]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15846],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->782532174],

Cell[TextData[{
 Cell[BoxData["NResidue"], "InlineFormula"],
 " accepts options for ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", which are sometimes necessary to get an accurate result:"
}], "ExampleText",
 CellID->867371608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      FractionBox["1", "x"], "]"}], "+", 
     RowBox[{"Exp", "[", 
      FractionBox["1", 
       RowBox[{"x", "-", 
        FractionBox["1", "100"]}]], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}], ",", 
    RowBox[{"Radius", "->", 
     FractionBox["1", "200"]}], ",", 
    RowBox[{"MaxRecursion", "->", "10"}], ",", 
    RowBox[{"WorkingPrecision", "->", "100"}], ",", 
    RowBox[{"PrecisionGoal", "->", "10"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5456],

Cell[BoxData["1.00000000000000000000000000202`16.789547831113023"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24403]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19714],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->80968281],

Cell[TextData[{
 "Use ",
 Cell[BoxData["NResidue"], "InlineFormula"],
 " to evaluate derivatives of a function evaluated at a point:"
}], "ExampleText",
 CellID->25599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Derivative", "[", "10", "]"}], "[", "Zeta", "]"}], "[", "0", 
   "]"}], "//", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "30"}], "}"}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30041],

Cell[BoxData[
 RowBox[{"-", 
  "3.62879999945676588422029152776801105687968991`30.*^6"}]], "Output",
 ImageSize->{260, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6925]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"10", "!"}], 
  RowBox[{"NResidue", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Zeta", "[", "x", "]"}], 
     SuperscriptBox["x", "11"]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}], ",", 
    RowBox[{"Radius", "->", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"WorkingPrecision", "->", "30"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18074],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "3.62879999945676588422029152776790352579932644`27.023862259044414*^6"}\
], "+", 
  RowBox[{"0``20.464099226232637", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12324]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10344],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->13713554],

Cell["Residues of numerical functions:", "ExampleText",
 CellID->29863],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      FractionBox[
       SuperscriptBox["t", "2"], "a"], "]"}], 
     FractionBox["1", 
      RowBox[{"10", "+", 
       RowBox[{"a", " ", "t"}]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "0"}], "}"}], ",", 
    RowBox[{"Radius", "->", "1"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29276],

Cell[BoxData["0.03251817677562594`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10597]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14334],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->398287419],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NSeries"]], "InlineFormula"],
 " can also compute residues of numerical functions:"
}], "ExampleText",
 CellID->16647],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Exp", "[", 
   FractionBox["1", "x"], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NResidue", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}], ",", 
    RowBox[{"Radius", "->", "1"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20043],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3244]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NSeries"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->13592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesCoefficient", "[", 
   RowBox[{
    RowBox[{"NSeries", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"-", "1"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17269],

Cell[BoxData["0.9999999999999997`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->5175]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31139],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->42500282],

Cell[TextData[{
 Cell[BoxData["NResidue"], "InlineFormula"],
 " will return an incorrect result when the integration contour contains \
branch cuts:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->24696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"x", "-", "1"}]], 
    SqrtBox[
     RowBox[{"x", "+", "1"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19481],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NResidue", "[", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"x", "-", "1"}]], 
    SqrtBox[
     RowBox[{"x", "+", "1"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}], ",", 
   RowBox[{"Radius", "->", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30268],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.5000000000009585`"}], "-", 
  RowBox[{"5.205541047616603`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16713]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25434],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NSeries"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Residue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Residue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ND",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/ND"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1770]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32071],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->30106]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NResidue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 12.1244164}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "NResidue[expr, {z, z_0}] numerically finds the residue of expr near the \
point z = z_0.", "synonyms" -> {}, "title" -> "NResidue", "type" -> "Symbol", 
    "uri" -> "NumericalCalculus/ref/NResidue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6419, 218, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->116522021]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29926, 1163}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1549, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2172, 65, 46, 1, 70, "ObjectName",
 CellID->19659],
Cell[2221, 68, 864, 29, 70, "Usage",
 CellID->24540]
}, Open  ]],
Cell[CellGroupData[{
Cell[3122, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3600, 119, 237, 9, 70, "Notes",
 CellID->29368],
Cell[3840, 130, 416, 16, 70, "Notes",
 CellID->10282],
Cell[4259, 148, 411, 11, 70, "Notes",
 CellID->1848],
Cell[4673, 161, 339, 9, 70, "Notes",
 CellID->20366],
Cell[5015, 172, 363, 10, 70, "Notes",
 CellID->23290],
Cell[5381, 184, 296, 9, 70, "Notes",
 CellID->3227],
Cell[5680, 195, 702, 18, 70, "3ColumnTableMod",
 CellID->14458]
}, Closed]],
Cell[CellGroupData[{
Cell[6419, 218, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->116522021],
Cell[CellGroupData[{
Cell[6804, 232, 148, 5, 70, "ExampleSection",
 CellID->471519599],
Cell[6955, 239, 142, 4, 70, "Input",
 CellID->155925627],
Cell[7100, 245, 162, 7, 70, "ExampleText",
 CellID->7730],
Cell[CellGroupData[{
Cell[7287, 256, 193, 7, 42, "Input",
 CellID->4075],
Cell[7483, 265, 155, 5, 36, "Output",
 CellID->8803]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7687, 276, 216, 7, 70, "ExampleSection",
 CellID->26194],
Cell[7906, 285, 142, 4, 70, "Input",
 CellID->324530909],
Cell[8051, 291, 208, 5, 70, "ExampleText",
 CellID->22488],
Cell[CellGroupData[{
Cell[8284, 300, 281, 10, 70, "Input",
 CellID->28664],
Cell[8568, 312, 173, 5, 36, "Output",
 CellID->26673]
}, Open  ]],
Cell[8756, 320, 369, 13, 70, "ExampleText",
 CellID->27048],
Cell[CellGroupData[{
Cell[9150, 337, 247, 9, 70, "Input",
 CellID->25358],
Cell[9400, 348, 340, 12, 52, "Output",
 CellID->2280]
}, Open  ]],
Cell[9755, 363, 121, 3, 70, "ExampleDelimiter",
 CellID->32487],
Cell[9879, 368, 142, 4, 70, "Input",
 CellID->969307522],
Cell[10024, 374, 150, 4, 70, "ExampleText",
 CellID->19764],
Cell[CellGroupData[{
Cell[10199, 382, 316, 11, 70, "Input",
 CellID->23713],
Cell[10518, 395, 189, 6, 36, "Output",
 CellID->24013]
}, Open  ]],
Cell[10722, 404, 199, 7, 70, "ExampleText",
 CellID->12452],
Cell[CellGroupData[{
Cell[10946, 415, 219, 8, 70, "Input",
 CellID->18170],
Cell[11168, 425, 192, 6, 36, "Output",
 CellID->24978]
}, Open  ]],
Cell[11375, 434, 244, 8, 70, "ExampleText",
 CellID->6766],
Cell[CellGroupData[{
Cell[11644, 446, 281, 10, 70, "Input",
 CellID->12704],
Cell[11928, 458, 154, 5, 36, "Output",
 CellID->21416]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12131, 469, 239, 7, 70, "ExampleSection",
 CellID->28649],
Cell[12373, 478, 140, 4, 70, "Input",
 CellID->5409682],
Cell[12516, 484, 132, 4, 70, "ExampleText",
 CellID->10377],
Cell[CellGroupData[{
Cell[12673, 492, 484, 16, 70, "Input",
 CellID->22837],
Cell[13160, 510, 735, 14, 70, "Message",
 CellID->28537],
Cell[13898, 526, 229, 7, 36, "Output",
 CellID->19459]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14176, 539, 218, 7, 70, "ExampleSection",
 CellID->20432],
Cell[CellGroupData[{
Cell[14419, 550, 223, 7, 70, "ExampleSubsection",
 CellID->20955],
Cell[14645, 559, 141, 4, 70, "Input",
 CellID->31382167],
Cell[14789, 565, 275, 9, 70, "ExampleText",
 CellID->22105],
Cell[CellGroupData[{
Cell[15089, 578, 306, 11, 70, "Input",
 CellID->20526],
Cell[15398, 591, 155, 5, 36, "Output",
 CellID->5937]
}, Open  ]],
Cell[CellGroupData[{
Cell[15590, 601, 348, 12, 70, "Input",
 CellID->1366],
Cell[15941, 615, 171, 5, 36, "Output",
 CellID->3914]
}, Open  ]],
Cell[16127, 623, 121, 3, 70, "ExampleDelimiter",
 CellID->23155],
Cell[16251, 628, 142, 4, 70, "Input",
 CellID->173747074],
Cell[16396, 634, 140, 4, 70, "ExampleText",
 CellID->19290],
Cell[CellGroupData[{
Cell[16561, 642, 257, 9, 70, "Input",
 CellID->6446],
Cell[16821, 653, 736, 14, 70, "Message",
 CellID->18182],
Cell[17560, 669, 269, 8, 36, "Output",
 CellID->19635]
}, Open  ]],
Cell[CellGroupData[{
Cell[17866, 682, 299, 10, 70, "Input",
 CellID->20093],
Cell[18168, 694, 171, 5, 36, "Output",
 CellID->3936]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18388, 705, 233, 7, 70, "ExampleSubsection",
 CellID->15846],
Cell[18624, 714, 142, 4, 70, "Input",
 CellID->782532174],
Cell[18769, 720, 310, 9, 70, "ExampleText",
 CellID->867371608],
Cell[CellGroupData[{
Cell[19104, 733, 616, 19, 70, "Input",
 CellID->5456],
Cell[19723, 754, 204, 5, 36, "Output",
 CellID->24403]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19988, 766, 223, 7, 70, "ExampleSection",
 CellID->19714],
Cell[20214, 775, 141, 4, 70, "Input",
 CellID->80968281],
Cell[20358, 781, 168, 5, 70, "ExampleText",
 CellID->25599],
Cell[CellGroupData[{
Cell[20551, 790, 320, 12, 70, "Input",
 CellID->30041],
Cell[20874, 804, 226, 7, 36, "Output",
 CellID->6925]
}, Open  ]],
Cell[CellGroupData[{
Cell[21137, 816, 414, 14, 70, "Input",
 CellID->18074],
Cell[21554, 832, 322, 10, 36, "Output",
 CellID->12324]
}, Open  ]],
Cell[21891, 845, 121, 3, 70, "ExampleDelimiter",
 CellID->10344],
Cell[22015, 850, 141, 4, 70, "Input",
 CellID->13713554],
Cell[22159, 856, 71, 1, 70, "ExampleText",
 CellID->29863],
Cell[22233, 859, 458, 16, 70, "Input",
 CellID->13749],
Cell[CellGroupData[{
Cell[22716, 879, 273, 9, 70, "Input",
 CellID->29276],
Cell[22992, 890, 173, 5, 36, "Output",
 CellID->10597]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23214, 901, 233, 7, 70, "ExampleSection",
 CellID->14334],
Cell[23450, 910, 142, 4, 70, "Input",
 CellID->398287419],
Cell[23595, 916, 239, 7, 70, "ExampleText",
 CellID->16647],
Cell[23837, 925, 201, 7, 70, "Input",
 CellID->22426],
Cell[CellGroupData[{
Cell[24063, 936, 273, 9, 70, "Input",
 CellID->20043],
Cell[24339, 947, 155, 5, 36, "Output",
 CellID->3244]
}, Open  ]],
Cell[24509, 955, 201, 8, 70, "ExampleText",
 CellID->13592],
Cell[CellGroupData[{
Cell[24735, 967, 339, 11, 70, "Input",
 CellID->17269],
Cell[25077, 980, 171, 5, 36, "Output",
 CellID->5175]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25297, 991, 226, 7, 70, "ExampleSection",
 CellID->31139],
Cell[25526, 1000, 141, 4, 70, "Input",
 CellID->42500282],
Cell[25670, 1006, 232, 6, 70, "ExampleText",
 CellID->24696],
Cell[CellGroupData[{
Cell[25927, 1016, 270, 11, 70, "Input",
 CellID->19481],
Cell[26200, 1029, 154, 5, 36, "Output",
 CellID->14471]
}, Open  ]],
Cell[CellGroupData[{
Cell[26391, 1039, 311, 12, 70, "Input",
 CellID->30268],
Cell[26705, 1053, 270, 8, 36, "Output",
 CellID->16713]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27036, 1068, 311, 9, 70, "SeeAlsoSection",
 CellID->25434],
Cell[27350, 1079, 974, 35, 70, "SeeAlso",
 CellID->1770]
}, Open  ]],
Cell[CellGroupData[{
Cell[28361, 1119, 314, 9, 70, "TutorialsSection",
 CellID->32071],
Cell[28678, 1130, 175, 4, 70, "Tutorials",
 CellID->30106]
}, Open  ]],
Cell[28868, 1137, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

