(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17353,        568]
NotebookOptionsPosition[     14194,        460]
NotebookOutlinePosition[     15475,        496]
CellTagsIndexPosition[     15390,        491]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NSeries" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/ref/NSeries"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NSeries\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Radius", "ObjectName",
 CellID->15165],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Radius"], "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["NSeries",
       BaseStyle->"Link",
       ButtonData->"paclet:NumericalCalculus/ref/NSeries"]], "InlineFormula"],
     
     " that specifies the radius of the circle around which the function is \
to be sampled."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4521]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Valid settings are positive numbers. The default setting is 1.\
\>", "Notes",
 CellID->30127]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->612170765],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->99686633],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->572885637],

Cell[TextData[{
 "Use ",
 Cell[BoxData["Radius"], "InlineFormula"],
 " to pick the annulus within which the Laurent series produced by ",
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NSeries"]], "InlineFormula"],
 " will converge:"
}], "ExampleText",
 CellID->23821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}]}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"Radius", "->", "2"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17264],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["0.5000000528713976`", 
     SuperscriptBox["x", "10"]]}], "+", 
   FractionBox["0.5000000176238019`", 
    SuperscriptBox["x", "9"]], "-", 
   FractionBox["0.500000005874598`", 
    SuperscriptBox["x", "8"]], "+", 
   FractionBox["0.5000000019581992`", 
    SuperscriptBox["x", "7"]], "-", 
   FractionBox["0.500000000652733`", 
    SuperscriptBox["x", "6"]], "+", 
   FractionBox["0.500000000217578`", 
    SuperscriptBox["x", "5"]], "-", 
   FractionBox["0.5000000000725257`", 
    SuperscriptBox["x", "4"]], "+", 
   FractionBox["0.5000000000241752`", 
    SuperscriptBox["x", "3"]], "-", 
   FractionBox["0.5000000000080583`", 
    SuperscriptBox["x", "2"]], "+", 
   FractionBox["0.5000000000026861`", "x"], "-", "0.16666666666756208`", "+", 
   
   RowBox[{"0.05555555555585402`", " ", "x"}], "-", 
   RowBox[{"0.018518518518618`", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"0.006172839506206`", " ", 
    SuperscriptBox["x", "3"]}], "-", 
   RowBox[{"0.0020576131687353332`", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"0.000685871056245111`", " ", 
    SuperscriptBox["x", "5"]}], "-", 
   RowBox[{"0.00022862368541503686`", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"0.00007620789513834563`", " ", 
    SuperscriptBox["x", "7"]}], "-", 
   RowBox[{"0.000025402631712781882`", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{"8.467543904260654`*^-6", " ", 
    SuperscriptBox["x", "9"]}], "-", 
   RowBox[{"2.822514634753572`*^-6", " ", 
    SuperscriptBox["x", "10"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[x, 0, {}, -10, 11, 1],
    Editable->False]}],
  SeriesData[
  x, 0, {-0.500000052871398, 0.500000017623802, -0.500000005874598, 
   0.500000001958199, -0.500000000652733, 
   0.500000000217578, -0.500000000072526, 
   0.500000000024175, -0.500000000008058, 
   0.500000000002686, -0.166666666667562, 
   0.055555555555854, -0.018518518518618, 
   0.006172839506206, -0.00205761316873533, 
   0.000685871056245111, -0.000228623685415037, 
   0.0000762078951383456, -0.0000254026317127819, 
   8.46754390426065*^-6, -2.82251463475357*^-6}, -10, 11, 1],
  Editable->False]], "Output",
 ImageSize->{541, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6003]
}, Open  ]],

Cell[TextData[{
 "Laurent series for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[GreaterEqual]", "3"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}]}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"Radius", "->", "5"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14722],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["9841.000000000093`", 
    SuperscriptBox["x", "10"]], "-", 
   FractionBox["3280.0000000000264`", 
    SuperscriptBox["x", "9"]], "+", 
   FractionBox["1093.0000000000075`", 
    SuperscriptBox["x", "8"]], "-", 
   FractionBox["364.0000000000024`", 
    SuperscriptBox["x", "7"]], "+", 
   FractionBox["121.00000000000078`", 
    SuperscriptBox["x", "6"]], "-", 
   FractionBox["40.00000000000025`", 
    SuperscriptBox["x", "5"]], "+", 
   FractionBox["13.000000000000085`", 
    SuperscriptBox["x", "4"]], "-", 
   FractionBox["4.0000000000000275`", 
    SuperscriptBox["x", "3"]], "+", 
   FractionBox["1", 
    SuperscriptBox["x", "2"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[x, 0, {}, -10, 11, 1],
    Editable->False]}],
  SeriesData[
  x, 0, {9841.00000000009, -3280.00000000003, 
   1093.00000000001, -364.000000000002, 121.000000000001, -40.0000000000002, 
   13.0000000000001, -4.00000000000003, 1.00000000000001}, -10, 11, 1],
  Editable->False]], "Output",
 ImageSize->{423, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25316]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5854],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->162147978],

Cell[TextData[{
 "Changing ",
 Cell[BoxData["Radius"], "InlineFormula"],
 " can improve the accuracy in the result returned by ",
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NSeries"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "-", "x"}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"Radius", "->", 
     FractionBox["7", "8"]}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26425],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW1tPE0EUXrptocgdYjTEiA8KXh4Eog/qm8ZLDYmAqFBQCTGBB6NB/oW+
+Oa/4VV/gv6ZunNrZ7+dvZTuzu7SQ9LO7cyZ7+zMmZk9X1nbPzn89Hn/5Ohg
f+HZ8f7Xw6ODbwtPvxx7Ve6Q4wz9dRzn4yXHy7e9HP+wv3/eR2S7uV/ep+IJ
XJDpqq/FcVXfNpfQy8tccsT7rnmVruxf81ImVIXUlXIVWa5L+YpMx0B7jfSm
qnca9NalHNPnVDv10KtqnPNRqHV16Zquy5G6ktbieDUoV/1ovcw4SAwTNsKW
IbYZU49YvZWAHhzJ7FmN1C2sGyxU+w7rjM+aEAwWgmmJINm6Vp6I2mytZjZ+
1emedhPQnv1zJARFRDAL7eVYzWYpuKE58ecjISNkaSAr+10nXEp/x7lIOAhH
BI7L4br6fG+2ZdGYRIX+bGt83OGmBhxH3vPBInkqVqRLTyTSyeOAvpU/6hVu
cOlGu/seY4pSKd9SUSx9RthYUz32x5vmpOXxJw1PsGf8w/DENSwqQqdHaPE0
xVkUM/EYLHsJUi8M7RUlF4LoTuKRmaa1iBHDEPQ/sl7bhBHiyv0jeCJtb8q5
w6fe1NpN58QtWa/eRJa4VtZkit2H584alR8BPGlFn/FOW/Roedn1XuGrIL84
PZaLFMHFNV4kbEWOfBO2dLCZfTP7CC/rlW9seTh3BPnH1wlBF4EtT9Cjw/nG
pRu5I8g/Nk8IgghseYJZyr5fJI1Ax93VKGpPyLJAlq8/5hWXxMg3/mZs0JkA
wuHHwWNiA+cl8zmNq2LKeXll3qzFuLS/KOzR2RiPXhmG+R7lTRyXTUaj3/7I
yCzy9A9obUKZcQnsQMd4+3Vjb5R6DmOq6LyIvv82tCJrUIF6lk2G3ITF7djN
qsKj/Dfb/v34HZTfxrT/5FoY5+C/De0EarYTyOyC9ru8+rYsqdYWlN8H9Cwn
6vdBpishNqBPbxolmMBGoEVFC7eMLa72JFeM86BzQ2yFbEI7YnsV074eoZ9l
34Y8w1WQY7NYVXOn1begvGWcyWVtBnTrdqE3av/e6a3XqnncAW0tKP/o9GaV
ewaLoiwRY7Os8Bjsj/JxZbStkqFWESs6PT11xF+TfbGyJsUOqXqMnJuTnMKX
5TPKRivLJmFZGSNvOsPi2LthmVZADrmE2Yz1z5H+SP38LiLebwK3QctcauAU
MtTgOtbKM+fAhlmygWxIyYYoz86eB6sb9hoTY6CXp0uE1bzbENZBwsp/kWTN
wxS/lozfKoqvpYva1uog1GVFbdcnzVLBs1rd3tUtHK2y5Y1p4bW1NghvOfAW
wet0qc7OYUaj6ZoqIeZ8dwvCXGTM/D+XCuaJEbsMnuQBqXx3wjQtMccUyBKy
JA1LRLRHRev1qD2mehRZ/VbT1drVXbwmn0+a+uYGTJ+YFTZH4QzL1bafiWxB
OY7hxvIDrnWBffvucHuBmiSMd7DmIU+utf0cNXLXKn10Bukgdh/PpvnCekBS
xWhfB1qSseXREkr7fePMcc8M+d9K5Lfj+PE4fh13hY2Y/vd4uhSBcKdtZquj
uO9kmrehBzKUOMK27yn3ojmOaceRBfbFkDlROEyMqqutWqGFNQmPfgPy/TK2
jQy1inVSfgY+y2eUjVaWTcLAh509xMCfH/1OyK2uXIwjMfBkA9mQzLOLyWgS
A09Yy4SV7xLWPIwY+LKywoTaHmq7PkkMPOElvMXwOmLgCTNh5jtHwTyRGHgm
dX7YXrKkeJaIaI86n4mBL44+MVGCTXGG/gOdxgy3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{473, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->765106311]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "-", "x"}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"Radius", "->", 
     FractionBox["1", "5"]}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15818],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV8FSwjAQDS21KqWAIOCNi6KMB8eD/oGe/IgO4wwcHB3ED9Efrkmb6PLY
kLYgMzJTkt19u9192YTwlCxnzy/Jcj5NRo+L5G02n76PHl4XUuXXhKh9CiFa
QyHnqZxlj/p8ySeffsjHk+qGHuMVi/CNR5ohqBxlSOHng/r4WlRxDgFd13pP
j6HDHu3ZHsivgOR/APgmE68M3hW/bD5l8R3AK7sSg6yYHz141dk190FrW3OI
XQjB8fb3COxGU1G45hkzPFbzLP7O6tlW9zzhOAxonwimP7y1OAEg+A5SZ0tA
ujYEOaooY73N9Hd3Gvwmu83fFd9l72h7MVbpnnZziWtuODmy6LmO3oXeVnuL
8S+Cs8Ur+t6iuC7o97FG//ekjNY8XCek28P9jvJZlffY7wnYS1d/eWOQuyXl
PsRvlLQPtvR32c/sbG55G7lJ85tNX3sNiUxxbZANg7juPZDxJoX2onGVHOjq
qD62M4O38RWmjqVQy9CGr1vwGYKMjNBK1DvbOs6pRc8xugmPPRXTOCFUTHzN
PZX+T8FdhSzmTNw7KlaZ1pnMzqGCS7CPGbtncJZKritljJnhGpkuNxlMNmSq
phdcZVtlfMdkROVByncLZsZxSmXWvlOuMUOOe59wPdbyFVOJsXPn1kTrfTKq
zfsNoWzgHg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{401, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->854867]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22710],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NSeries"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->20488]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9964],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->440]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Radius - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 12.9525626}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "Radius is an option to NSeries that specifies the radius of the circle \
around which the function is to be sampled.", "synonyms" -> {}, "title" -> 
    "Radius", "type" -> "Symbol", "uri" -> "NumericalCalculus/ref/Radius"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3117, 110, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->612170765]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15247, 484}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1230, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1853, 60, 44, 1, 70, "ObjectName",
 CellID->15165],
Cell[1900, 63, 562, 17, 70, "Usage",
 CellID->4521]
}, Open  ]],
Cell[CellGroupData[{
Cell[2499, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2977, 102, 103, 3, 70, "Notes",
 CellID->30127]
}, Closed]],
Cell[CellGroupData[{
Cell[3117, 110, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->612170765],
Cell[CellGroupData[{
Cell[3502, 124, 147, 5, 70, "ExampleSection",
 CellID->99686633],
Cell[3652, 131, 142, 4, 70, "Input",
 CellID->572885637],
Cell[3797, 137, 326, 10, 70, "ExampleText",
 CellID->23821],
Cell[CellGroupData[{
Cell[4148, 151, 407, 14, 44, "Input",
 CellID->17264],
Cell[4558, 167, 2416, 64, 86, "Output",
 CellID->6003]
}, Open  ]],
Cell[6989, 234, 173, 7, 70, "ExampleText",
 CellID->9754],
Cell[CellGroupData[{
Cell[7187, 245, 407, 14, 70, "Input",
 CellID->14722],
Cell[7597, 261, 1223, 35, 52, "Output",
 CellID->25316]
}, Open  ]],
Cell[8835, 299, 120, 3, 70, "ExampleDelimiter",
 CellID->5854],
Cell[8958, 304, 142, 4, 70, "Input",
 CellID->162147978],
Cell[9103, 310, 303, 10, 70, "ExampleText",
 CellID->6586],
Cell[CellGroupData[{
Cell[9431, 324, 326, 11, 42, "Input",
 CellID->26425],
Cell[9760, 337, 2021, 37, 117, "Output",
 Evaluatable->False,
 CellID->765106311]
}, Open  ]],
Cell[CellGroupData[{
Cell[11818, 379, 326, 11, 42, "Input",
 CellID->15818],
Cell[12147, 392, 892, 19, 36, "Output",
 Evaluatable->False,
 CellID->854867]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13100, 418, 311, 9, 70, "SeeAlsoSection",
 CellID->22710],
Cell[13414, 429, 212, 6, 70, "SeeAlso",
 CellID->20488]
}, Open  ]],
Cell[CellGroupData[{
Cell[13663, 440, 313, 9, 70, "TutorialsSection",
 CellID->9964],
Cell[13979, 451, 173, 4, 70, "Tutorials",
 CellID->440]
}, Open  ]],
Cell[14167, 458, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

