(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11889,        402]
NotebookOptionsPosition[      9556,        327]
NotebookOutlinePosition[     10622,        356]
CellTagsIndexPosition[     10579,        353]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NLimit" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NLimit"], 
          "ND" :> Documentation`HelpLookup[
           "paclet:NumericalCalculus/ref/ND"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NLimit\"\>", 
       2->"\<\"ND\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"], 
          "Graphics Transformations" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsTransformations"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Geometric Transforms\"\>", 
       2->"\<\"Graphics Transformations\"\>", 
       3->"\<\"Symbolic Graphics Language\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Scale", "ObjectName",
 CellID->14996],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Scale",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["NLimit",
       BaseStyle->"Link",
       ButtonData->"paclet:NumericalCalculus/ref/NLimit"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["ND",
       BaseStyle->"Link",
       ButtonData->"paclet:NumericalCalculus/ref/ND"]], "InlineFormula"],
     " that specifies the scale at which variations are expected."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16873]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are positive numbers. The default setting is ",
 Cell[BoxData["1"], "InlineFormula"],
 "."
}], "Notes",
 CellID->7148],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["NLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NLimit"]], "InlineFormula"],
 ", the setting for ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " specifies the initial stepsize to use in the sequence of steps that \
approach the limit point."
}], "Notes",
 CellID->2510],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["ND",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/ND"]], "InlineFormula"],
 " with the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"]}]], "InlineFormula"],
 ", the setting for ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " specifies the integration contour radius to use when applying Cauchy's \
integral formula."
}], "Notes",
 CellID->10396],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["ND",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/ND"]], "InlineFormula"],
 " with the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["EulerSum",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/EulerSum"]}]], 
  "InlineFormula"],
 ", the setting for ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " specifies the initial stepsize to use during Richardson extrapolation. The \
value of the setting may be complex, indicating the direction of approach to \
the limit point. With the default setting the direction of approach is from \
the right."
}], "Notes",
 CellID->15941]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23355],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ND",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/ND"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15948]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25791],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->16866]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Scale",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Scale"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->86119973],

Cell[TextData[ButtonBox["Graphics Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsTransformations"]], "MoreAbout",
 CellID->76414251],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->75327660],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->131476020]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Scale - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 13.1713182}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "Scale is an option to NLimit and ND that specifies the scale at which \
variations are expected.", "synonyms" -> {}, "title" -> "Scale", "type" -> 
    "Symbol", "uri" -> "NumericalCalculus/ref/Scale"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2444, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3067, 87, 43, 1, 70, "ObjectName",
 CellID->14996],
Cell[3113, 90, 765, 23, 70, "Usage",
 CellID->16873]
}, Open  ]],
Cell[CellGroupData[{
Cell[3915, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4393, 135, 151, 5, 70, "Notes",
 CellID->7148],
Cell[4547, 142, 421, 14, 70, "Notes",
 CellID->2510],
Cell[4971, 158, 661, 23, 70, "Notes",
 CellID->10396],
Cell[5635, 183, 832, 26, 70, "Notes",
 CellID->15941]
}, Closed]],
Cell[CellGroupData[{
Cell[6504, 214, 311, 9, 70, "SeeAlsoSection",
 CellID->23355],
Cell[6818, 225, 471, 17, 70, "SeeAlso",
 CellID->15948]
}, Open  ]],
Cell[CellGroupData[{
Cell[7326, 247, 314, 9, 70, "TutorialsSection",
 CellID->25791],
Cell[7643, 258, 175, 4, 70, "Tutorials",
 CellID->16866]
}, Open  ]],
Cell[CellGroupData[{
Cell[7855, 267, 305, 8, 70, "RelatedLinksSection"],
Cell[8163, 277, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8555, 294, 299, 8, 70, "MoreAboutSection"],
Cell[8857, 304, 150, 3, 70, "MoreAbout",
 CellID->86119973],
Cell[9010, 309, 158, 3, 70, "MoreAbout",
 CellID->76414251],
Cell[9171, 314, 161, 3, 70, "MoreAbout",
 CellID->75327660],
Cell[9335, 319, 179, 3, 70, "MoreAbout",
 CellID->131476020]
}, Open  ]],
Cell[9529, 325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

