(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13167,        459]
NotebookOptionsPosition[      8950,        344]
NotebookOutlinePosition[     11166,        390]
CellTagsIndexPosition[     11123,        387]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Numerical Differential Equation Analysis Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Quadrature Weights and Errors", "GuideFunctionsSubsection",
 CellID->371649741],

Cell[TextData[{
 Cell[TextData[ButtonBox["NewtonCotesWeights",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesWeights"]], 
  "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NewtonCotesError",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Newton\[Dash]Cotes approximation formula "
}], "GuideText",
 CellID->672837728],

Cell[TextData[{
 Cell[TextData[ButtonBox["GaussianQuadratureWeights",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["GaussianQuadratureError",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/GaussianQuadratureError"]\
], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Gaussian formula"
}], "GuideText",
 CellID->382542639]
}, Open  ]],

Cell[CellGroupData[{

Cell["Runge\[Dash]Kutta Methods", "GuideFunctionsSubsection",
 CellID->415471382],

Cell[TextData[{
 Cell[TextData[ButtonBox["RungeKuttaOrderConditions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list equations for Runge\[Dash]Kutta methods"
}], "GuideText",
 CellID->800053475],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherPrincipalError",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPrincipalError"]],
   "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " calculate principal error"
}], "GuideText",
 CellID->23199783],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherQuadratureConditions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherQuadratureConditions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give quadrature conditions"
}], "GuideText",
 CellID->682531953],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherColumnConditions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherColumnConditions"]\
], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ButcherRowConditions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowConditions"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give simplifying conditions"
}], "GuideText",
 CellID->552420047]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tree Functions", "GuideFunctionsSubsection",
 CellID->49660],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherPlot",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot order condition trees"
}], "GuideText",
 CellID->205617298],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherTreeQ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test for valid syntax"
}], "GuideText",
 CellID->525456729],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherTrees",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTrees"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " trees for Runge\[Dash]Kutta method "
}], "GuideText",
 CellID->77384629],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherTreeSimplify",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeSimplify"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " trees not reduced by assumptions"
}], "GuideText",
 CellID->321098257],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherTreeCount",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeCount"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " number of trees"
}], "GuideText",
 CellID->140784481],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherHeight",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherHeight"]], 
  "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ButcherWidth",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherWidth"]], 
  "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ButcherOrder",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherOrder"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " characteristics of the tree"
}], "GuideText",
 CellID->319121398],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherAlpha",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherAlpha"]], 
  "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ButcherBeta",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBeta"]], 
  "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ButcherBetaBar",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBetaBar"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " number of ways of labeling the tree"
}], "GuideText",
 CellID->125136892],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherGamma",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherGamma"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " density of the tree"
}], "GuideText",
 CellID->542083525],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPhi"]],
   "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " weight of the tree"
}], "GuideText",
 CellID->32282255],

Cell[TextData[{
 Cell[TextData[ButtonBox["ButcherSigma",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSigma"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "order of the symmetry group"
}], "GuideText",
 CellID->585294537]
}, Open  ]],

Cell[CellGroupData[{

Cell["Global Settings", "GuideFunctionsSubsection",
 CellID->563756503],

Cell[TextData[{
 Cell[TextData[ButtonBox["$ContinuousExtension",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/$ContinuousExtension"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "whether to generate conditions for continuous extensions"
}], "GuideText",
 CellID->225476744],

Cell[TextData[{
 Cell[TextData[ButtonBox["$RungeKuttaMethod",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/ref/$RungeKuttaMethod"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " type of method to be generated"
}], "GuideText",
 CellID->224732177]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "GuideTutorial",
 CellID->48340670]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Numerical Evaluation And Precision",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalEvaluationAndPrecision"]], "GuideMoreAbout",
 CellID->494628699]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Differential Equation Analysis Package - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 18.9370908}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Differential Equation Analysis Package Guide", "language" -> 
    "en", "paclet" -> "NumericalDifferentialEquationAnalysis Package", 
    "status" -> "None", "summary" -> 
    "NewtonCotesWeights, NewtonCotesError -- Newton-Cotes approximation \
formula , GaussianQuadratureWeights, GaussianQuadratureError -- Gaussian \
formula, RungeKuttaOrderConditions -- list equations for Runge-Kutta methods, \
ButcherPrincipalError -- calculate principal error, \
ButcherQuadratureConditions -- give quadrature conditions, \
ButcherColumnConditions, ButcherRowConditions -- give simplifying conditions, \
ButcherPlot -- plot order condition trees, ButcherTreeQ -- test for valid \
syntax, ButcherTrees -- trees for Runge-Kutta method , ButcherTreeSimplify -- \
trees not reduced by assumptions, ButcherTreeCount -- number of trees, \
ButcherHeight, ButcherWidth, ButcherOrder -- characteristics of the tree, \
ButcherAlpha, ButcherBeta, ButcherBetaBar -- number of ways of labeling the \
tree, ButcherGamma -- density of the tree, ButcherPhi -- weight of the tree, \
ButcherSigma -- order of the symmetry group, $ContinuousExtension -- whether \
to generate conditions for continuous extensions, $RungeKuttaMethod -- type \
of method to be generated", "synonyms" -> {}, "title" -> 
    "Numerical Differential Equation Analysis Package", "type" -> "Guide", 
    "uri" -> "NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 90, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[712, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[793, 33, 85, 1, 70, "GuideFunctionsSubsection",
 CellID->371649741],
Cell[881, 36, 518, 16, 70, "GuideText",
 CellID->672837728],
Cell[1402, 54, 519, 16, 70, "GuideText",
 CellID->382542639]
}, Open  ]],
Cell[CellGroupData[{
Cell[1958, 75, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->415471382],
Cell[2042, 78, 346, 10, 70, "GuideText",
 CellID->800053475],
Cell[2391, 90, 319, 10, 70, "GuideText",
 CellID->23199783],
Cell[2713, 102, 332, 10, 70, "GuideText",
 CellID->682531953],
Cell[3048, 114, 521, 16, 70, "GuideText",
 CellID->552420047]
}, Open  ]],
Cell[CellGroupData[{
Cell[3606, 135, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->49660],
Cell[3675, 138, 306, 11, 70, "GuideText",
 CellID->205617298],
Cell[3984, 151, 303, 11, 70, "GuideText",
 CellID->525456729],
Cell[4290, 164, 311, 10, 70, "GuideText",
 CellID->77384629],
Cell[4604, 176, 323, 10, 70, "GuideText",
 CellID->321098257],
Cell[4930, 188, 300, 10, 70, "GuideText",
 CellID->140784481],
Cell[5233, 200, 666, 22, 70, "GuideText",
 CellID->319121398],
Cell[5902, 224, 674, 22, 70, "GuideText",
 CellID->125136892],
Cell[6579, 248, 296, 10, 70, "GuideText",
 CellID->542083525],
Cell[6878, 260, 286, 9, 70, "GuideText",
 CellID->32282255],
Cell[7167, 271, 309, 11, 70, "GuideText",
 CellID->585294537]
}, Open  ]],
Cell[CellGroupData[{
Cell[7513, 287, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->563756503],
Cell[7587, 290, 354, 11, 70, "GuideText",
 CellID->225476744],
Cell[7944, 303, 317, 10, 70, "GuideText",
 CellID->224732177]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8310, 319, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8375, 322, 246, 5, 70, "GuideTutorial",
 CellID->48340670]
}, Open  ]],
Cell[CellGroupData[{
Cell[8658, 332, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8723, 335, 185, 4, 70, "GuideMoreAbout",
 CellID->494628699]
}, Open  ]],
Cell[8923, 342, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

