(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7116,        226]
NotebookOptionsPosition[      5234,        173]
NotebookOutlinePosition[      6659,        208]
CellTagsIndexPosition[      6616,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ButcherAlpha" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherAlpha"], 
          "ButcherBetaBar" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBetaBar"]}\
, #, 2]& , Evaluator -> Automatic], {1->"\<\"ButcherAlpha\"\>", 
       2->"\<\"ButcherBetaBar\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButcherBeta", "ObjectName",
 CellID->18529],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherBeta", "[", 
       StyleBox["tree", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of ways of labeling ",
     Cell[BoxData[
      StyleBox["tree", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        ButtonBox["ButcherOrder",
         BaseStyle->"Link",
         ButtonData->
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherOrder"], 
        "[", 
        StyleBox["tree", "TI"], "]"}], "-", "1"}]], "InlineFormula"],
     " distinct labels such that the root is not labeled, but every other \
vertex is labeled.  "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherBeta", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["tree", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of ways of labeling ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " of the vertices of ",
     Cell[BoxData[
      StyleBox["tree", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " distinct labels such that every leaf is labeled and the root is not \
labeled."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13549],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherAlpha",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherAlpha"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherBetaBar",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBetaBar"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21578]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18805],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->28791]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButcherBeta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 19.4839798}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "ButcherBeta[tree] gives the number of ways of labeling tree with \
ButcherOrder[tree] - 1 distinct labels such that the root is not labeled, but \
every other vertex is labeled. ButcherBeta[n, tree] gives the number of ways \
of labeling n of the vertices of tree with n distinct labels such that every \
leaf is labeled and the root is not labeled.", "synonyms" -> {}, "title" -> 
    "ButcherBeta", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/ButcherBeta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1544, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2167, 65, 49, 1, 70, "ObjectName",
 CellID->18529],
Cell[2219, 68, 1470, 44, 70, "Usage",
 CellID->31540]
}, Open  ]],
Cell[CellGroupData[{
Cell[3726, 117, 311, 9, 70, "SeeAlsoSection",
 CellID->13549],
Cell[4040, 128, 559, 19, 70, "SeeAlso",
 CellID->21578]
}, Open  ]],
Cell[CellGroupData[{
Cell[4636, 152, 314, 9, 70, "TutorialsSection",
 CellID->18805],
Cell[4953, 163, 239, 5, 70, "Tutorials",
 CellID->28791]
}, Open  ]],
Cell[5207, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

