(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10070,        324]
NotebookOptionsPosition[      7997,        259]
NotebookOutlinePosition[      9196,        291]
CellTagsIndexPosition[      9153,        288]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TreePlot" :> Documentation`HelpLookup["paclet:ref/TreePlot"], 
          "TreeForm" :> Documentation`HelpLookup["paclet:ref/TreeForm"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"TreePlot\"\>", 
       2->"\<\"TreeForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButcherPlot", "ObjectName",
 CellID->20474],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherPlot", "[", 
       StyleBox["tree", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a plot of ",
     Cell[BoxData[
      StyleBox["tree", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherPlot", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["tree", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["tree", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an array of plots of ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["tree", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["tree", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24773]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->19097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButcherPlotColumns",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotColumns"], 
    
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of columns in an array of plots", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButcherPlotNodeSize",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotNodeSize"],
     "1", Cell["scaling factor for the nodes in the trees", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButcherPlotRootSize",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotRootSize"],
     "1", Cell["scaling factor for highlighting roots", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButcherPlotLabel",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotLabel"], 
    RowBox[{"{", "}"}], Cell["list of plot labels", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->8880]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22955],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreeForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreeForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20666]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23335],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->11072]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->28454074],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "MoreAbout",
 CellID->769483321]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButcherPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 27.1091750}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "ButcherPlot[tree] gives a plot of tree. ButcherPlot[{tree_1, tree_2, \
...}] gives an array of plots of tree_1, tree_2, ...", "synonyms" -> {}, 
    "title" -> "ButcherPlot", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/ButcherPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2109, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2732, 79, 49, 1, 70, "ObjectName",
 CellID->20474],
Cell[2784, 82, 1152, 37, 70, "Usage",
 CellID->24773]
}, Open  ]],
Cell[CellGroupData[{
Cell[3973, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4451, 141, 68, 1, 70, "Notes",
 CellID->19097],
Cell[4522, 144, 1433, 35, 70, "3ColumnTableMod",
 CellID->8880]
}, Closed]],
Cell[CellGroupData[{
Cell[5992, 184, 311, 9, 70, "SeeAlsoSection",
 CellID->22955],
Cell[6306, 195, 451, 17, 70, "SeeAlso",
 CellID->20666]
}, Open  ]],
Cell[CellGroupData[{
Cell[6794, 217, 314, 9, 70, "TutorialsSection",
 CellID->23335],
Cell[7111, 228, 239, 5, 70, "Tutorials",
 CellID->11072]
}, Open  ]],
Cell[CellGroupData[{
Cell[7387, 238, 318, 9, 70, "MoreAboutSection",
 CellID->28454074],
Cell[7708, 249, 247, 5, 70, "MoreAbout",
 CellID->769483321]
}, Open  ]],
Cell[7970, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

