(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8685,        291]
NotebookOptionsPosition[      6577,        227]
NotebookOutlinePosition[      7871,        260]
CellTagsIndexPosition[      7828,        257]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RungeKuttaOrderConditions" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"RungeKuttaOrderConditions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButcherPrincipalError", "ObjectName",
 CellID->144],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherPrincipalError", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the principal error for a method of order ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " stages.  "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherPrincipalError", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the principal error using stage independent \
tensor notation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22290]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The principal error for a method of order ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is a list of the order ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], "+", "1"}]], "InlineFormula"],
 " terms appearing in the Taylor series expansion of the error."
}], "Notes",
 CellID->31339],

Cell["The following option can be given:", "Notes",
 CellID->23154],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"], 
    ButtonBox["$RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/$RungeKuttaMethod"], 
    Cell["type of Runge-Kutta method", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->24604],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["RungeKuttaMethod",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["DiagonallyImplicit",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Explicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Implicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->4623]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2330],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["RungeKuttaOrderConditions",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->29733]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22225],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->20078]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButcherPrincipalError - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 27.6248132}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "ButcherPrincipalError[p, s] gives the principal error for a method of \
order p with s stages. ButcherPrincipalError[p] gives the principal error \
using stage independent tensor notation.", "synonyms" -> {}, "title" -> 
    "ButcherPrincipalError", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/ButcherPrincipalError"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1407, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2030, 62, 57, 1, 70, "ObjectName",
 CellID->144],
Cell[2090, 65, 883, 27, 70, "Usage",
 CellID->22290]
}, Open  ]],
Cell[CellGroupData[{
Cell[3010, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3488, 114, 323, 10, 70, "Notes",
 CellID->31339],
Cell[3814, 126, 67, 1, 70, "Notes",
 CellID->23154],
Cell[3884, 129, 645, 17, 70, "3ColumnTableMod",
 CellID->24604],
Cell[4532, 148, 785, 29, 70, "Notes",
 CellID->4623]
}, Closed]],
Cell[CellGroupData[{
Cell[5354, 182, 310, 9, 70, "SeeAlsoSection",
 CellID->2330],
Cell[5667, 193, 275, 8, 70, "SeeAlso",
 CellID->29733]
}, Open  ]],
Cell[CellGroupData[{
Cell[5979, 206, 314, 9, 70, "TutorialsSection",
 CellID->22225],
Cell[6296, 217, 239, 5, 70, "Tutorials",
 CellID->20078]
}, Open  ]],
Cell[6550, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

