(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6924,        233]
NotebookOptionsPosition[      5052,        175]
NotebookOutlinePosition[      6282,        208]
CellTagsIndexPosition[      6239,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Explicit" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Explicit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DiagonallyImplicit", "ObjectName",
 CellID->14790],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["DiagonallyImplicit"], "InlineFormula"],
     " \[LineSeparator]is a setting for the option ",
     Cell[BoxData[
      ButtonBox["RungeKuttaMethod",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"]],
       "InlineFormula"],
     " specifying the type of Runge\[Dash]Kutta method to be generated."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9834]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  ButtonBox["DiagonallyImplicit",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"]], 
  "InlineFormula"],
 " is similar to the setting ",
 Cell[BoxData[
  ButtonBox["Implicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"]], 
  "InlineFormula"],
 ", except that the matrix ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}]]], "InlineFormula"],
 " has no nonzero upper triangular entries."
}], "Notes",
 CellID->10891]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20542],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Explicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->17998]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->621],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->18085]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DiagonallyImplicit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 43.2502132}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "DiagonallyImplicit is a setting for the option RungeKuttaMethod \
specifying the type of Runge\\[Dash]Kutta method to be generated.", 
    "synonyms" -> {}, "title" -> "DiagonallyImplicit", "type" -> "Symbol", 
    "uri" -> "NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"}},\

FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1364, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1987, 62, 56, 1, 70, "ObjectName",
 CellID->14790],
Cell[2046, 65, 614, 17, 70, "Usage",
 CellID->9834]
}, Open  ]],
Cell[CellGroupData[{
Cell[2697, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3175, 104, 659, 23, 70, "Notes",
 CellID->10891]
}, Closed]],
Cell[CellGroupData[{
Cell[3871, 132, 311, 9, 70, "SeeAlsoSection",
 CellID->20542],
Cell[4185, 143, 234, 6, 70, "SeeAlso",
 CellID->17998]
}, Open  ]],
Cell[CellGroupData[{
Cell[4456, 154, 312, 9, 70, "TutorialsSection",
 CellID->621],
Cell[4771, 165, 239, 5, 70, "Tutorials",
 CellID->18085]
}, Open  ]],
Cell[5025, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

