(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10920,        358]
NotebookOptionsPosition[      8670,        291]
NotebookOutlinePosition[     10059,        325]
CellTagsIndexPosition[     10016,        322]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GaussianQuadratureWeights" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"], "NewtonCotesError" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
NewtonCotesError"], "NewtonCotesWeights" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
NewtonCotesWeights"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"GaussianQuadratureWeights\"\>", 2->"\<\"NewtonCotesError\"\>", 
       3->"\<\"NewtonCotesWeights\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GaussianQuadratureError", "ObjectName",
 CellID->16096],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GaussianQuadratureError", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["f", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the leading term in the error of the elementary \
",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-point Gaussian quadrature formula for the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " on an interval from ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GaussianQuadratureError", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["f", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["prec", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]attempts to give a result with ",
     Cell[BoxData[
      StyleBox["prec", "TI"]], "InlineFormula"],
     " digits of precision."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " may be a pure function or a named function defined using ",
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["SetDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2085],

Cell[TextData[{
 "The error is given as a function of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], ",", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " multiplied by an ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["m", "TI"], "th"]], "InlineFormula"],
 " derivative of the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". The size of the error is bounded by the maximum of this expression over \
the interval from ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14752]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7688],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianQuadratureWeights",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NewtonCotesError",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NewtonCotesWeights",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesWeights"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19919]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->521],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->9260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->33289547],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "MoreAbout",
 CellID->315966115]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GaussianQuadratureError - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 43.6252228}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "GaussianQuadratureError[n, f, a, b] gives the leading term in the error \
of the elementary n-point Gaussian quadrature formula for the function f on \
an interval from a to b. GaussianQuadratureError[n, f, a, b, prec] attempts \
to give a result with prec digits of precision.", "synonyms" -> {}, "title" -> 
    "GaussianQuadratureError", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/GaussianQuadratureError"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2476, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3099, 87, 61, 1, 70, "ObjectName",
 CellID->16096],
Cell[3163, 90, 1399, 43, 70, "Usage",
 CellID->20648]
}, Open  ]],
Cell[CellGroupData[{
Cell[4599, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5077, 155, 427, 16, 70, "Notes",
 CellID->2085],
Cell[5507, 173, 676, 25, 70, "Notes",
 CellID->14752]
}, Closed]],
Cell[CellGroupData[{
Cell[6220, 203, 310, 9, 70, "SeeAlsoSection",
 CellID->7688],
Cell[6533, 214, 900, 30, 70, "SeeAlso",
 CellID->19919]
}, Open  ]],
Cell[CellGroupData[{
Cell[7470, 249, 312, 9, 70, "TutorialsSection",
 CellID->521],
Cell[7785, 260, 238, 5, 70, "Tutorials",
 CellID->9260]
}, Open  ]],
Cell[CellGroupData[{
Cell[8060, 270, 318, 9, 70, "MoreAboutSection",
 CellID->33289547],
Cell[8381, 281, 247, 5, 70, "MoreAbout",
 CellID->315966115]
}, Open  ]],
Cell[8643, 289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

