(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11566,        380]
NotebookOptionsPosition[      9278,        312]
NotebookOutlinePosition[     10702,        347]
CellTagsIndexPosition[     10659,        344]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GaussianQuadratureError" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"], "NewtonCotesError" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
NewtonCotesError"], "NewtonCotesWeights" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
NewtonCotesWeights"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"GaussianQuadratureError\"\>", 2->"\<\"NewtonCotesError\"\>", 
       3->"\<\"NewtonCotesWeights\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GaussianQuadratureWeights", "ObjectName",
 CellID->9515],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GaussianQuadratureWeights", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pairs ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["i", "TI"]], ",", 
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
     " of the elementary ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-point Gaussian formula for quadrature on the interval ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is the weight of the abscissa ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GaussianQuadratureWeights", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["prec", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]attempts to give a result with ",
     Cell[BoxData[
      StyleBox["prec", "TI"]], "InlineFormula"],
     " digits of precision."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23542]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Gaussian quadrature approximates the value of an integral as a linear \
combination of values of the integrand evaluated at optimal abscissas ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ": ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      StyleBox["a", "TI"], 
      StyleBox["b", "TI"]], 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "(", 
       StyleBox["x", "TI"], ")"}], 
      RowBox[{"\[DifferentialD]", 
       StyleBox["x", "TI"]}]}]}], "\[TildeTilde]", 
    RowBox[{
     UnderscriptBox["\[Sum]", 
      StyleBox["i", "TI"]], 
     RowBox[{
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["i", "TI"]], " ", 
      RowBox[{
       StyleBox["f", "TI"], "(", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], ")"}]}]}]}], TraditionalForm]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->23495],

Cell[TextData[{
 "The abscissas are optimal in the sense that the quadrature formula is exact \
for all polynomials up to degree ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"2", 
    StyleBox["n", "TI"]}], "-", "1"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3566]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12626],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianQuadratureError",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NewtonCotesError",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NewtonCotesWeights",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesWeights"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18364]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18456],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->14186]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->591182942],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "MoreAbout",
 CellID->874986137]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GaussianQuadratureWeights - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 43.8127276}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "GaussianQuadratureWeights[n, a, b] gives a list of the n pairs {x_i, \
w_i} of the elementary n-point Gaussian formula for quadrature on the \
interval a to b, where w_i is the weight of the abscissa x_i. \
GaussianQuadratureWeights[n, a, b, prec] attempts to give a result with prec \
digits of precision.", "synonyms" -> {}, "title" -> 
    "GaussianQuadratureWeights", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/GaussianQuadratureWeights"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2470, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3093, 87, 62, 1, 70, "ObjectName",
 CellID->9515],
Cell[3158, 90, 1859, 60, 70, "Usage",
 CellID->23542]
}, Open  ]],
Cell[CellGroupData[{
Cell[5054, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5532, 172, 990, 36, 70, "Notes",
 CellID->23495],
Cell[6525, 210, 265, 9, 70, "Notes",
 CellID->3566]
}, Closed]],
Cell[CellGroupData[{
Cell[6827, 224, 311, 9, 70, "SeeAlsoSection",
 CellID->12626],
Cell[7141, 235, 896, 30, 70, "SeeAlso",
 CellID->18364]
}, Open  ]],
Cell[CellGroupData[{
Cell[8074, 270, 314, 9, 70, "TutorialsSection",
 CellID->18456],
Cell[8391, 281, 239, 5, 70, "Tutorials",
 CellID->14186]
}, Open  ]],
Cell[CellGroupData[{
Cell[8667, 291, 319, 9, 70, "MoreAboutSection",
 CellID->591182942],
Cell[8989, 302, 247, 5, 70, "MoreAbout",
 CellID->874986137]
}, Open  ]],
Cell[9251, 310, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

