(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11731,        393]
NotebookOptionsPosition[      9462,        322]
NotebookOutlinePosition[     10701,        354]
CellTagsIndexPosition[     10658,        351]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NewtonCotesWeights" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
NewtonCotesWeights"], "GaussianQuadratureError" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"], "GaussianQuadratureWeights" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"NewtonCotesWeights\"\>", 2->"\<\"GaussianQuadratureError\"\>", 
       3->"\<\"GaussianQuadratureWeights\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NewtonCotesError", "ObjectName",
 CellID->14615],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NewtonCotesError", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["f", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the error in the elementary ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-point Newton-Cotes quadrature formula for the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " on an interval from ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " may be a pure function or a named function defined using ",
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["SetDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13143],

Cell[TextData[{
 "The error is given as a function of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], ",", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " multiplied by an ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["m", "TI"], "th"]], "InlineFormula"],
 " derivative of the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". The size of the error is bounded by the maximum of this expression over \
the interval from ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11763],

Cell[TextData[{
 "The abscissas may or may not include the endpoints ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " of the interval. The option ",
 Cell[BoxData[
  ButtonBox["QuadratureType",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/QuadratureType"]], 
  "InlineFormula"],
 " is used to control whether endpoints are included as abscissas."
}], "Notes",
 CellID->14771],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["QuadratureType",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/QuadratureType"], "->",
    "Closed"}]], "InlineFormula"],
 ", the endpoints are included as abscissas. "
}], "Notes",
 CellID->23592],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["QuadratureType",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/QuadratureType"], "->",
    "Open"}]], "InlineFormula"],
 ", the endpoints are not included as abscissas. In this case, the initial \
abscissa is chosen to be a halfstep above the lower endpoint."
}], "Notes",
 CellID->14935]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26721],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NewtonCotesWeights",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesWeights"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianQuadratureError",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianQuadratureWeights",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16952]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19217],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->25412]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->127778024],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "MoreAbout",
 CellID->35443392]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NewtonCotesError - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 44.1408610}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "NewtonCotesError[n, f, a, b] gives the error in the elementary n-point \
Newton-Cotes quadrature formula for the function f on an interval from a to \
b.", "synonyms" -> {}, "title" -> "NewtonCotesError", "type" -> "Symbol", 
    "uri" -> "NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2497, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3120, 87, 54, 1, 70, "ObjectName",
 CellID->14615],
Cell[3177, 90, 897, 28, 70, "Usage",
 CellID->22195]
}, Open  ]],
Cell[CellGroupData[{
Cell[4111, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4589, 140, 428, 16, 70, "Notes",
 CellID->13143],
Cell[5020, 158, 676, 25, 70, "Notes",
 CellID->11763],
Cell[5699, 185, 503, 16, 70, "Notes",
 CellID->14771],
Cell[6205, 203, 332, 11, 70, "Notes",
 CellID->23592],
Cell[6540, 216, 415, 12, 70, "Notes",
 CellID->14935]
}, Closed]],
Cell[CellGroupData[{
Cell[6992, 233, 311, 9, 70, "SeeAlsoSection",
 CellID->26721],
Cell[7306, 244, 916, 31, 70, "SeeAlso",
 CellID->16952]
}, Open  ]],
Cell[CellGroupData[{
Cell[8259, 280, 314, 9, 70, "TutorialsSection",
 CellID->19217],
Cell[8576, 291, 239, 5, 70, "Tutorials",
 CellID->25412]
}, Open  ]],
Cell[CellGroupData[{
Cell[8852, 301, 319, 9, 70, "MoreAboutSection",
 CellID->127778024],
Cell[9174, 312, 246, 5, 70, "MoreAbout",
 CellID->35443392]
}, Open  ]],
Cell[9435, 320, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

