(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7847,        263]
NotebookOptionsPosition[      5871,        202]
NotebookOutlinePosition[      7098,        234]
CellTagsIndexPosition[      7055,        231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GaussianQuadratureError" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"], "GaussianQuadratureWeights" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"GaussianQuadratureError\"\>", 
       2->"\<\"GaussianQuadratureWeights\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["QuadratureType", "ObjectName",
 CellID->3362],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["QuadratureType"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["NewtonCotesWeights",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesWeights"]\
], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["NewtonCotesError",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"]],
       "InlineFormula"],
     " that specifies whether the endpoints are to be included as abscissas."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5775]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData["Open"], "InlineFormula"],
 " and ",
 Cell[BoxData["Closed"], "InlineFormula"],
 "."
}], "Notes",
 CellID->17624],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"QuadratureType", "->", "Closed"}]], "InlineFormula"],
 ", the endpoints are included as abscissas. "
}], "Notes",
 CellID->14078],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"QuadratureType", "->", "Open"}]], "InlineFormula"],
 ", the endpoints are not included as abscissas. In this case, the initial \
abscissa is chosen to be a halfstep above the lower endpoint."
}], "Notes",
 CellID->4985]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6048],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianQuadratureError",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianQuadratureWeights",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20170]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10103],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->26781]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"QuadratureType - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 50.6722782}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "QuadratureType is an option to NewtonCotesWeights and NewtonCotesError \
that specifies whether the endpoints are to be included as abscissas.", 
    "synonyms" -> {}, "title" -> "QuadratureType", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/QuadratureType"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1609, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2232, 66, 51, 1, 70, "ObjectName",
 CellID->3362],
Cell[2286, 69, 821, 24, 70, "Usage",
 CellID->5775]
}, Open  ]],
Cell[CellGroupData[{
Cell[3144, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3622, 115, 167, 7, 70, "Notes",
 CellID->17624],
Cell[3792, 124, 201, 6, 70, "Notes",
 CellID->14078],
Cell[3996, 132, 283, 7, 70, "Notes",
 CellID->4985]
}, Closed]],
Cell[CellGroupData[{
Cell[4316, 144, 310, 9, 70, "SeeAlsoSection",
 CellID->6048],
Cell[4629, 155, 607, 21, 70, "SeeAlso",
 CellID->20170]
}, Open  ]],
Cell[CellGroupData[{
Cell[5273, 181, 314, 9, 70, "TutorialsSection",
 CellID->10103],
Cell[5590, 192, 239, 5, 70, "Tutorials",
 CellID->26781]
}, Open  ]],
Cell[5844, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

