(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12048,        381]
NotebookOptionsPosition[      9711,        310]
NotebookOutlinePosition[     11068,        344]
CellTagsIndexPosition[     11025,        341]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ButcherColumnConditions" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherColumnConditions"], "ButcherRowConditions" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherRowConditions"], "ButcherQuadratureConditions" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherQuadratureConditions"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"ButcherColumnConditions\"\>", 
       2->"\<\"ButcherRowConditions\"\>", 
       3->"\<\"ButcherQuadratureConditions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RungeKuttaOrderConditions", "ObjectName",
 CellID->5927],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RungeKuttaOrderConditions", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the order conditions that any ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     "-stage Runge\[Dash]Kutta method of order ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " must satisfy. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RungeKuttaOrderConditions", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the order conditions using stage independent \
tensor notation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The order conditions are grouped by order.", "Notes",
 CellID->28119],

Cell["The following options can be given:", "Notes",
 CellID->21479],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButcherRowSum",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowSum"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to include row-sum conditions for ",
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButcherSimplify",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSimplify"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to use Butcher's assumptions", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContinuousExtension",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ContinuousExtension"],
     
    ButtonBox["$ContinuousExtension",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/$ContinuousExtension"]\
, Cell["whether to generate conditions for continuous extensions", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"], 
    ButtonBox["$RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/$RungeKuttaMethod"], 
    Cell["type of Runge-Kutta method", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->22716],

Cell[TextData[{
 "If the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ButcherSimplify",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSimplify"], "->",
    
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is selected, the number of stages must be a positive integer."
}], "Notes",
 CellID->6300]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24593],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherColumnConditions",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherColumnConditions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherRowConditions",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowConditions"],
   
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherQuadratureConditions",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherQuadratureConditions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30806]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21396],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->16853]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->43993350],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "MoreAbout",
 CellID->161818087]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RungeKuttaOrderConditions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 50.9847862}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "RungeKuttaOrderConditions[p, s] gives a list of the order conditions \
that any s-stage Runge\\[Dash]Kutta method of order p must satisfy. \
RungeKuttaOrderConditions[p] gives the order conditions using stage \
independent tensor notation.", "synonyms" -> {}, "title" -> 
    "RungeKuttaOrderConditions", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/RungeKuttaOrderConditions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2517, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3140, 88, 62, 1, 70, "ObjectName",
 CellID->5927],
Cell[3205, 91, 930, 27, 70, "Usage",
 CellID->14609]
}, Open  ]],
Cell[CellGroupData[{
Cell[4172, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4650, 140, 75, 1, 70, "Notes",
 CellID->28119],
Cell[4728, 143, 68, 1, 70, "Notes",
 CellID->21479],
Cell[4799, 146, 1978, 53, 70, "3ColumnTableMod",
 CellID->22716],
Cell[6780, 201, 412, 14, 70, "Notes",
 CellID->6300]
}, Closed]],
Cell[CellGroupData[{
Cell[7229, 220, 311, 9, 70, "SeeAlsoSection",
 CellID->24593],
Cell[7543, 231, 928, 32, 70, "SeeAlso",
 CellID->30806]
}, Open  ]],
Cell[CellGroupData[{
Cell[8508, 268, 314, 9, 70, "TutorialsSection",
 CellID->21396],
Cell[8825, 279, 239, 5, 70, "Tutorials",
 CellID->16853]
}, Open  ]],
Cell[CellGroupData[{
Cell[9101, 289, 318, 9, 70, "MoreAboutSection",
 CellID->43993350],
Cell[9422, 300, 247, 5, 70, "MoreAbout",
 CellID->161818087]
}, Open  ]],
Cell[9684, 308, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

