(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19794,        651]
NotebookOptionsPosition[     15572,        522]
NotebookOutlinePosition[     16585,        550]
CellTagsIndexPosition[     16542,        547]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Physical Constants Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["AccelerationDueToGravity",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/AccelerationDueToGravity"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AgeOfUniverse",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/AgeOfUniverse"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EarthMass",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/EarthMass"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EarthRadius",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/EarthRadius"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GravitationalConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/GravitationalConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HubbleConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/HubbleConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IcePoint",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/IcePoint"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpeedOfSound",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/SpeedOfSound"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeakMixingAngle",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/WeakMixingAngle"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->64716431],

Cell["\t", "GuideDelimiterSubsection",
 CellID->304340170],

Cell[CellGroupData[{

Cell["Universal Constants", "GuideFunctionsSubsection",
 CellID->432637564],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlanckConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/PlanckConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PlanckConstantReduced",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/PlanckConstantReduced"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PlanckMass",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/PlanckMass"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpeedOfLight",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/SpeedOfLight"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VacuumPermeability",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/VacuumPermeability"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VacuumPermittivity",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/VacuumPermittivity"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26650169],

Cell["\t", "GuideDelimiterSubsection",
 CellID->133962801]
}, Open  ]],

Cell[CellGroupData[{

Cell["Atomic Constants", "GuideFunctionsSubsection",
 CellID->69023543],

Cell[TextData[{
 Cell[TextData[ButtonBox["BohrRadius",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/BohrRadius"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FineStructureConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/FineStructureConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RydbergConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/RydbergConstant"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->294689998]
}, Open  ]],

Cell[CellGroupData[{

Cell["Electron Constants", "GuideFunctionsSubsection",
 CellID->126773517],

Cell[TextData[{
 Cell[TextData[ButtonBox["ClassicalElectronRadius",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ClassicalElectronRadius"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ElectronComptonWavelength",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ElectronComptonWavelength"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ElectronGFactor",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ElectronGFactor"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ElectronMagneticMoment",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ElectronMagneticMoment"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ElectronMass",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FaradayConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/FaradayConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ThomsonCrossSection",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ThomsonCrossSection"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->344728457]
}, Open  ]],

Cell[CellGroupData[{

Cell["Proton Constants", "GuideFunctionsSubsection",
 CellID->94106948],

Cell[TextData[{
 Cell[TextData[ButtonBox["ProtonComptonWavelength",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ProtonComptonWavelength"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ProtonMagneticMoment",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ProtonMagneticMoment"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ProtonMass",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ProtonMass"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->110496020]
}, Open  ]],

Cell[CellGroupData[{

Cell["Neutron Constants", "GuideFunctionsSubsection",
 CellID->9928958],

Cell[TextData[{
 Cell[TextData[ButtonBox["NeutronComptonWavelength",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/NeutronComptonWavelength"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NeutronMagneticMoment",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/NeutronMagneticMoment"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NeutronMass",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/NeutronMass"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->125128906]
}, Open  ]],

Cell[CellGroupData[{

Cell["Muon Constants", "GuideFunctionsSubsection",
 CellID->79534265],

Cell[TextData[{
 Cell[TextData[ButtonBox["MuonGFactor",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/MuonGFactor"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MuonMagneticMoment",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/MuonMagneticMoment"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MuonMass",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/MuonMass"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->57417807]
}, Open  ]],

Cell[CellGroupData[{

Cell["Deuteron Constants", "GuideFunctionsSubsection",
 CellID->161189044],

Cell[TextData[{
 Cell[TextData[ButtonBox["DeuteronMagneticMoment",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/DeuteronMagneticMoment"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeuteronMass",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/DeuteronMass"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->674290610],

Cell["\t", "GuideDelimiterSubsection",
 CellID->89482855]
}, Open  ]],

Cell[CellGroupData[{

Cell["Electromagnetic Constants", "GuideFunctionsSubsection",
 CellID->439689524],

Cell[TextData[{
 Cell[TextData[ButtonBox["ElectronCharge",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/ElectronCharge"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MagneticFluxQuantum",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/MagneticFluxQuantum"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["QuantizedHallConductance",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/QuantizedHallConductance"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->92643021],

Cell["\t", "GuideDelimiterSubsection",
 CellID->548256758]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chemical Constants", "GuideFunctionsSubsection",
 CellID->114466136],

Cell[TextData[{
 Cell[TextData[ButtonBox["AvogadroConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/AvogadroConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MolarVolume",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/MolarVolume"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->11165708],

Cell["\t", "GuideDelimiterSubsection",
 CellID->16648845]
}, Open  ]],

Cell[CellGroupData[{

Cell["Physicochemical Constants", "GuideFunctionsSubsection",
 CellID->62147578],

Cell[TextData[{
 Cell[TextData[ButtonBox["BoltzmannConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/BoltzmannConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MolarGasConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/MolarGasConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SackurTetrodeConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/SackurTetrodeConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StefanConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/StefanConstant"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->436972629],

Cell["\t", "GuideDelimiterSubsection",
 CellID->925358407]
}, Open  ]],

Cell[CellGroupData[{

Cell["Astronomical Constants", "GuideFunctionsSubsection",
 CellID->488973885],

Cell[TextData[{
 Cell[TextData[ButtonBox["CosmicBackgroundTemperature",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/CosmicBackgroundTemperature"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GalacticUnit",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/GalacticUnit"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SolarConstant",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/SolarConstant"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SolarLuminosity",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/SolarLuminosity"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SolarRadius",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/SolarRadius"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SolarSchwarzschildRadius",
  BaseStyle->"Link",
  ButtonData->"paclet:PhysicalConstants/ref/SolarSchwarzschildRadius"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->209444595]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Physical Constants",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "GuideTutorial",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Data Collections",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/guide/UnitsPackage"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Standard Atmosphere Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StandardAtmosphere/guide/StandardAtmospherePackage"]], \
"GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Physical Constants Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 58.5006036}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Guide", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "Physical Constants Package", "type" -> 
    "Guide", "uri" -> "PhysicalConstants/guide/PhysicalConstantsPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 68, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[690, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[749, 31, 2150, 62, 70, "InlineGuideFunctionListing",
 CellID->64716431],
Cell[2902, 95, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->304340170],
Cell[CellGroupData[{
Cell[2985, 100, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->432637564],
Cell[3063, 103, 1443, 41, 70, "InlineGuideFunctionListing",
 CellID->26650169],
Cell[4509, 146, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->133962801]
}, Open  ]],
Cell[CellGroupData[{
Cell[4604, 152, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->69023543],
Cell[4678, 155, 711, 20, 70, "InlineGuideFunctionListing",
 CellID->294689998]
}, Open  ]],
Cell[CellGroupData[{
Cell[5426, 180, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->126773517],
Cell[5503, 183, 1733, 48, 70, "InlineGuideFunctionListing",
 CellID->344728457]
}, Open  ]],
Cell[CellGroupData[{
Cell[7273, 236, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->94106948],
Cell[7347, 239, 725, 20, 70, "InlineGuideFunctionListing",
 CellID->110496020]
}, Open  ]],
Cell[CellGroupData[{
Cell[8109, 264, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->9928958],
Cell[8183, 267, 731, 20, 70, "InlineGuideFunctionListing",
 CellID->125128906]
}, Open  ]],
Cell[CellGroupData[{
Cell[8951, 292, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->79534265],
Cell[9023, 295, 692, 20, 70, "InlineGuideFunctionListing",
 CellID->57417807]
}, Open  ]],
Cell[CellGroupData[{
Cell[9752, 320, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->161189044],
Cell[9829, 323, 474, 13, 70, "InlineGuideFunctionListing",
 CellID->674290610],
Cell[10306, 338, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->89482855]
}, Open  ]],
Cell[CellGroupData[{
Cell[10400, 344, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->439689524],
Cell[10484, 347, 732, 20, 70, "InlineGuideFunctionListing",
 CellID->92643021],
Cell[11219, 369, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->548256758]
}, Open  ]],
Cell[CellGroupData[{
Cell[11314, 375, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->114466136],
Cell[11391, 378, 459, 13, 70, "InlineGuideFunctionListing",
 CellID->11165708],
Cell[11853, 393, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->16648845]
}, Open  ]],
Cell[CellGroupData[{
Cell[11947, 399, 80, 1, 70, "GuideFunctionsSubsection",
 CellID->62147578],
Cell[12030, 402, 968, 27, 70, "InlineGuideFunctionListing",
 CellID->436972629],
Cell[13001, 431, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->925358407]
}, Open  ]],
Cell[CellGroupData[{
Cell[13096, 437, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->488973885],
Cell[13177, 440, 1462, 41, 70, "InlineGuideFunctionListing",
 CellID->209444595]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14688, 487, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[14753, 490, 175, 4, 70, "GuideTutorial",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[14965, 499, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[15030, 502, 149, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[15182, 507, 148, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[15333, 512, 197, 5, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[15545, 520, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

