(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7120,        248]
NotebookOptionsPosition[      5286,        191]
NotebookOutlinePosition[      6424,        221]
CellTagsIndexPosition[      6381,        218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GravitationalConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/GravitationalConstant"], "EarthMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/EarthMass"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GravitationalConstant\"\>", 
       2->"\<\"EarthMass\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AccelerationDueToGravity", "ObjectName",
 CellID->5984],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["AccelerationDueToGravity"], "InlineFormula"],
     " \[LineSeparator]is the acceleration of a body freely falling in a \
vacuum on Earth at sea level."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4389]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["AccelerationDueToGravity"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"], "/", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["Second",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Second"], "^", "2"}], ")"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->25402],

Cell[TextData[{
 "The acceleration due to gravity is ",
 Cell[BoxData[
  RowBox[{"9.80665", " ", 
   RowBox[{
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "/", 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["Second",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Second"], "^", "2"}], ")"}]}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->25411]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13686],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GravitationalConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/GravitationalConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EarthMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/EarthMass"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7943]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8957],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->31807]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AccelerationDueToGravity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 58.6881084}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "AccelerationDueToGravity is the acceleration of a body freely falling in \
a vacuum on Earth at sea level.", "synonyms" -> {}, "title" -> 
    "AccelerationDueToGravity", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/AccelerationDueToGravity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1410, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2033, 63, 61, 1, 70, "ObjectName",
 CellID->5984],
Cell[2097, 66, 394, 11, 70, "Usage",
 CellID->4389]
}, Open  ]],
Cell[CellGroupData[{
Cell[2528, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3006, 99, 426, 16, 70, "Notes",
 CellID->25402],
Cell[3435, 117, 416, 16, 70, "Notes",
 CellID->25411]
}, Closed]],
Cell[CellGroupData[{
Cell[3888, 138, 311, 9, 70, "SeeAlsoSection",
 CellID->13686],
Cell[4202, 149, 514, 17, 70, "SeeAlso",
 CellID->7943]
}, Open  ]],
Cell[CellGroupData[{
Cell[4753, 171, 313, 9, 70, "TutorialsSection",
 CellID->8957],
Cell[5069, 182, 175, 4, 70, "Tutorials",
 CellID->31807]
}, Open  ]],
Cell[5259, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

