(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6989,        238]
NotebookOptionsPosition[      5197,        183]
NotebookOutlinePosition[      6345,        213]
CellTagsIndexPosition[      6302,        210]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MolarGasConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MolarGasConstant"], 
          "AvogadroConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/AvogadroConstant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MolarGasConstant\"\>", 
       2->"\<\"AvogadroConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoltzmannConstant", "ObjectName",
 CellID->4001],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BoltzmannConstant"], "InlineFormula"],
     " \[LineSeparator]",
     " is the ratio of the universal gas constant (",
     Cell[BoxData[
      ButtonBox["MolarGasConstant",
       BaseStyle->"Link",
       ButtonData->"paclet:PhysicalConstants/ref/MolarGasConstant"]], 
      "InlineFormula"],
     ") to Avogadro\[CloseCurlyQuote]s number (",
     Cell[BoxData[
      ButtonBox["AvogadroConstant",
       BaseStyle->"Link",
       ButtonData->"paclet:PhysicalConstants/ref/AvogadroConstant"]], 
      "InlineFormula"],
     ")."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13485]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BoltzmannConstant"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"], "/", 
   ButtonBox["Kelvin",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kelvin"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11619]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6894],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MolarGasConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MolarGasConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvogadroConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/AvogadroConstant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30804]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22946],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->26613]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoltzmannConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 59.3287498}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "BoltzmannConstant is the ratio of the universal gas constant \
(MolarGasConstant) to Avogadro\\[CloseCurlyQuote]s number \
(AvogadroConstant).", "synonyms" -> {}, "title" -> "BoltzmannConstant", 
    "type" -> "Symbol", "uri" -> "PhysicalConstants/ref/BoltzmannConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1427, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2050, 64, 54, 1, 70, "ObjectName",
 CellID->4001],
Cell[2107, 67, 774, 23, 70, "Usage",
 CellID->13485]
}, Open  ]],
Cell[CellGroupData[{
Cell[2918, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3396, 112, 361, 13, 70, "Notes",
 CellID->11619]
}, Closed]],
Cell[CellGroupData[{
Cell[3794, 130, 310, 9, 70, "SeeAlsoSection",
 CellID->6894],
Cell[4107, 141, 519, 17, 70, "SeeAlso",
 CellID->30804]
}, Open  ]],
Cell[CellGroupData[{
Cell[4663, 163, 314, 9, 70, "TutorialsSection",
 CellID->22946],
Cell[4980, 174, 175, 4, 70, "Tutorials",
 CellID->26613]
}, Open  ]],
Cell[5170, 181, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

