(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6280,        219]
NotebookOptionsPosition[      4581,        165]
NotebookOutlinePosition[      5633,        194]
CellTagsIndexPosition[      5590,        191]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EarthMass" :> 
          Documentation`HelpLookup["paclet:PhysicalConstants/ref/EarthMass"], 
          "SolarRadius" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SolarRadius"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EarthMass\"\>", 
       2->"\<\"SolarRadius\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EarthRadius", "ObjectName",
 CellID->19514],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["EarthRadius"], "InlineFormula"],
     " \[LineSeparator]is the radius of the Earth, a physical constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15505]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["EarthRadius"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30044]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6258],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EarthMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/EarthMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolarRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SolarRadius"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->706004281]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22711],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->17375]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EarthRadius - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 6.8758180}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "EarthRadius is the radius of the Earth, a physical constant.", 
    "synonyms" -> {}, "title" -> "EarthRadius", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/EarthRadius"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1379, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2002, 63, 49, 1, 70, "ObjectName",
 CellID->19514],
Cell[2054, 66, 349, 10, 70, "Usage",
 CellID->15505]
}, Open  ]],
Cell[CellGroupData[{
Cell[2440, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2918, 98, 243, 9, 70, "Notes",
 CellID->30044]
}, Closed]],
Cell[CellGroupData[{
Cell[3198, 112, 310, 9, 70, "SeeAlsoSection",
 CellID->6258],
Cell[3511, 123, 499, 17, 70, "SeeAlso",
 CellID->706004281]
}, Open  ]],
Cell[CellGroupData[{
Cell[4047, 145, 314, 9, 70, "TutorialsSection",
 CellID->22711],
Cell[4364, 156, 175, 4, 70, "Tutorials",
 CellID->17375]
}, Open  ]],
Cell[4554, 163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

