(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8455,        280]
NotebookOptionsPosition[      6658,        224]
NotebookOutlinePosition[      7753,        253]
CellTagsIndexPosition[      7710,        250]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NeutronComptonWavelength" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronComptonWavelength"], 
          "ProtonComptonWavelength" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ProtonComptonWavelength"], 
          "BohrRadius" :> 
          Documentation`HelpLookup["paclet:PhysicalConstants/ref/BohrRadius"],
           "ClassicalElectronRadius" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ClassicalElectronRadius"], 
          "ElectronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMass"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NeutronComptonWavelength\"\>", 
       2->"\<\"ProtonComptonWavelength\"\>", 3->"\<\"BohrRadius\"\>", 
       4->"\<\"ClassicalElectronRadius\"\>", 
       5->"\<\"ElectronMass\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ElectronComptonWavelength", "ObjectName",
 CellID->19984],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ElectronComptonWavelength"], "InlineFormula"],
     " \[LineSeparator]is the electron Compton wavelength."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19647]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ElectronComptonWavelength"], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlanckConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/PlanckConstant"], "/", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["ElectronMass",
      BaseStyle->"Link",
      ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"], "*", 
     ButtonBox["SpeedOfLight",
      BaseStyle->"Link",
      ButtonData->"paclet:PhysicalConstants/ref/SpeedOfLight"]}], ")"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->6655],

Cell[TextData[{
 Cell[BoxData["ElectronComptonWavelength"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10371]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13965],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronComptonWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronComptonWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonComptonWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonComptonWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BohrRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/BohrRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClassicalElectronRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ClassicalElectronRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMass"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2738359]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25502],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->25100]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ElectronComptonWavelength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 7.2039514}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "ElectronComptonWavelength is the electron Compton wavelength.", 
    "synonyms" -> {}, "title" -> "ElectronComptonWavelength", "type" -> 
    "Symbol", "uri" -> "PhysicalConstants/ref/ElectronComptonWavelength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1953, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2576, 74, 63, 1, 70, "ObjectName",
 CellID->19984],
Cell[2642, 77, 350, 10, 70, "Usage",
 CellID->19647]
}, Open  ]],
Cell[CellGroupData[{
Cell[3029, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3507, 109, 587, 19, 70, "Notes",
 CellID->6655],
Cell[4097, 130, 257, 9, 70, "Notes",
 CellID->10371]
}, Closed]],
Cell[CellGroupData[{
Cell[4391, 144, 311, 9, 70, "SeeAlsoSection",
 CellID->13965],
Cell[4705, 155, 1382, 44, 70, "SeeAlso",
 CellID->2738359]
}, Open  ]],
Cell[CellGroupData[{
Cell[6124, 204, 314, 9, 70, "TutorialsSection",
 CellID->25502],
Cell[6441, 215, 175, 4, 70, "Tutorials",
 CellID->25100]
}, Open  ]],
Cell[6631, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

