(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8340,        282]
NotebookOptionsPosition[      6610,        226]
NotebookOutlinePosition[      7645,        255]
CellTagsIndexPosition[      7602,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeuteronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/DeuteronMass"], "ElectronCharge" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronCharge"], 
          "ClassicalElectronRadius" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ClassicalElectronRadius"], 
          "MuonMass" :> 
          Documentation`HelpLookup["paclet:PhysicalConstants/ref/MuonMass"], 
          "NeutronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronMass"], "ProtonMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ProtonMass"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DeuteronMass\"\>", 2->"\<\"ElectronCharge\"\>", 
       3->"\<\"ClassicalElectronRadius\"\>", 4->"\<\"MuonMass\"\>", 
       5->"\<\"NeutronMass\"\>", 6->"\<\"ProtonMass\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ElectronMass", "ObjectName",
 CellID->9345],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ElectronMass"], "InlineFormula"],
     " \[LineSeparator]is the mass of an electron."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4167]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ElectronMass"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Kilogram",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kilogram"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7270],

Cell[TextData[{
 "The mass of an electron is approximately ",
 Cell[BoxData[
  RowBox[{"9.10938188", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "31"}]], " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5538]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9095],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeuteronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/DeuteronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronCharge",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronCharge"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClassicalElectronRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ClassicalElectronRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonMass"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30628]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27986],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->1925]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ElectronMass - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 7.7039642}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "ElectronMass is the mass of an electron.", "synonyms" -> {}, "title" -> 
    "ElectronMass", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/ElectronMass"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2003, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2626, 75, 49, 1, 70, "ObjectName",
 CellID->9345],
Cell[2678, 78, 328, 10, 70, "Usage",
 CellID->4167]
}, Open  ]],
Cell[CellGroupData[{
Cell[3043, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3521, 110, 249, 9, 70, "Notes",
 CellID->7270],
Cell[3773, 121, 318, 11, 70, "Notes",
 CellID->5538]
}, Closed]],
Cell[CellGroupData[{
Cell[4128, 137, 310, 9, 70, "SeeAlsoSection",
 CellID->9095],
Cell[4441, 148, 1599, 53, 70, "SeeAlso",
 CellID->30628]
}, Open  ]],
Cell[CellGroupData[{
Cell[6077, 206, 314, 9, 70, "TutorialsSection",
 CellID->27986],
Cell[6394, 217, 174, 4, 70, "Tutorials",
 CellID->1925]
}, Open  ]],
Cell[6583, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

