(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7402,        249]
NotebookOptionsPosition[      5610,        193]
NotebookOutlinePosition[      6703,        222]
CellTagsIndexPosition[      6660,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ElectronCharge" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronCharge"], "PlanckConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/PlanckConstant"], "SpeedOfLight" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/SpeedOfLight"], "VacuumPermittivity" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/VacuumPermittivity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ElectronCharge\"\>", 
       2->"\<\"PlanckConstant\"\>", 3->"\<\"SpeedOfLight\"\>", 
       4->"\<\"VacuumPermittivity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FineStructureConstant", "ObjectName",
 CellID->29723],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["FineStructureConstant"], "InlineFormula"],
     " \[LineSeparator]is the fine structure constant, an atomic constant."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4285]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["FineStructureConstant"], "InlineFormula"],
 " is a unitless number."
}], "Notes",
 CellID->15203],

Cell[TextData[{
 "The fine structure constant is approximately ",
 Cell[BoxData[
  RowBox[{"7.297352533", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "3"}]]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19712]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15966],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronCharge",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronCharge"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlanckConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/PlanckConstant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpeedOfLight",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/SpeedOfLight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VacuumPermittivity",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/VacuumPermittivity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21104]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27117],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->19084]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FineStructureConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 14.5010132}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "FineStructureConstant is the fine structure constant, an atomic \
constant.", "synonyms" -> {}, "title" -> "FineStructureConstant", "type" -> 
    "Symbol", "uri" -> "PhysicalConstants/ref/FineStructureConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1708, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2331, 68, 59, 1, 70, "ObjectName",
 CellID->29723],
Cell[2393, 71, 361, 10, 70, "Usage",
 CellID->4285]
}, Open  ]],
Cell[CellGroupData[{
Cell[2791, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3269, 103, 128, 4, 70, "Notes",
 CellID->15203],
Cell[3400, 109, 223, 8, 70, "Notes",
 CellID->19712]
}, Closed]],
Cell[CellGroupData[{
Cell[3660, 122, 311, 9, 70, "SeeAlsoSection",
 CellID->15966],
Cell[3974, 133, 1065, 35, 70, "SeeAlso",
 CellID->21104]
}, Open  ]],
Cell[CellGroupData[{
Cell[5076, 173, 314, 9, 70, "TutorialsSection",
 CellID->27117],
Cell[5393, 184, 175, 4, 70, "Tutorials",
 CellID->19084]
}, Open  ]],
Cell[5583, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

