(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6780,        234]
NotebookOptionsPosition[      5020,        179]
NotebookOutlinePosition[      6136,        209]
CellTagsIndexPosition[      6093,        206]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AccelerationDueToGravity" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/AccelerationDueToGravity"], 
          "EarthMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/EarthMass"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AccelerationDueToGravity\"\>", 
       2->"\<\"EarthMass\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GravitationalConstant", "ObjectName",
 CellID->1754],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["GravitationalConstant"], "InlineFormula"],
     " \[LineSeparator]is the coefficient of proportionality in Newton's law \
of gravitation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GravitationalConstant"], "InlineFormula"],
 " has units of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["Meter",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Meter"], "^", "2"}], "*", 
     ButtonBox["Newton",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Newton"]}], ")"}], "/", 
   RowBox[{
    ButtonBox["Kilogram",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Kilogram"], "^", "2"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->31523]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30478],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccelerationDueToGravity",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/AccelerationDueToGravity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EarthMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/EarthMass"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28212]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4413],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->18098]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GravitationalConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 14.8135212}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "GravitationalConstant is the coefficient of proportionality in Newton's \
law of gravitation.", "synonyms" -> {}, "title" -> "GravitationalConstant", 
    "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/GravitationalConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1430, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2053, 64, 58, 1, 70, "ObjectName",
 CellID->1754],
Cell[2114, 67, 382, 11, 70, "Usage",
 CellID->29201]
}, Open  ]],
Cell[CellGroupData[{
Cell[2533, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3011, 100, 567, 21, 70, "Notes",
 CellID->31523]
}, Closed]],
Cell[CellGroupData[{
Cell[3615, 126, 311, 9, 70, "SeeAlsoSection",
 CellID->30478],
Cell[3929, 137, 521, 17, 70, "SeeAlso",
 CellID->28212]
}, Open  ]],
Cell[CellGroupData[{
Cell[4487, 159, 313, 9, 70, "TutorialsSection",
 CellID->4413],
Cell[4803, 170, 175, 4, 70, "Tutorials",
 CellID->18098]
}, Open  ]],
Cell[4993, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

