(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4734,        163]
NotebookOptionsPosition[      3103,        114]
NotebookOutlinePosition[      4247,        144]
CellTagsIndexPosition[      4204,        141]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Physical Constants Package" :> 
         Documentation`HelpLookup[
          "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IcePoint", "ObjectName",
 CellID->29738],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["IcePoint"], "InlineFormula"],
     " \[LineSeparator]is the temperature at which a mixture of \
air\[Dash]saturated pure water and pure ice may exist in equilibrium at a \
pressure of one standard atmosphere."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4409]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["IcePoint"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Kelvin",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kelvin"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15881],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->25239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IcePoint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 15.1416546}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "IcePoint is the temperature at which a mixture of air\\[Dash]saturated \
pure water and pure ice may exist in equilibrium at a pressure of one \
standard atmosphere.", "synonyms" -> {}, "title" -> "IcePoint", "type" -> 
    "Symbol", "uri" -> "PhysicalConstants/ref/IcePoint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 652, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1275, 43, 46, 1, 70, "ObjectName",
 CellID->29738],
Cell[1324, 46, 452, 12, 70, "Usage",
 CellID->4409]
}, Open  ]],
Cell[CellGroupData[{
Cell[1813, 63, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2291, 80, 241, 9, 70, "Notes",
 CellID->2469]
}, Closed]],
Cell[CellGroupData[{
Cell[2569, 94, 314, 9, 70, "TutorialsSection",
 CellID->15881],
Cell[2886, 105, 175, 4, 70, "Tutorials",
 CellID->25239]
}, Open  ]],
Cell[3076, 112, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

