(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8266,        272]
NotebookOptionsPosition[      6558,        218]
NotebookOutlinePosition[      7619,        247]
CellTagsIndexPosition[      7576,        244]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeuteronMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/DeuteronMagneticMoment"], 
          "ElectronMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronMagneticMoment"], "MuonMass" :> 
          Documentation`HelpLookup["paclet:PhysicalConstants/ref/MuonMass"], 
          "MuonGFactor" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/MuonGFactor"], 
          "NeutronMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronMagneticMoment"], 
          "ProtonMagneticMoment" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ProtonMagneticMoment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DeuteronMagneticMoment\"\>", 
       2->"\<\"ElectronMagneticMoment\"\>", 3->"\<\"MuonMass\"\>", 
       4->"\<\"MuonGFactor\"\>", 5->"\<\"NeutronMagneticMoment\"\>", 
       6->"\<\"ProtonMagneticMoment\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MuonMagneticMoment", "ObjectName",
 CellID->25521],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MuonMagneticMoment"], "InlineFormula"],
     " \[LineSeparator]is the muon magnetic moment."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21044]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MuonMagneticMoment"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"], "/", 
   ButtonBox["Tesla",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tesla"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14502]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25131],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeuteronMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/DeuteronMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MuonGFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/MuonGFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonMagneticMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonMagneticMoment"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10388]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31057],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->32120]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MuonMagneticMoment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 22.4855926}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "MuonMagneticMoment is the muon magnetic moment.", "synonyms" -> {}, 
    "title" -> "MuonMagneticMoment", "type" -> "Symbol", "uri" -> 
    "PhysicalConstants/ref/MuonMagneticMoment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2092, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2715, 76, 56, 1, 70, "ObjectName",
 CellID->25521],
Cell[2774, 79, 336, 10, 70, "Usage",
 CellID->21044]
}, Open  ]],
Cell[CellGroupData[{
Cell[3147, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3625, 111, 360, 13, 70, "Notes",
 CellID->14502]
}, Closed]],
Cell[CellGroupData[{
Cell[4022, 129, 311, 9, 70, "SeeAlsoSection",
 CellID->25131],
Cell[4336, 140, 1651, 53, 70, "SeeAlso",
 CellID->10388]
}, Open  ]],
Cell[CellGroupData[{
Cell[6024, 198, 314, 9, 70, "TutorialsSection",
 CellID->31057],
Cell[6341, 209, 175, 4, 70, "Tutorials",
 CellID->32120]
}, Open  ]],
Cell[6531, 216, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

