(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7550,        256]
NotebookOptionsPosition[      5763,        200]
NotebookOutlinePosition[      6854,        229]
CellTagsIndexPosition[      6811,        226]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["PHYSICAL CONSTANTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Physical Constants Package" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/tutorial/PhysicalConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Physical Constants Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ElectronComptonWavelength" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ElectronComptonWavelength"], 
          "NeutronMass" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/NeutronMass"], 
          "ProtonComptonWavelength" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/ProtonComptonWavelength"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ElectronComptonWavelength\"\>", 
       2->"\<\"NeutronMass\"\>", 
       3->"\<\"ProtonComptonWavelength\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NeutronComptonWavelength", "ObjectName",
 CellID->28646],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["NeutronComptonWavelength"], "InlineFormula"],
     " \[LineSeparator]is the neutron Compton wavelength."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["NeutronComptonWavelength"], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlanckConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/PlanckConstant"], "/", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["NeutronMass",
      BaseStyle->"Link",
      ButtonData->"paclet:PhysicalConstants/ref/NeutronMass"], "*", 
     ButtonBox["SpeedOfLight",
      BaseStyle->"Link",
      ButtonData->"paclet:PhysicalConstants/ref/SpeedOfLight"]}], ")"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->25038],

Cell[TextData[{
 Cell[BoxData["NeutronComptonWavelength"], "InlineFormula"],
 " is given in units of ",
 Cell[BoxData[
  ButtonBox["Meter",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Meter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9289]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25453],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronComptonWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ElectronComptonWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NeutronMass",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/NeutronMass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProtonComptonWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/ProtonComptonWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2690],

Cell[TextData[ButtonBox["Physical Constants Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PhysicalConstants/tutorial/PhysicalConstants"]], "Tutorials",
 CellID->9033]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NeutronComptonWavelength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 5, 22.8449768}", "context" -> 
    "PhysicalConstants`", "keywords" -> {}, "index" -> True, "label" -> 
    "Physical Constants Package Symbol", "language" -> "en", "paclet" -> 
    "PhysicalConstants Package", "status" -> "None", "summary" -> 
    "NeutronComptonWavelength is the neutron Compton wavelength.", 
    "synonyms" -> {}, "title" -> "NeutronComptonWavelength", "type" -> 
    "Symbol", "uri" -> "PhysicalConstants/ref/NeutronComptonWavelength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1630, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2253, 68, 62, 1, 70, "ObjectName",
 CellID->28646],
Cell[2318, 71, 347, 10, 70, "Usage",
 CellID->6718]
}, Open  ]],
Cell[CellGroupData[{
Cell[2702, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3180, 103, 585, 19, 70, "Notes",
 CellID->25038],
Cell[3768, 124, 255, 9, 70, "Notes",
 CellID->9289]
}, Closed]],
Cell[CellGroupData[{
Cell[4060, 138, 311, 9, 70, "SeeAlsoSection",
 CellID->25453],
Cell[4374, 149, 820, 26, 70, "SeeAlso",
 CellID->24544]
}, Open  ]],
Cell[CellGroupData[{
Cell[5231, 180, 313, 9, 70, "TutorialsSection",
 CellID->2690],
Cell[5547, 191, 174, 4, 70, "Tutorials",
 CellID->9033]
}, Open  ]],
Cell[5736, 198, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

